/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.InputModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InputModeScreenView
extends AbstractScreenView {
    private final int row;
    private final InputModeScreenPresenter inputModeScreenPresenter;

    public InputModeScreenView(Screen screen, Terminal terminal, int row, String message, List<String> histories, Function<String, ScreenView> resultListener) {
        super(screen, terminal);
        this.row = row;
        this.inputModeScreenPresenter = new InputModeScreenPresenter(this, message, histories, resultListener);
    }

    @Override
    public void init() {
        this.inputModeScreenPresenter.init();
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        switch (keyPress.getType()) {
            case Enter: {
                return this.inputModeScreenPresenter.returnToNextScreen();
            }
            case Character: {
                this.inputModeScreenPresenter.character(keyPress.getCharacter());
                break;
            }
            case Backspace: {
                this.inputModeScreenPresenter.backspace();
                break;
            }
            case Delete: {
                this.inputModeScreenPresenter.delete();
                break;
            }
            case ArrowLeft: {
                this.inputModeScreenPresenter.arrowLeft();
                break;
            }
            case ArrowRight: {
                this.inputModeScreenPresenter.arrowRight();
                break;
            }
            case Home: {
                this.inputModeScreenPresenter.home();
                break;
            }
            case End: {
                this.inputModeScreenPresenter.end();
                break;
            }
            case ArrowUp: {
                this.inputModeScreenPresenter.arrowUp();
                break;
            }
            case ArrowDown: {
                this.inputModeScreenPresenter.arrowDown();
                break;
            }
        }
        return this;
    }

    public void showInput(String message, String inputString, int cursorPosition) {
        this.getTerminalPrinter(this.row).startBold().print(message).stopBold().print(" ").print(inputString).endOfLine();
        this.setCursorPosition(message.length() + 1 + cursorPosition, this.row);
        this.refreshTerminal();
    }
}

