/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import java.util.Objects;
import org.apache.hadoop.hbase.hbtop.terminal.Attributes;
import org.apache.hadoop.hbase.hbtop.terminal.Color;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.hadoop.hbase.hbtop.terminal.impl.ScreenBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TerminalPrinterImpl
implements TerminalPrinter {
    private final ScreenBuffer screenBuffer;
    private int row;
    private int column;
    private final Attributes attributes = new Attributes();

    TerminalPrinterImpl(ScreenBuffer screenBuffer, int startRow) {
        this.screenBuffer = Objects.requireNonNull(screenBuffer);
        this.row = startRow;
    }

    @Override
    public TerminalPrinter print(String value) {
        this.screenBuffer.putString(this.column, this.row, value, this.attributes);
        this.column += value.length();
        return this;
    }

    @Override
    public TerminalPrinter startHighlight() {
        this.attributes.setForegroundColor(Color.BLACK);
        this.attributes.setBackgroundColor(Color.WHITE);
        return this;
    }

    @Override
    public TerminalPrinter stopHighlight() {
        this.attributes.setForegroundColor(Color.WHITE);
        this.attributes.setBackgroundColor(Color.BLACK);
        return this;
    }

    @Override
    public TerminalPrinter startBold() {
        this.attributes.setBold(true);
        return this;
    }

    @Override
    public TerminalPrinter stopBold() {
        this.attributes.setBold(false);
        return this;
    }

    @Override
    public void endOfLine() {
        this.screenBuffer.endOfLine(this.column, this.row);
        ++this.row;
        this.column = 0;
    }
}

