/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class KeyOnlyFilter
extends FilterBase {
    boolean lenAsVal;

    public KeyOnlyFilter() {
        this(false);
    }

    public KeyOnlyFilter(boolean lenAsVal) {
        this.lenAsVal = lenAsVal;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    public Cell transformCell(Cell cell) {
        return this.createKeyOnlyCell(cell);
    }

    private Cell createKeyOnlyCell(Cell c) {
        if (c instanceof ByteBufferExtendedCell) {
            return new KeyOnlyByteBufferExtendedCell((ByteBufferExtendedCell)c, this.lenAsVal);
        }
        return new KeyOnlyCell(c, this.lenAsVal);
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return this.filterCell(ignored);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.isEmpty() || filterArguments.size() == 1, "Expected: 0 or 1 but got: %s", filterArguments.size());
        KeyOnlyFilter filter = new KeyOnlyFilter();
        if (filterArguments.size() == 1) {
            filter.lenAsVal = ParseFilter.convertByteArrayToBoolean(filterArguments.get(0));
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.KeyOnlyFilter.Builder builder = FilterProtos.KeyOnlyFilter.newBuilder();
        builder.setLenAsVal(this.lenAsVal);
        return builder.build().toByteArray();
    }

    public static KeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.KeyOnlyFilter proto;
        try {
            proto = FilterProtos.KeyOnlyFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new KeyOnlyFilter(proto.getLenAsVal());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyOnlyFilter)) {
            return false;
        }
        KeyOnlyFilter other = (KeyOnlyFilter)o;
        return this.lenAsVal == other.lenAsVal;
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.lenAsVal);
    }

    static class KeyOnlyByteBufferExtendedCell
    extends ByteBufferExtendedCell {
        public static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 1;
        private ByteBufferExtendedCell cell;
        private boolean lenAsVal;

        public KeyOnlyByteBufferExtendedCell(ByteBufferExtendedCell c, boolean lenAsVal) {
            this.cell = c;
            this.lenAsVal = lenAsVal;
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public void setSequenceId(long seqId) throws IOException {
            this.cell.setSequenceId(seqId);
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            this.cell.setTimestamp(ts);
        }

        @Override
        public void setTimestamp(byte[] ts) throws IOException {
            this.cell.setTimestamp(ts);
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public Cell.Type getType() {
            return this.cell.getType();
        }

        @Override
        public byte[] getValueArray() {
            if (this.lenAsVal) {
                return Bytes.toBytes(this.cell.getValueLength());
            }
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            if (this.lenAsVal) {
                return 4;
            }
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.cell.getRowByteBuffer();
        }

        @Override
        public int getRowPosition() {
            return this.cell.getRowPosition();
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.cell.getFamilyByteBuffer();
        }

        @Override
        public int getFamilyPosition() {
            return this.cell.getFamilyPosition();
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.cell.getQualifierByteBuffer();
        }

        @Override
        public int getQualifierPosition() {
            return this.cell.getQualifierPosition();
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            if (this.lenAsVal) {
                return ByteBuffer.wrap(Bytes.toBytes(this.cell.getValueLength()));
            }
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getValuePosition() {
            return 0;
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getTagsPosition() {
            return 0;
        }

        @Override
        public Iterator<Tag> getTags() {
            return Collections.emptyIterator();
        }

        @Override
        public Optional<Tag> getTag(byte type) {
            return Optional.empty();
        }

        @Override
        public long heapSize() {
            return ClassSize.align((long)FIXED_OVERHEAD + this.cell.heapSize());
        }
    }

    static class KeyOnlyCell
    implements Cell {
        private Cell cell;
        private int keyLen;
        private boolean lenAsVal;

        public KeyOnlyCell(Cell c, boolean lenAsVal) {
            this.cell = c;
            this.lenAsVal = lenAsVal;
            this.keyLen = KeyValueUtil.keyLength(c);
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public Cell.Type getType() {
            return this.cell.getType();
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            if (this.lenAsVal) {
                return Bytes.toBytes(this.cell.getValueLength());
            }
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            if (this.lenAsVal) {
                return 4;
            }
            return 0;
        }

        @Override
        public int getSerializedSize() {
            return 8 + this.keyLen + this.getValueLength();
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }

        @Override
        public long heapSize() {
            return this.cell.heapSize();
        }
    }
}

