/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.util.RetriableCommand;

public class RetriableDirectoryCreateCommand
extends RetriableCommand {
    public RetriableDirectoryCreateCommand(String description) {
        super(description);
    }

    @Override
    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 3) : "Unexpected argument list.";
        Path target = (Path)arguments[0];
        Mapper.Context context = (Mapper.Context)arguments[1];
        FileStatus sourceStatus = (FileStatus)arguments[2];
        FileSystem targetFS = target.getFileSystem(context.getConfiguration());
        if (!targetFS.mkdirs(target)) {
            return false;
        }
        boolean preserveEC = CopyMapper.getFileAttributeSettings(context).contains((Object)DistCpOptions.FileAttribute.ERASURECODINGPOLICY);
        if (preserveEC && sourceStatus.isErasureCoded() && targetFS instanceof DistributedFileSystem) {
            ErasureCodingPolicy ecPolicy = ((HdfsFileStatus)sourceStatus).getErasureCodingPolicy();
            DistributedFileSystem dfs = (DistributedFileSystem)targetFS;
            dfs.setErasureCodingPolicy(target, ecPolicy.getName());
        }
        return true;
    }
}

