/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerForTest;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestMergesSplitsAddToTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMergesSplitsAddToTracker.class);
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String FAMILY_NAME_STR = "info";
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setupClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() {
        StoreFileTrackerForTest.clear();
    }

    private TableName createTable(byte[] splitKey) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.name.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME)).setValue("hbase.store.file-tracker.impl", StoreFileTrackerForTest.class.getName()).build();
        if (splitKey != null) {
            TEST_UTIL.getAdmin().createTable(td, (byte[][])new byte[][]{splitKey});
        } else {
            TEST_UTIL.getAdmin().createTable(td);
        }
        return td.getTableName();
    }

    @Test
    public void testCommitDaughterRegion() throws Exception {
        TableName table = this.createTable(null);
        this.putThreeRowsAndFlush(table);
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(table).get(0);
        HRegionFileSystem regionFS = ((HStore)region.getStores().get(0)).getRegionFileSystem();
        RegionInfo daughterA = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(region.getRegionInfo().getStartKey()).setEndKey(Bytes.toBytes((String)"002")).setSplit(false).setRegionId(region.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        RegionInfo daughterB = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(Bytes.toBytes((String)"002")).setEndKey(region.getRegionInfo().getEndKey()).setSplit(false).setRegionId(region.getRegionInfo().getRegionId()).build();
        HStoreFile file = (HStoreFile)region.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        ArrayList<Path> splitFilesA = new ArrayList<Path>();
        HRegionFileSystem regionFs = region.getRegionFileSystem();
        StoreFileTracker sft = StoreFileTrackerFactory.create((Configuration)region.getBaseConf(), (boolean)true, (StoreContext)StoreContext.getBuilder().withFamilyStoreDirectoryPath(new Path(regionFs.getRegionDir(), FAMILY_NAME_STR)).withRegionFileSystem(regionFs).build());
        splitFilesA.add(regionFS.splitStoreFile(daughterA, Bytes.toString((byte[])FAMILY_NAME), file, Bytes.toBytes((String)"002"), false, region.getSplitPolicy(), sft));
        ArrayList<Path> splitFilesB = new ArrayList<Path>();
        splitFilesB.add(regionFS.splitStoreFile(daughterB, Bytes.toString((byte[])FAMILY_NAME), file, Bytes.toBytes((String)"002"), true, region.getSplitPolicy(), sft));
        MasterProcedureEnv env = (MasterProcedureEnv)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        Path resultA = regionFS.commitDaughterRegion(daughterA, splitFilesA, env);
        Path resultB = regionFS.commitDaughterRegion(daughterB, splitFilesB, env);
        FileSystem fs = regionFS.getFileSystem();
        this.verifyFilesAreTracked(resultA, fs);
        this.verifyFilesAreTracked(resultB, fs);
    }

    @Test
    public void testCommitMergedRegion() throws Exception {
        TableName table = this.createTable(null);
        this.split(table, Bytes.toBytes((String)"002"));
        this.putThreeRowsAndFlush(table);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table);
        HRegion first = regions.get(0);
        HRegion second = regions.get(1);
        HRegionFileSystem regionFS = first.getRegionFileSystem();
        RegionInfo mergeResult = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(first.getRegionInfo().getStartKey()).setEndKey(second.getRegionInfo().getEndKey()).setSplit(false).setRegionId(first.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        HRegionFileSystem mergeFS = HRegionFileSystem.createRegionOnFileSystem((Configuration)TEST_UTIL.getHBaseCluster().getMaster().getConfiguration(), (FileSystem)regionFS.getFileSystem(), (Path)regionFS.getTableDir(), (RegionInfo)mergeResult);
        ArrayList<Path> mergedFiles = new ArrayList<Path>();
        mergedFiles.add(this.mergeFileFromRegion(first, mergeFS));
        mergedFiles.add(this.mergeFileFromRegion(second, mergeFS));
        MasterProcedureEnv env = (MasterProcedureEnv)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        mergeFS.commitMergedRegion(mergedFiles, env);
        FileSystem fs = first.getRegionFileSystem().getFileSystem();
        Path finalMergeDir = new Path(first.getRegionFileSystem().getTableDir(), mergeResult.getEncodedName());
        this.verifyFilesAreTracked(finalMergeDir, fs);
    }

    @Test
    public void testSplitLoadsFromTracker() throws Exception {
        TableName table = this.createTable(null);
        this.putThreeRowsAndFlush(table);
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(table).get(0);
        Pair<StoreFileInfo, String> copyResult = this.copyFileInTheStoreDir(region);
        StoreFileInfo fileInfo = (StoreFileInfo)copyResult.getFirst();
        String copyName = (String)copyResult.getSecond();
        this.split(table, Bytes.toBytes((String)"002"));
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table);
        HRegion first = regions.get(0);
        this.validateDaughterRegionsFiles(first, fileInfo.getActiveFileName(), copyName);
        HRegion second = regions.get(1);
        this.validateDaughterRegionsFiles(second, fileInfo.getActiveFileName(), copyName);
    }

    private void split(TableName table, byte[] splitKey) throws IOException {
        TEST_UTIL.getAdmin().split(table, splitKey);
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getHBaseCluster().getRegions(table).size() == 2);
    }

    @Test
    public void testMergeLoadsFromTracker() throws Exception {
        TableName table = this.createTable(Bytes.toBytes((String)"002"));
        this.putThreeRowsAndFlush(table);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table);
        HRegion first = regions.get(0);
        Pair<StoreFileInfo, String> copyResult = this.copyFileInTheStoreDir(first);
        StoreFileInfo fileInfo = (StoreFileInfo)copyResult.getFirst();
        String copyName = (String)copyResult.getSecond();
        TEST_UTIL.getAdmin().mergeRegionsAsync((byte[][])new byte[][]{first.getRegionInfo().getEncodedNameAsBytes(), regions.get(1).getRegionInfo().getEncodedNameAsBytes()}, true).get(10L, TimeUnit.SECONDS);
        regions = TEST_UTIL.getHBaseCluster().getRegions(table);
        HRegion merged = regions.get(0);
        this.validateDaughterRegionsFiles(merged, fileInfo.getActiveFileName(), copyName);
    }

    private Pair<StoreFileInfo, String> copyFileInTheStoreDir(HRegion region) throws IOException {
        Path storeDir = region.getRegionFileSystem().getStoreDir(FAMILY_NAME_STR);
        HRegionFileSystem regionFs = region.getRegionFileSystem();
        StoreFileTracker sft = StoreFileTrackerFactory.create((Configuration)region.getBaseConf(), (boolean)false, (StoreContext)StoreContext.getBuilder().withFamilyStoreDirectoryPath(storeDir).withColumnFamilyDescriptor(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME)).withRegionFileSystem(regionFs).build());
        List infos = sft.load();
        StoreFileInfo fileInfo = (StoreFileInfo)infos.get(0);
        String copyName = UUID.randomUUID().toString().replaceAll("-", "");
        Path copy = new Path(storeDir, copyName);
        FileUtil.copy((FileSystem)region.getFilesystem(), (FileStatus)fileInfo.getFileStatus(), (FileSystem)region.getFilesystem(), (Path)copy, (boolean)false, (boolean)false, (Configuration)TEST_UTIL.getConfiguration());
        return new Pair((Object)fileInfo, (Object)copyName);
    }

    private void validateDaughterRegionsFiles(HRegion region, String originalFileName, String untrackedFile) throws IOException {
        HRegionFileSystem regionFs = region.getRegionFileSystem();
        StoreFileTracker sft = StoreFileTrackerFactory.create((Configuration)regionFs.getFileSystem().getConf(), (boolean)false, (StoreContext)StoreContext.getBuilder().withFamilyStoreDirectoryPath(new Path(regionFs.getRegionDir(), FAMILY_NAME_STR)).withColumnFamilyDescriptor(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME)).withRegionFileSystem(regionFs).build());
        List infos = sft.load();
        MatcherAssert.assertThat((Object)infos, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"activeFileName", (Matcher)Matchers.not((Matcher)Matchers.containsString((String)untrackedFile)))));
        MatcherAssert.assertThat((Object)infos, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"activeFileName", (Matcher)Matchers.containsString((String)originalFileName))));
    }

    private void verifyFilesAreTracked(Path regionDir, FileSystem fs) throws Exception {
        for (FileStatus f : fs.listStatus(new Path(regionDir, FAMILY_NAME_STR))) {
            Assert.assertTrue((boolean)StoreFileTrackerForTest.tracked(regionDir.getName(), FAMILY_NAME_STR, f.getPath()));
        }
    }

    private Path mergeFileFromRegion(HRegion regionToMerge, HRegionFileSystem mergeFS) throws IOException {
        HStoreFile file = (HStoreFile)regionToMerge.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        HRegionFileSystem regionFs = regionToMerge.getRegionFileSystem();
        StoreFileTracker sft = StoreFileTrackerFactory.create((Configuration)regionToMerge.getBaseConf(), (boolean)true, (StoreContext)StoreContext.getBuilder().withFamilyStoreDirectoryPath(new Path(regionFs.getRegionDir(), FAMILY_NAME_STR)).withRegionFileSystem(regionFs).build());
        return mergeFS.mergeStoreFile(regionToMerge.getRegionInfo(), Bytes.toString((byte[])FAMILY_NAME), file, sft);
    }

    private void putThreeRowsAndFlush(TableName table) throws IOException {
        Table tbl = TEST_UTIL.getConnection().getTable(table);
        Put put = new Put(Bytes.toBytes((String)"001"));
        byte[] qualifier = Bytes.toBytes((String)"1");
        put.addColumn(FAMILY_NAME, qualifier, Bytes.toBytes((int)1));
        tbl.put(put);
        put = new Put(Bytes.toBytes((String)"002"));
        put.addColumn(FAMILY_NAME, qualifier, Bytes.toBytes((int)2));
        tbl.put(put);
        put = new Put(Bytes.toBytes((String)"003"));
        put.addColumn(FAMILY_NAME, qualifier, Bytes.toBytes((int)2));
        tbl.put(put);
        TEST_UTIL.flush(table);
    }
}

