/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class Deserializer {
    private final FieldDeserializer fieldDeserializer;

    Record deserialize(Object data) {
        return (Record)this.fieldDeserializer.value(data);
    }

    private Deserializer(Schema schema, ObjectInspectorPair pair) {
        this.fieldDeserializer = DeserializerVisitor.visit(schema, pair);
    }

    private static interface FieldDeserializer {
        public Object value(Object var1);
    }

    private static class DeserializerVisitor
    extends SchemaWithPartnerVisitor<ObjectInspectorPair, FieldDeserializer> {
        private DeserializerVisitor() {
        }

        public static FieldDeserializer visit(Schema schema, ObjectInspectorPair pair) {
            return DeserializerVisitor.visit(schema, new FixNameMappingObjectInspectorPair(schema, pair), new DeserializerVisitor(), new PartnerObjectInspectorByNameAccessors());
        }

        @Override
        public FieldDeserializer schema(Schema schema, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return deserializer;
        }

        @Override
        public FieldDeserializer field(Types.NestedField field, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return deserializer;
        }

        @Override
        public FieldDeserializer primitive(Type.PrimitiveType type, ObjectInspectorPair pair) {
            return o -> {
                if (o == null) {
                    return null;
                }
                ObjectInspector writerFieldInspector = pair.writerInspector();
                ObjectInspector sourceFieldInspector = pair.sourceInspector();
                Object result = ((PrimitiveObjectInspector)sourceFieldInspector).getPrimitiveJavaObject(o);
                if (writerFieldInspector instanceof WriteObjectInspector) {
                    result = ((WriteObjectInspector)writerFieldInspector).convert(result);
                }
                return result;
            };
        }

        @Override
        public FieldDeserializer struct(Types.StructType type, ObjectInspectorPair pair, List<FieldDeserializer> deserializers) {
            return o -> {
                if (o == null) {
                    return null;
                }
                List data = ((StructObjectInspector)pair.sourceInspector()).getStructFieldsDataAsList(o);
                GenericRecord result = GenericRecord.create(type);
                for (int i = 0; i < deserializers.size(); ++i) {
                    Object fieldValue = data.get(i);
                    if (fieldValue != null) {
                        result.set(i, ((FieldDeserializer)deserializers.get(i)).value(fieldValue));
                        continue;
                    }
                    result.set(i, null);
                }
                return result;
            };
        }

        @Override
        public FieldDeserializer list(Types.ListType listTypeInfo, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return o -> {
                if (o == null) {
                    return null;
                }
                LinkedList<Object> result = Lists.newLinkedList();
                ListObjectInspector listInspector = (ListObjectInspector)pair.sourceInspector();
                for (Object val : listInspector.getList(o)) {
                    result.add(deserializer.value(val));
                }
                return result;
            };
        }

        @Override
        public FieldDeserializer map(Types.MapType mapType, ObjectInspectorPair pair, FieldDeserializer keyDeserializer, FieldDeserializer valueDeserializer) {
            return o -> {
                if (o == null) {
                    return null;
                }
                HashMap<Object, Object> result = Maps.newHashMap();
                MapObjectInspector mapObjectInspector = (MapObjectInspector)pair.sourceInspector();
                for (Map.Entry entry : mapObjectInspector.getMap(o).entrySet()) {
                    result.put(keyDeserializer.value(entry.getKey()), valueDeserializer.value(entry.getValue()));
                }
                return result;
            };
        }
    }

    private static class ObjectInspectorPair {
        private final ObjectInspector writerInspector;
        private final ObjectInspector sourceInspector;

        ObjectInspectorPair(ObjectInspector writerInspector, ObjectInspector sourceInspector) {
            this.writerInspector = writerInspector;
            this.sourceInspector = sourceInspector;
        }

        ObjectInspector writerInspector() {
            return this.writerInspector;
        }

        ObjectInspector sourceInspector() {
            return this.sourceInspector;
        }

        String sourceName(String originalName) {
            return originalName;
        }
    }

    private static class FixNameMappingObjectInspectorPair
    extends ObjectInspectorPair {
        private final Map<String, String> sourceNameMap;

        FixNameMappingObjectInspectorPair(Schema schema, ObjectInspectorPair pair) {
            super(pair.writerInspector(), pair.sourceInspector());
            this.sourceNameMap = Maps.newHashMapWithExpectedSize(schema.columns().size());
            List fields = ((StructObjectInspector)this.sourceInspector()).getAllStructFieldRefs();
            for (int i = 0; i < schema.columns().size(); ++i) {
                this.sourceNameMap.put(schema.columns().get(i).name(), ((StructField)fields.get(i)).getFieldName());
            }
        }

        @Override
        String sourceName(String originalName) {
            return this.sourceNameMap.get(originalName);
        }
    }

    private static class PartnerObjectInspectorByNameAccessors
    implements SchemaWithPartnerVisitor.PartnerAccessors<ObjectInspectorPair> {
        private PartnerObjectInspectorByNameAccessors() {
        }

        @Override
        public ObjectInspectorPair fieldPartner(ObjectInspectorPair pair, int fieldId, String name) {
            String sourceName = pair.sourceName(name);
            return new ObjectInspectorPair(((StructObjectInspector)pair.writerInspector()).getStructFieldRef(name).getFieldObjectInspector(), ((StructObjectInspector)pair.sourceInspector()).getStructFieldRef(sourceName).getFieldObjectInspector());
        }

        @Override
        public ObjectInspectorPair mapKeyPartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((MapObjectInspector)pair.writerInspector()).getMapKeyObjectInspector(), ((MapObjectInspector)pair.sourceInspector()).getMapKeyObjectInspector());
        }

        @Override
        public ObjectInspectorPair mapValuePartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((MapObjectInspector)pair.writerInspector()).getMapValueObjectInspector(), ((MapObjectInspector)pair.sourceInspector()).getMapValueObjectInspector());
        }

        @Override
        public ObjectInspectorPair listElementPartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((ListObjectInspector)pair.writerInspector()).getListElementObjectInspector(), ((ListObjectInspector)pair.sourceInspector()).getListElementObjectInspector());
        }
    }

    static class Builder {
        private Schema schema;
        private StructObjectInspector writerInspector;
        private StructObjectInspector sourceInspector;

        Builder() {
        }

        Builder schema(Schema mainSchema) {
            this.schema = mainSchema;
            return this;
        }

        Builder writerInspector(StructObjectInspector inspector) {
            this.writerInspector = inspector;
            return this;
        }

        Builder sourceInspector(StructObjectInspector inspector) {
            this.sourceInspector = inspector;
            return this;
        }

        Deserializer build() {
            return new Deserializer(this.schema, new ObjectInspectorPair((ObjectInspector)this.writerInspector, (ObjectInspector)this.sourceInspector));
        }
    }
}

