/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.ExecutionContextThreadedImpl;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.util.NucleusLogger;

public class ExecutionContextPool {
    private PersistenceNucleusContext nucCtx;
    private long maxIdle = 20L;
    private long expirationTime;
    private Map<ExecutionContext, Long> recyclableECs = new ConcurrentHashMap<ExecutionContext, Long>();
    private CleanUpThread cleaner;

    public ExecutionContextPool(PersistenceNucleusContext nucCtx) {
        this.maxIdle = nucCtx.getConfiguration().getIntProperty("datanucleus.executioncontext.maxidle");
        this.nucCtx = nucCtx;
        this.expirationTime = 30000L;
        if (nucCtx.getConfiguration().getBooleanProperty("datanucleus.executioncontext.reaperthread")) {
            this.cleaner = new CleanUpThread(this, this.expirationTime * 2L);
            this.cleaner.start();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("Started pool of ExecutionContext (maxPool=" + this.maxIdle + ", reaperThread=" + (this.cleaner != null) + ")");
        }
    }

    public synchronized ExecutionContext checkOut(Object owner, Map<String, Object> options) {
        long now = System.currentTimeMillis();
        if (!this.recyclableECs.isEmpty()) {
            Iterator<Map.Entry<ExecutionContext, Long>> recycIter = this.recyclableECs.entrySet().iterator();
            while (recycIter.hasNext()) {
                Map.Entry<ExecutionContext, Long> recycEntry = recycIter.next();
                ExecutionContext ec = recycEntry.getKey();
                if (now - recycEntry.getValue() > this.expirationTime) {
                    recycIter.remove();
                    this.expire(ec);
                    ec = null;
                    continue;
                }
                if (this.validate(ec)) {
                    recycIter.remove();
                    ec.initialise(owner, options);
                    return ec;
                }
                recycIter.remove();
                this.expire(ec);
                ec = null;
            }
        }
        if (this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.multithreaded")) {
            return new ExecutionContextThreadedImpl(this.nucCtx, owner, options);
        }
        return new ExecutionContextImpl(this.nucCtx, owner, options);
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<ExecutionContext, Long>> recycIter = this.recyclableECs.entrySet().iterator();
        while (recycIter.hasNext()) {
            Map.Entry<ExecutionContext, Long> recycEntry = recycIter.next();
            ExecutionContext ec = recycEntry.getKey();
            if (now - recycEntry.getValue() <= this.expirationTime) continue;
            recycIter.remove();
            this.expire(ec);
            ec = null;
        }
    }

    public synchronized void checkIn(ExecutionContext ec) {
        if ((long)this.recyclableECs.size() < this.maxIdle) {
            this.recyclableECs.put(ec, System.currentTimeMillis());
        }
    }

    protected boolean validate(ExecutionContext ec) {
        return true;
    }

    protected void expire(ExecutionContext ec) {
    }

    class CleanUpThread
    extends Thread {
        private ExecutionContextPool pool;
        private long sleepTime;

        CleanUpThread(ExecutionContextPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.pool.cleanUp();
            }
        }
    }
}

