/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.sql.Timestamp;
import org.datanucleus.FetchPlanState;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.SCO;

public class SqlTimestamp
extends Timestamp
implements SCO<Timestamp> {
    protected transient DNStateManager ownerSM;
    protected transient AbstractMemberMetaData ownerMmd;

    public SqlTimestamp(DNStateManager sm, AbstractMemberMetaData mmd) {
        super(0L);
        this.ownerSM = sm;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise() {
    }

    @Override
    public void initialise(Timestamp newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(Timestamp ts) {
        super.setTime(ts.getTime());
        super.setNanos(ts.getNanos());
    }

    @Override
    public Timestamp getValue() {
        Timestamp ts = new Timestamp(this.getTime());
        ts.setNanos(this.getNanos());
        return ts;
    }

    @Override
    public void unsetOwner() {
        this.ownerSM = null;
        this.ownerMmd = null;
    }

    @Override
    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
            if (!this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
    }

    @Override
    public Timestamp detachCopy(FetchPlanState state) {
        Timestamp ts = new Timestamp(this.getTime());
        ts.setNanos(this.getNanos());
        return ts;
    }

    @Override
    public void attachCopy(Timestamp value) {
        long oldValue = this.getTime();
        this.initialise(value);
        long newValue = value.getTime();
        if (oldValue != newValue) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((SqlTimestamp)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        this.makeDirty();
    }

    @Override
    public void setNanos(int time_nanos) {
        super.setNanos(time_nanos);
        this.makeDirty();
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        super.setYear(year);
        this.makeDirty();
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        super.setMonth(month);
        this.makeDirty();
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        super.setDate(date);
        this.makeDirty();
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        super.setHours(hours);
        this.makeDirty();
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        super.setMinutes(minutes);
        this.makeDirty();
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        super.setSeconds(seconds);
        this.makeDirty();
    }

    protected Object writeReplace() throws ObjectStreamException {
        Timestamp ts = new Timestamp(this.getTime());
        ts.setNanos(this.getNanos());
        return ts;
    }
}

