/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.AbstractHMSHandlerProxy;
import org.apache.hadoop.hive.metastore.ExceptionHandler;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSHandlerProxyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HMSHandlerProxyFactory.class);

    public static IHMSHandler getProxy(Configuration conf, IHMSHandler handler, boolean local) throws MetaException {
        String hmsHandlerProxyName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_PROXY_CLASS);
        LOG.info("Creating HMSHandler proxy by class: {}", (Object)hmsHandlerProxyName);
        Class proxyClass = JavaUtils.getClass((String)hmsHandlerProxyName, AbstractHMSHandlerProxy.class);
        AbstractHMSHandlerProxy invocationHandler = null;
        try {
            invocationHandler = (AbstractHMSHandlerProxy)JavaUtils.newInstance((Class)proxyClass, (Class[])new Class[]{Configuration.class, IHMSHandler.class, Boolean.TYPE}, (Object[])new Object[]{conf, handler, local});
        }
        catch (Throwable t) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            if (rootCause instanceof Exception) {
                throw ExceptionHandler.newMetaException((Exception)rootCause);
            }
            throw t;
        }
        return (IHMSHandler)Proxy.newProxyInstance(HMSHandlerProxyFactory.class.getClassLoader(), new Class[]{IHMSHandler.class}, (InvocationHandler)invocationHandler);
    }
}

