/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;

public class GetPartitionProjectionsSpecBuilder {
    private List<String> fieldList = new ArrayList<String>();
    private String includePartitionPattern = null;
    private String excludePartitionPattern = null;

    public GetPartitionProjectionsSpecBuilder addProjectField(String field) {
        this.fieldList.add(field);
        return this;
    }

    public GetPartitionProjectionsSpecBuilder addProjectFieldList(List<String> fields) {
        this.fieldList.addAll(Arrays.asList("catName", "dbName", "tableName"));
        if (CollectionUtils.isNotEmpty(fields)) {
            this.fieldList.addAll(fields);
        }
        return this;
    }

    public GetPartitionProjectionsSpecBuilder setIncludePartitionPattern(String includePartitionPattern) {
        this.includePartitionPattern = includePartitionPattern;
        return this;
    }

    public GetPartitionProjectionsSpecBuilder setExcludePartitionPattern(String excludePartitionPattern) {
        this.excludePartitionPattern = excludePartitionPattern;
        return this;
    }

    public GetProjectionsSpec build() {
        return new GetProjectionsSpec(this.fieldList, this.includePartitionPattern, this.excludePartitionPattern);
    }
}

