/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.ColumnTypeAttributes;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.KuduPredicate;
import org.apache.hive.kudu.org.apache.kudu.client.ProtobufHelper;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hive.kudu.org.apache.kudu.tserver.Tserver;
import org.apache.hive.kudu.org.apache.kudu.util.DecimalUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class ColumnRangePredicate {
    private final Tserver.ColumnRangePredicatePB.Builder pb = Tserver.ColumnRangePredicatePB.newBuilder();
    private final ColumnSchema column;
    private byte[] lowerBound = null;
    private byte[] upperBound = null;

    public ColumnRangePredicate(ColumnSchema column) {
        this.column = column;
        this.pb.setColumn(ProtobufHelper.columnToPb(column));
    }

    private void setLowerBoundInternal(byte[] value) {
        this.lowerBound = value;
        this.pb.setLowerBound(UnsafeByteOperations.unsafeWrap(this.lowerBound));
    }

    private void setUpperBoundInternal(byte[] value) {
        this.upperBound = value;
        this.pb.setInclusiveUpperBound(UnsafeByteOperations.unsafeWrap(this.upperBound));
    }

    private static KuduPredicate toKuduPredicate(ColumnSchema column, KuduPredicate.ComparisonOp op, byte[] bound) {
        if (bound == null) {
            return null;
        }
        switch (column.getType().getDataType(column.getTypeAttributes())) {
            case BOOL: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getBoolean(bound));
            }
            case INT8: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getByte(bound));
            }
            case INT16: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getShort(bound));
            }
            case INT32: 
            case DATE: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getInt(bound));
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getLong(bound));
            }
            case FLOAT: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getFloat(bound));
            }
            case DOUBLE: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getDouble(bound));
            }
            case VARCHAR: 
            case STRING: {
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getString(bound));
            }
            case BINARY: {
                return KuduPredicate.newComparisonPredicate(column, op, bound);
            }
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: {
                ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
                return KuduPredicate.newComparisonPredicate(column, op, Bytes.getDecimal(bound, typeAttributes.getPrecision(), typeAttributes.getScale()));
            }
        }
        throw new IllegalStateException(String.format("unknown column type %s", new Object[]{column.getType()}));
    }

    public KuduPredicate toKuduPredicate() {
        KuduPredicate lower = ColumnRangePredicate.toKuduPredicate(this.column, KuduPredicate.ComparisonOp.GREATER_EQUAL, this.lowerBound);
        KuduPredicate upper = ColumnRangePredicate.toKuduPredicate(this.column, KuduPredicate.ComparisonOp.LESS_EQUAL, this.upperBound);
        if (upper != null && lower != null) {
            return upper.merge(lower);
        }
        if (upper != null) {
            return upper;
        }
        return lower;
    }

    public void setLowerBound(boolean lowerBound) {
        this.checkColumn(Type.BOOL);
        this.setLowerBoundInternal(Bytes.fromBoolean(lowerBound));
    }

    public void setLowerBound(byte lowerBound) {
        this.checkColumn(Type.INT8);
        this.setLowerBoundInternal(new byte[]{lowerBound});
    }

    public void setLowerBound(short lowerBound) {
        this.checkColumn(Type.INT16);
        this.setLowerBoundInternal(Bytes.fromShort(lowerBound));
    }

    public void setLowerBound(int lowerBound) {
        this.checkColumn(Type.INT32);
        this.setLowerBoundInternal(Bytes.fromInt(lowerBound));
    }

    public void setLowerBound(long lowerBound) {
        this.checkColumn(Type.INT64, Type.UNIXTIME_MICROS);
        this.setLowerBoundInternal(Bytes.fromLong(lowerBound));
    }

    public void setLowerBound(String lowerBound) {
        this.checkColumn(Type.STRING, Type.VARCHAR);
        this.setLowerBoundInternal(lowerBound.getBytes(StandardCharsets.UTF_8));
    }

    public void setLowerBound(byte[] lowerBound) {
        this.checkColumn(Type.BINARY);
        this.setLowerBoundInternal(lowerBound);
    }

    public void setLowerBound(float lowerBound) {
        this.checkColumn(Type.FLOAT);
        this.setLowerBoundInternal(Bytes.fromFloat(lowerBound));
    }

    public void setLowerBound(double lowerBound) {
        this.checkColumn(Type.DOUBLE);
        this.setLowerBoundInternal(Bytes.fromDouble(lowerBound));
    }

    public void setLowerBound(BigDecimal lowerBound) {
        this.checkColumn(Type.DECIMAL);
        int precision = this.column.getTypeAttributes().getPrecision();
        int scale = this.column.getTypeAttributes().getScale();
        BigDecimal coercedVal = DecimalUtil.coerce(lowerBound, precision, scale);
        this.setLowerBoundInternal(Bytes.fromBigDecimal(coercedVal, precision));
    }

    public void setUpperBound(boolean upperBound) {
        this.checkColumn(Type.BOOL);
        this.setUpperBoundInternal(Bytes.fromBoolean(upperBound));
    }

    public void setUpperBound(byte upperBound) {
        this.checkColumn(Type.INT8);
        this.setUpperBoundInternal(new byte[]{upperBound});
    }

    public void setUpperBound(short upperBound) {
        this.checkColumn(Type.INT16);
        this.setUpperBoundInternal(Bytes.fromShort(upperBound));
    }

    public void setUpperBound(int upperBound) {
        this.checkColumn(Type.INT32);
        this.setUpperBoundInternal(Bytes.fromInt(upperBound));
    }

    public void setUpperBound(long upperBound) {
        this.checkColumn(Type.INT64, Type.UNIXTIME_MICROS);
        this.setUpperBoundInternal(Bytes.fromLong(upperBound));
    }

    public void setUpperBound(String upperBound) {
        this.checkColumn(Type.STRING, Type.VARCHAR);
        this.setUpperBoundInternal(upperBound.getBytes(StandardCharsets.UTF_8));
    }

    public void setUpperBound(byte[] upperBound) {
        this.checkColumn(Type.BINARY);
        this.setUpperBoundInternal(upperBound);
    }

    public void setUpperBound(float upperBound) {
        this.checkColumn(Type.FLOAT);
        this.setUpperBoundInternal(Bytes.fromFloat(upperBound));
    }

    public void setUpperBound(double upperBound) {
        this.checkColumn(Type.DOUBLE);
        this.setUpperBoundInternal(Bytes.fromDouble(upperBound));
    }

    public void setUpperBound(BigDecimal upperBound) {
        this.checkColumn(Type.DECIMAL);
        int precision = this.column.getTypeAttributes().getPrecision();
        int scale = this.column.getTypeAttributes().getScale();
        BigDecimal coercedVal = DecimalUtil.coerce(upperBound, precision, scale);
        this.setUpperBoundInternal(Bytes.fromBigDecimal(coercedVal, precision));
    }

    public ColumnSchema getColumn() {
        return this.column;
    }

    public byte[] getLowerBound() {
        return this.lowerBound;
    }

    public byte[] getUpperBound() {
        return this.upperBound;
    }

    public static byte[] toByteArray(List<ColumnRangePredicate> predicates) {
        if (predicates.isEmpty()) {
            return null;
        }
        Tserver.ColumnRangePredicateListPB.Builder predicateListBuilder = Tserver.ColumnRangePredicateListPB.newBuilder();
        for (ColumnRangePredicate crp : predicates) {
            predicateListBuilder.addRangePredicates(crp.getPb());
        }
        return predicateListBuilder.build().toByteArray();
    }

    static List<Tserver.ColumnRangePredicatePB> fromByteArray(byte[] listBytes) {
        ArrayList<Tserver.ColumnRangePredicatePB> predicates = new ArrayList<Tserver.ColumnRangePredicatePB>();
        if (listBytes == null || listBytes.length == 0) {
            return predicates;
        }
        Tserver.ColumnRangePredicateListPB list = ColumnRangePredicate.getPbFromBytes(listBytes);
        return list.getRangePredicatesList();
    }

    Tserver.ColumnRangePredicatePB getPb() {
        return this.pb.build();
    }

    static ColumnRangePredicate fromPb(Tserver.ColumnRangePredicatePB pb) {
        ColumnRangePredicate pred = new ColumnRangePredicate(ProtobufHelper.pbToColumnSchema(pb.getColumn()));
        if (pb.hasLowerBound()) {
            pred.setLowerBoundInternal(pb.getLowerBound().toByteArray());
        }
        if (pb.hasInclusiveUpperBound()) {
            pred.setUpperBoundInternal(pb.getInclusiveUpperBound().toByteArray());
        }
        return pred;
    }

    private static Tserver.ColumnRangePredicateListPB getPbFromBytes(byte[] listBytes) {
        try {
            return Tserver.ColumnRangePredicateListPB.parseFrom(listBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Encountered an invalid column range predicate list: " + Bytes.pretty(listBytes), e);
        }
    }

    private void checkColumn(Type ... passedTypes) {
        for (Type type : passedTypes) {
            if (!this.column.getType().equals((Object)type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("%s's type isn't %s, it's %s", this.column.getName(), Arrays.toString((Object[])passedTypes), this.column.getType().getName()));
    }
}

