/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import org.apache.hive.kudu.org.apache.kudu.Common;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.HostAndPort;
import org.apache.hive.kudu.org.apache.kudu.client.ProtobufHelper;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;

class ConnectToClusterResponse {
    private static final ByteString FAKE_TABLET_ID = ByteString.copyFromUtf8("Kudu Master");
    private static final int CACHE_TTL_MS = 3600000;
    private final HostAndPort leaderHostAndPort;
    private final Master.ConnectToMasterResponsePB connectResponse;

    public ConnectToClusterResponse(HostAndPort hostAndPort, Master.ConnectToMasterResponsePB connectResponse) {
        this.leaderHostAndPort = hostAndPort;
        this.connectResponse = connectResponse;
    }

    public Master.ConnectToMasterResponsePB getConnectResponse() {
        return this.connectResponse;
    }

    public HostAndPort getLeaderHostAndPort() {
        return this.leaderHostAndPort;
    }

    public Master.GetTableLocationsResponsePB getAsTableLocations() {
        String fakeUuid = AsyncKuduClient.getFakeMasterUuid(this.leaderHostAndPort);
        return Master.GetTableLocationsResponsePB.newBuilder().addTabletLocations(Master.TabletLocationsPB.newBuilder().setPartition(Common.PartitionPB.newBuilder().setPartitionKeyStart(ByteString.EMPTY).setPartitionKeyEnd(ByteString.EMPTY)).setTabletId(FAKE_TABLET_ID).addInternedReplicas(Master.TabletLocationsPB.InternedReplicaPB.newBuilder().setTsInfoIdx(0).setRole(this.connectResponse.getRole()))).addTsInfos(Master.TSInfoPB.newBuilder().addRpcAddresses(ProtobufHelper.hostAndPortToPB(this.leaderHostAndPort)).setPermanentUuid(ByteString.copyFromUtf8(fakeUuid))).setTtlMillis(3600000).build();
    }
}

