/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.simple;

import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.AbstractDistributionSummary;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.AbstractTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Clock;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Counter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.DistributionSummary;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionCounter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.LongTaskTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Measurement;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Meter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Timer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.cumulative.CumulativeCounter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.cumulative.CumulativeTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.HistogramGauges;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.internal.DefaultGauge;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.internal.DefaultMeter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.simple.SimpleConfig;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepCounter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepDistributionSummary;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepFunctionCounter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepFunctionTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepTimer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

public class SimpleMeterRegistry
extends MeterRegistry {
    private final SimpleConfig config;

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig config, Clock clock) {
        super(clock);
        config.requireValid();
        this.config = config;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        AbstractDistributionSummary summary;
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                summary = new CumulativeDistributionSummary(id, this.clock, merged, scale, false);
                break;
            }
            default: {
                summary = new StepDistributionSummary(id, this.clock, merged, scale, this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        AbstractTimer timer;
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                timer = new CumulativeTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit(), false);
                break;
            }
            default: {
                timer = new StepTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge<T>(id, obj, valueFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat(ltt, (MeterRegistry)this);
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
            }
        }
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionCounter<T>(id, obj, countFunction);
            }
        }
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

