/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hive.hbase.DataInputInputStream;
import org.apache.hadoop.hive.hbase.DataOutputOutputStream;
import org.apache.hadoop.io.Writable;

public class ResultWritable
implements Writable {
    private Result result;

    public ResultWritable() {
    }

    public ResultWritable(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void readFields(DataInput in) throws IOException {
        ClientProtos.Result protosResult = ClientProtos.Result.parseDelimitedFrom((InputStream)DataInputInputStream.from(in));
        int size = in.readInt();
        if (size < 0) {
            throw new IOException("Invalid size " + size);
        }
        Cell[] kvs = new Cell[size];
        for (int i = 0; i < kvs.length; ++i) {
            kvs[i] = KeyValue.create((DataInput)in);
        }
        this.result = ProtobufUtil.toResult((ClientProtos.Result)protosResult, (CellScanner)CellUtil.createCellScanner((Cell[])kvs));
    }

    public void write(DataOutput out) throws IOException {
        ProtobufUtil.toResultNoData((Result)this.result).writeDelimitedTo(DataOutputOutputStream.from(out));
        out.writeInt(this.result.size());
        for (Cell cell : this.result.listCells()) {
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
            KeyValue.write((KeyValue)kv, (DataOutput)out);
        }
    }
}

