/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.llap.LlapThreadLocalStatistics;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestLlapThreadLocalStatistics {
    private static final ThreadMXBean mxBean = LlapUtil.initThreadMxBean();
    private static final String FILE = "file";
    private static final String HDFS = "hdfs";

    @Test
    public void testEmptyStatistics() {
        LlapThreadLocalStatistics before = new LlapThreadLocalStatistics(mxBean, new ArrayList());
        LlapThreadLocalStatistics after = new LlapThreadLocalStatistics(mxBean, new ArrayList());
        Assert.assertEquals((long)0L, (long)after.subtract((LlapThreadLocalStatistics)before).schemeToThreadLocalStats.keySet().size());
    }

    @Test
    public void testCpuTimeUserTime() throws Exception {
        LlapThreadLocalStatistics before = new LlapThreadLocalStatistics(mxBean, new ArrayList());
        Assert.assertTrue((String)"cpuTime should be >0", (before.cpuTime > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"userTime should be >0", (before.userTime > 0L ? 1 : 0) != 0);
        Thread.sleep(100L);
        LlapThreadLocalStatistics after = new LlapThreadLocalStatistics(mxBean, new ArrayList());
        Assert.assertTrue((String)"cpuTime should increase", (after.cpuTime > before.cpuTime ? 1 : 0) != 0);
    }

    @Test
    public void testCountersMergedForTheSameScheme() {
        LlapThreadLocalStatistics stats = new LlapThreadLocalStatistics(mxBean, this.createMockStatistics(new String[]{FILE, HDFS, HDFS}, new Integer[]{1, 1, 1}));
        Assert.assertEquals((long)1L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)stats.schemeToThreadLocalStats.get((Object)FILE)).bytesRead);
        Assert.assertEquals((long)2L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)stats.schemeToThreadLocalStats.get((Object)HDFS)).bytesRead);
    }

    @Test
    public void testCountersBeforeAfter() {
        LlapThreadLocalStatistics before = new LlapThreadLocalStatistics(mxBean, this.createMockStatistics(new String[]{FILE, HDFS, HDFS}, new Integer[]{1, 1, 1}));
        LlapThreadLocalStatistics after = new LlapThreadLocalStatistics(mxBean, this.createMockStatistics(new String[]{FILE, HDFS, HDFS}, new Integer[]{3, 1, 4}));
        Assert.assertEquals((long)1L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)before.schemeToThreadLocalStats.get((Object)FILE)).bytesRead);
        Assert.assertEquals((long)2L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)before.schemeToThreadLocalStats.get((Object)HDFS)).bytesRead);
        Assert.assertEquals((long)3L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)after.schemeToThreadLocalStats.get((Object)FILE)).bytesRead);
        Assert.assertEquals((long)5L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)after.schemeToThreadLocalStats.get((Object)HDFS)).bytesRead);
        after.subtract(before);
        Assert.assertEquals((long)2L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)after.schemeToThreadLocalStats.get((Object)FILE)).bytesRead);
        Assert.assertEquals((long)3L, (long)((LlapThreadLocalStatistics.LlapFileSystemStatisticsData)after.schemeToThreadLocalStats.get((Object)HDFS)).bytesRead);
    }

    private List<FileSystem.Statistics> createMockStatistics(String[] schemes, Integer[] values) {
        return IntStream.range(0, schemes.length).mapToObj(i -> {
            FileSystem.Statistics stat = new FileSystem.Statistics(schemes[i]);
            stat.incrementBytesRead((long)values[i].intValue());
            return stat;
        }).collect(Collectors.toList());
    }
}

