/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.conf.ColumnSet;
import org.apache.accumulo.core.iterators.conf.ColumnToClassMapping;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;

public class ColumnAgeOffFilter
extends Filter {
    TTLSet ttls;
    long currentTime = 0L;

    @Override
    public boolean accept(Key k, Value v) {
        Long threshold = (Long)this.ttls.getObject(k);
        if (threshold == null) {
            return true;
        }
        return this.currentTime - k.getTimestamp() <= threshold;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.ttls = new TTLSet(options);
        this.currentTime = System.currentTimeMillis();
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        ColumnAgeOffFilter copy = (ColumnAgeOffFilter)super.deepCopy(env);
        copy.currentTime = this.currentTime;
        copy.ttls = this.ttls;
        return copy;
    }

    public void overrideCurrentTime(long ts) {
        this.currentTime = ts;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("colageoff");
        io.setDescription("ColumnAgeOffFilter ages off columns at different rates given a time to live in milliseconds for each column");
        io.addUnnamedOption("<col fam>[:<col qual>] <Long> (escape non-alphanum chars using %<hex>)");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        try {
            this.ttls = new TTLSet(options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad TTL options", e);
        }
        return true;
    }

    public static void addTTL(IteratorSetting is, IteratorSetting.Column column, Long ttl) {
        is.addOption(ColumnSet.encodeColumns((Text)column.getFirst(), (Text)column.getSecond()), Long.toString(ttl));
    }

    public static void removeTTL(IteratorSetting is, IteratorSetting.Column column) {
        is.removeOption(ColumnSet.encodeColumns((Text)column.getFirst(), (Text)column.getSecond()));
    }

    public static class TTLSet
    extends ColumnToClassMapping<Long> {
        public TTLSet(Map<String, String> objectStrings) {
            for (Map.Entry<String, String> entry : objectStrings.entrySet()) {
                String column = entry.getKey();
                String ttl = entry.getValue().trim();
                if (column.equals("negate") && (ttl.isEmpty() || ttl.equalsIgnoreCase("true") || ttl.equalsIgnoreCase("false"))) continue;
                Long l = Long.parseLong(ttl);
                Pair<Text, Text> colPair = ColumnSet.decodeColumns(column);
                if (colPair.getSecond() == null) {
                    this.addObject(colPair.getFirst(), l);
                    continue;
                }
                this.addObject(colPair.getFirst(), colPair.getSecond(), l);
            }
        }
    }
}

