/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.FunctionPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.Null;

public final class FunctionPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<FunctionPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new FunctionPrototypeBuiltins();
    public static final JSBuiltinsContainer BUILTINS_NASHORN_COMPAT = new FunctionPrototypeNashornCompatBuiltins();

    protected FunctionPrototypeBuiltins() {
        super(JSFunction.PROTOTYPE_NAME, FunctionPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, FunctionPrototype builtinEnum) {
        switch (builtinEnum) {
            case bind: {
                return FunctionPrototypeBuiltinsFactory.JSBindNodeGen.create(context, builtin, FunctionPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case toString: {
                return FunctionPrototypeBuiltinsFactory.JSFunctionToStringNodeGen.create(context, builtin, FunctionPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case apply: {
                return FunctionPrototypeBuiltinsFactory.JSApplyNodeGen.create(context, builtin, FunctionPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case call: {
                return FunctionPrototypeBuiltinsFactory.JSCallNodeGen.create(context, builtin, FunctionPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case _hasInstance: {
                return FunctionPrototypeBuiltinsFactory.HasInstanceNodeGen.create(context, builtin, FunctionPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FunctionPrototype implements BuiltinEnum<FunctionPrototype>
    {
        bind(1),
        toString(0),
        apply(2),
        call(1),
        _hasInstance(1){

            @Override
            public Object getKey() {
                return Symbol.SYMBOL_HAS_INSTANCE;
            }

            @Override
            public boolean isWritable() {
                return false;
            }

            @Override
            public boolean isConfigurable() {
                return false;
            }
        };

        private final int length;

        private FunctionPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (this == _hasInstance) {
                return 6;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    public static abstract class JSBindNode
    extends JSBuiltinNode {
        public JSBindNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSDynamicObject bindJSFunction(JSFunctionObject thisFnObj, Object thisArg, Object[] args, @Cached @Cached.Shared GetPrototypeNode getPrototypeNode, @Cached(value="create(getContext())") @Cached.Shared CopyFunctionNameAndLengthNode copyNameAndLengthNode, @Cached @Cached.Shared(value="isConstructorProf") InlinedConditionProfile isConstructorProfile, @Cached @Cached.Exclusive InlinedConditionProfile isAsyncProfile, @Cached @Cached.Shared(value="setProtoProf") InlinedConditionProfile setProtoProfile) {
            JSDynamicObject proto = getPrototypeNode.execute(thisFnObj);
            JSFunctionObject boundFunction = JSFunction.boundFunctionCreate(this.getContext(), thisFnObj, thisArg, args, proto, isConstructorProfile, isAsyncProfile, setProtoProfile, this);
            copyNameAndLengthNode.execute(boundFunction, thisFnObj, Strings.BOUND_SPC, args.length);
            return boundFunction;
        }

        @Specialization(guards={"!isJSFunction(thisObj)", "isCallableNode.executeBoolean(thisObj)"}, limit="1")
        protected final JSDynamicObject bindOther(Object thisObj, Object thisArg, Object[] args, @Cached @Cached.Shared IsCallableNode isCallableNode, @Cached @Cached.Shared GetPrototypeNode getPrototypeNode, @Cached ForeignObjectPrototypeNode foreignPrototypeNode, @Cached IsConstructorNode isConstructorNode, @Cached(value="create(getContext())") @Cached.Shared CopyFunctionNameAndLengthNode copyNameAndLengthNode, @Cached @Cached.Exclusive InlinedConditionProfile isProxyProfile, @Cached @Cached.Shared(value="isConstructorProf") InlinedConditionProfile isConstructorProfile, @Cached @Cached.Shared(value="setProtoProf") InlinedConditionProfile setProtoProfile) {
            boolean needSetProto;
            JSDynamicObject proto;
            JSRealm realm = JSRuntime.getFunctionRealm(thisObj, JSRealm.get(this));
            if (isProxyProfile.profile((Node)this, JSProxy.isJSProxy(thisObj))) {
                proto = getPrototypeNode.execute(thisObj);
            } else {
                assert (JSRuntime.isCallableForeign(thisObj));
                proto = this.getContext().getContextOptions().hasForeignObjectPrototype() ? foreignPrototypeNode.execute(thisObj) : Null.instance;
            }
            JSContext context = this.getContext();
            boolean constructor = isConstructorProfile.profile((Node)this, isConstructorNode.executeBoolean(thisObj));
            JSFunctionData boundFunctionData = context.getBoundFunctionData(constructor, false);
            JSFunctionObject boundFunction = JSFunction.createBound(context, realm, boundFunctionData, thisObj, thisArg, args);
            boolean bl = needSetProto = proto != realm.getFunctionPrototype();
            if (setProtoProfile.profile((Node)this, needSetProto)) {
                JSObject.setPrototype(boundFunction, proto);
            }
            copyNameAndLengthNode.execute(boundFunction, thisObj, Strings.BOUND_SPC, args.length);
            return boundFunction;
        }

        @Specialization(guards={"!isCallableNode.executeBoolean(thisObj)"}, limit="1")
        protected static JSDynamicObject bindError(Object thisObj, Object thisArg, Object[] arg, @Cached @Cached.Shared IsCallableNode isCallableNode) {
            throw Errors.createTypeErrorNotAFunction(thisObj);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSFunctionToStringNode
    extends JSBuiltinNode {
        public JSFunctionToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean isBoundTarget(JSDynamicObject fnObj) {
            return JSFunction.isBoundFunction((Object)fnObj);
        }

        @Specialization(guards={"isJSFunction(fnObj)", "!isBoundTarget(fnObj)"})
        protected TruffleString toStringDefault(JSDynamicObject fnObj) {
            return JSFunctionToStringNode.toStringDefaultTarget(fnObj);
        }

        @Specialization(guards={"isJSFunction(fnObj)", "isBoundTarget(fnObj)"})
        protected TruffleString toStringBound(JSDynamicObject fnObj) {
            if (this.getContext().isOptionV8CompatibilityMode()) {
                return Strings.FUNCTION_NATIVE_CODE;
            }
            TruffleString name = JSFunction.getName(fnObj);
            return JSFunctionToStringNode.getNameIntl(name);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getNameIntl(TruffleString name) {
            int spacePos = Strings.lastIndexOf(name, 32);
            return Strings.concatAll(Strings.FUNCTION_SPC, spacePos < 0 ? name : Strings.lazySubstring(name, spacePos + 1), Strings.FUNCTION_NATIVE_CODE_BODY);
        }

        @Specialization(guards={"isES2019OrLater()", "!isJSFunction(fnObj)", "isCallable.executeBoolean(fnObj)"}, limit="1")
        protected TruffleString toStringCallable(Object fnObj, @Cached @Cached.Shared IsCallableNode isCallable, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interopStr, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            try {
                Object name = null;
                if (interop.hasExecutableName(fnObj)) {
                    name = interop.getExecutableName(fnObj);
                } else if (interop.isMetaObject(fnObj)) {
                    name = interop.getMetaSimpleName(fnObj);
                }
                if (name != null) {
                    return JSFunctionToStringNode.getNameIntl(Strings.interopAsTruffleString(name, interopStr, switchEncoding));
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            return Strings.FUNCTION_NATIVE_CODE;
        }

        @Specialization(guards={"isES2019OrLater()", "!isCallable.executeBoolean(fnObj)"}, limit="1")
        protected TruffleString toStringNotCallable(Object fnObj, @Cached @Cached.Shared IsCallableNode isCallable) {
            throw Errors.createTypeErrorNotAFunction(fnObj);
        }

        @Specialization(guards={"!isES2019OrLater()", "!isJSFunction(fnObj)"})
        protected TruffleString toStringNotFunction(Object fnObj) {
            throw Errors.createTypeErrorNotAFunction(fnObj);
        }

        @Idempotent
        final boolean isES2019OrLater() {
            return this.getContext().getEcmaScriptVersion() >= 10;
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString toStringDefaultTarget(JSDynamicObject fnObj) {
            CallTarget ct = JSFunction.getCallTarget(fnObj);
            if (!(ct instanceof RootCallTarget)) {
                return Strings.fromJavaString(ct.toString());
            }
            RootCallTarget dct = (RootCallTarget)ct;
            RootNode rn = dct.getRootNode();
            SourceSection ssect = rn.getSourceSection();
            TruffleString result = ssect == null || !ssect.isAvailable() || ssect.getSource().isInternal() ? Strings.concatAll(Strings.FUNCTION_SPC, JSFunction.getName(fnObj), Strings.FUNCTION_NATIVE_CODE_BODY) : Strings.fromJavaString(ssect.getCharacters().toString());
            return result;
        }
    }

    public static abstract class JSApplyNode
    extends JSBuiltinNode {
        @Node.Child
        private JSFunctionCallNode call = JSFunctionCallNode.createCall();
        @Node.Child
        private JSToObjectArrayNode toObjectArray;

        public JSApplyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.toObjectArray = JSToObjectArrayNode.create(context, true);
        }

        @Specialization(guards={"isJSFunction(function)"})
        protected Object applyFunction(JSDynamicObject function, Object target, Object args) {
            return this.apply((Object)function, target, args);
        }

        @Specialization(guards={"isCallable.executeBoolean(function)"}, replaces={"applyFunction"}, limit="1")
        protected Object applyCallable(Object function, Object target, Object args, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            return this.apply(function, target, args);
        }

        private Object apply(Object function, Object target, Object args) {
            Object[] applyUserArgs = this.toObjectArray.executeObjectArray(args);
            assert (applyUserArgs.length <= this.getContext().getContextOptions().getMaxApplyArgumentLength());
            Object[] passedOnArguments = JSArguments.create(target, function, applyUserArgs);
            return this.call.executeCall(passedOnArguments);
        }

        @Specialization(guards={"!isCallable.executeBoolean(function)"}, limit="1")
        protected Object error(Object function, Object target, Object args, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            throw Errors.createTypeErrorNotAFunction(function);
        }

        @Override
        public boolean countsTowardsStackTraceLimit() {
            return false;
        }
    }

    public static abstract class JSCallNode
    extends JSBuiltinNode {
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

        public JSCallNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object call(Object function, Object target, Object[] args) {
            return this.callNode.executeCall(JSArguments.create(target, function, args));
        }

        @Override
        public boolean countsTowardsStackTraceLimit() {
            return false;
        }
    }

    public static abstract class HasInstanceNode
    extends JSBuiltinNode {
        @Node.Child
        InstanceofNode.OrdinaryHasInstanceNode ordinaryHasInstanceNode;

        public HasInstanceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.ordinaryHasInstanceNode = InstanceofNode.OrdinaryHasInstanceNode.create(context);
        }

        @Specialization
        protected boolean hasInstance(Object thisObj, Object value) {
            return this.ordinaryHasInstanceNode.executeBoolean(value, thisObj);
        }
    }

    public static final class FunctionPrototypeNashornCompatBuiltins
    extends JSBuiltinsContainer.SwitchEnum<FunctionNashornCompat> {
        protected FunctionPrototypeNashornCompatBuiltins() {
            super(FunctionNashornCompat.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, FunctionNashornCompat builtinEnum) {
            switch (builtinEnum) {
                case toSource: {
                    return FunctionPrototypeBuiltinsFactory.JSFunctionToStringNodeGen.create(context, builtin, FunctionPrototypeNashornCompatBuiltins.args().withThis().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum FunctionNashornCompat implements BuiltinEnum<FunctionNashornCompat>
        {
            toSource(0);

            private final int length;

            private FunctionNashornCompat(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static final class CopyFunctionNameAndLengthNode
    extends JavaScriptBaseNode {
        @Node.Child
        private HasPropertyCacheNode hasFunctionLengthNode;
        @Node.Child
        private PropertyGetNode getFunctionLengthNode;
        @Node.Child
        private PropertyGetNode getFunctionNameNode;
        @Node.Child
        private DynamicObjectLibrary functionLengthLib;
        @Node.Child
        private DynamicObjectLibrary functionNameLib;
        private final ConditionProfile hasFunctionLengthProfile = ConditionProfile.create();
        private final ConditionProfile hasIntegerFunctionLengthProfile = ConditionProfile.create();
        private final ConditionProfile isJSFunctionProfile = ConditionProfile.create();

        public CopyFunctionNameAndLengthNode(JSContext context) {
            this.hasFunctionLengthNode = HasPropertyCacheNode.create(JSFunction.LENGTH, context, true);
            this.getFunctionLengthNode = PropertyGetNode.create(JSFunction.LENGTH, false, context);
            this.getFunctionNameNode = PropertyGetNode.create(JSFunction.NAME, false, context);
            this.functionLengthLib = JSObjectUtil.createDispatched(JSFunction.LENGTH);
            this.functionNameLib = JSObjectUtil.createDispatched(JSFunction.NAME);
        }

        @NeverDefault
        public static CopyFunctionNameAndLengthNode create(JSContext context) {
            return new CopyFunctionNameAndLengthNode(context);
        }

        public void execute(JSFunctionObject boundFunction, JSFunctionObject targetFunction, TruffleString prefix, int argCount) {
            if (this.hasFunctionLengthProfile.profile(this.hasFunctionLengthNode.hasProperty((Object)targetFunction))) {
                if (!JSProperty.isProxy(this.functionLengthLib.getPropertyFlagsOrDefault((DynamicObject)targetFunction, (Object)Strings.LENGTH, 0))) {
                    this.copyLength(boundFunction, (Object)targetFunction, argCount);
                } else {
                    int targetLen;
                    int n = targetLen = targetFunction instanceof JSFunctionObject.BoundOrWrapped ? ((JSFunctionObject.BoundOrWrapped)targetFunction).getBoundLength() : JSFunction.getLength(targetFunction);
                    assert (targetLen >= 0);
                    int length = Math.max(0, targetLen - argCount);
                    ((JSFunctionObject.BoundOrWrapped)boundFunction).setBoundLength(length);
                }
            }
            if (!JSProperty.isProxy(this.functionNameLib.getPropertyFlagsOrDefault((DynamicObject)targetFunction, (Object)Strings.NAME, 0))) {
                this.copyName(boundFunction, (Object)targetFunction, prefix);
            }
        }

        public void execute(JSFunctionObject boundFunction, Object target, TruffleString prefix, int argCount) {
            if (this.isJSFunctionProfile.profile(target instanceof JSFunctionObject)) {
                this.execute(boundFunction, (JSFunctionObject)((Object)target), prefix, argCount);
                return;
            }
            if (this.hasFunctionLengthProfile.profile(this.hasFunctionLengthNode.hasProperty(target))) {
                this.copyLength(boundFunction, target, argCount);
            }
            this.copyName(boundFunction, target, prefix);
        }

        private void copyLength(JSFunctionObject boundFunction, Object target, int argCount) {
            Object targetLen = this.getFunctionLengthNode.getValue(target);
            if (this.hasIntegerFunctionLengthProfile.profile(targetLen instanceof Integer)) {
                int targetLenAsInt = (Integer)targetLen;
                int lengthAsInt = Math.max(0, Math.max(0, targetLenAsInt) - argCount);
                ((JSFunctionObject.BoundOrWrapped)boundFunction).setBoundLength(lengthAsInt);
            } else if (JSRuntime.isNumber(targetLen)) {
                double targetLenAsInt = CopyFunctionNameAndLengthNode.toIntegerOrInfinity((Number)targetLen);
                Number length = targetLenAsInt != Double.NEGATIVE_INFINITY ? (Number)JSRuntime.doubleToNarrowestNumber(Math.max(0.0, targetLenAsInt - (double)argCount)) : (Number)0;
                JSFunction.setFunctionLength(boundFunction, length);
            }
        }

        private void copyName(JSFunctionObject boundFunction, Object target, TruffleString prefix) {
            Object targetName = this.getFunctionNameNode.getValue(target);
            if (!JSGuards.isString(targetName)) {
                targetName = Strings.EMPTY_STRING;
            }
            ((JSFunctionObject.BoundOrWrapped)boundFunction).setBoundName((TruffleString)targetName, prefix);
        }

        private static double toIntegerOrInfinity(Number number) {
            if (number instanceof Double) {
                double doubleValue = (Double)number;
                return Double.isNaN(doubleValue) ? 0.0 : JSRuntime.truncateDouble(doubleValue);
            }
            return JSRuntime.doubleValue(number);
        }
    }
}

