/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HeapMemoryMonitor;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.streaming.PartitionInfo;
import org.apache.hive.streaming.RecordWriter;
import org.apache.hive.streaming.SerializationError;
import org.apache.hive.streaming.StreamingConnection;
import org.apache.hive.streaming.StreamingException;
import org.apache.hive.streaming.StreamingIOFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordWriter
implements RecordWriter {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractRecordWriter.class.getName());
    private static final String DEFAULT_LINE_DELIMITER_PATTERN = "[\r\n]";
    private Integer statementId;
    protected HiveConf conf;
    protected StreamingConnection conn;
    protected Table table;
    protected List<String> inputColumns;
    protected List<String> inputTypes;
    protected String fullyQualifiedTableName;
    protected Map<String, List<RecordUpdater>> updaters = new HashMap<String, List<RecordUpdater>>();
    protected Map<String, Path> partitionPaths = new HashMap<String, Path>();
    protected Set<String> updatedPartitions = new HashSet<String>();
    protected StructObjectInspector inputRowObjectInspector;
    protected ObjectInspector outputRowObjectInspector;
    protected List<String> partitionColumns = new ArrayList<String>();
    protected ObjectInspector[] partitionObjInspectors = null;
    protected StructField[] partitionStructFields = null;
    protected Object[] partitionFieldData;
    protected ObjectInspector[] bucketObjInspectors = null;
    protected StructField[] bucketStructFields = null;
    protected Object[] bucketFieldData;
    protected List<Integer> bucketIds = new ArrayList<Integer>();
    protected int totalBuckets;
    protected String defaultPartitionName;
    protected boolean isBucketed;
    protected AcidOutputFormat<?, ?> acidOutputFormat;
    protected Long curBatchMinWriteId;
    protected Long curBatchMaxWriteId;
    protected final String lineDelimiter;
    protected HeapMemoryMonitor heapMemoryMonitor;
    protected AtomicBoolean lowMemoryCanary;
    protected long ingestSizeBytes = 0L;
    protected boolean autoFlush;
    protected float memoryUsageThreshold;
    protected long ingestSizeThreshold;
    protected FileSystem fs;

    public AbstractRecordWriter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter == null || lineDelimiter.isEmpty() ? DEFAULT_LINE_DELIMITER_PATTERN : lineDelimiter;
    }

    @Override
    public void init(StreamingConnection conn, long minWriteId, long maxWriteId) throws StreamingException {
        this.init(conn, minWriteId, maxWriteId, -1);
    }

    @Override
    public void init(StreamingConnection conn, long minWriteId, long maxWriteId, int statementId) throws StreamingException {
        if (conn == null) {
            throw new StreamingException("Streaming connection cannot be null during record writer initialization");
        }
        this.conn = conn;
        this.curBatchMinWriteId = minWriteId;
        this.curBatchMaxWriteId = maxWriteId;
        this.statementId = statementId;
        this.conf = conn.getHiveConf();
        this.defaultPartitionName = this.conf.getVar(HiveConf.ConfVars.DEFAULT_PARTITION_NAME);
        this.table = conn.getTable();
        String location = this.table.getSd().getLocation();
        try {
            URI uri = new URI(location);
            this.fs = FileSystem.newInstance((URI)uri, (Configuration)this.conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created new filesystem instance: {}", (Object)System.identityHashCode(this.fs));
            }
        }
        catch (URISyntaxException e) {
            throw new StreamingException("Unable to create URI from location: " + location, e);
        }
        catch (IOException e) {
            throw new StreamingException("Unable to get filesystem for location: " + location, e);
        }
        this.inputColumns = this.table.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
        this.inputTypes = this.table.getSd().getCols().stream().map(FieldSchema::getType).collect(Collectors.toList());
        if (conn.isPartitionedTable() && conn.isDynamicPartitioning()) {
            this.partitionColumns = this.table.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
            this.inputColumns.addAll(this.partitionColumns);
            this.inputTypes.addAll(this.table.getPartitionKeys().stream().map(FieldSchema::getType).collect(Collectors.toList()));
        }
        this.fullyQualifiedTableName = Warehouse.getQualifiedName((String)this.table.getDbName(), (String)this.table.getTableName());
        String outFormatName = this.table.getSd().getOutputFormat();
        try {
            this.acidOutputFormat = (AcidOutputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass((String)outFormatName), (Configuration)this.conf);
        }
        catch (Exception e) {
            String shadePrefix = this.conf.getVar(HiveConf.ConfVars.HIVE_CLASSLOADER_SHADE_PREFIX);
            if (shadePrefix != null && !shadePrefix.trim().isEmpty()) {
                try {
                    LOG.info("Shade prefix: {} specified. Using as fallback to load {}..", (Object)shadePrefix, (Object)outFormatName);
                    this.acidOutputFormat = (AcidOutputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass((String)shadePrefix, (String)outFormatName), (Configuration)this.conf);
                }
                catch (ClassNotFoundException e1) {
                    throw new StreamingException(e.getMessage(), e);
                }
            }
            throw new StreamingException(e.getMessage(), e);
        }
        this.setupMemoryMonitoring();
        try {
            AbstractSerDe serDe = this.createSerde();
            this.inputRowObjectInspector = (StructObjectInspector)serDe.getObjectInspector();
            if (conn.isPartitionedTable() && conn.isDynamicPartitioning()) {
                this.preparePartitioningFields();
                int dpStartCol = this.inputRowObjectInspector.getAllStructFieldRefs().size() - this.table.getPartitionKeys().size();
                this.outputRowObjectInspector = new SubStructObjectInspector(this.inputRowObjectInspector, 0, dpStartCol);
            } else {
                this.outputRowObjectInspector = this.inputRowObjectInspector;
            }
            this.prepareBucketingFields();
        }
        catch (SerDeException e) {
            throw new StreamingException("Unable to create SerDe", e);
        }
    }

    protected void setupMemoryMonitoring() {
        this.autoFlush = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STREAMING_AUTO_FLUSH_ENABLED);
        this.memoryUsageThreshold = this.conf.getFloatVar(HiveConf.ConfVars.HIVE_HEAP_MEMORY_MONITOR_USAGE_THRESHOLD);
        this.ingestSizeThreshold = this.conf.getSizeVar(HiveConf.ConfVars.HIVE_STREAMING_AUTO_FLUSH_CHECK_INTERVAL_SIZE);
        LOG.info("Memory monitoring settings - autoFlush: {} memoryUsageThreshold: {} ingestSizeThreshold: {}", new Object[]{this.autoFlush, Float.valueOf(this.memoryUsageThreshold), this.ingestSizeBytes});
        this.heapMemoryMonitor = new HeapMemoryMonitor((double)this.memoryUsageThreshold);
        MemoryUsage tenuredMemUsage = this.heapMemoryMonitor.getTenuredGenMemoryUsage();
        if (tenuredMemUsage != null) {
            this.lowMemoryCanary = new AtomicBoolean(false);
            this.heapMemoryMonitor.registerListener((HeapMemoryMonitor.Listener)new OrcMemoryPressureMonitor(this.lowMemoryCanary));
            this.heapMemoryMonitor.start();
            float currentUsage = (float)tenuredMemUsage.getUsed() / (float)tenuredMemUsage.getMax();
            if (currentUsage > this.memoryUsageThreshold) {
                LOG.warn("LOW MEMORY ALERT! Tenured gen memory is already low. Increase memory to improve performance. Used: {} Max: {}", (Object)LlapUtil.humanReadableByteCount((long)tenuredMemUsage.getUsed()), (Object)LlapUtil.humanReadableByteCount((long)tenuredMemUsage.getMax()));
            }
        }
    }

    protected void prepareBucketingFields() {
        this.isBucketed = this.table.getSd().getNumBuckets() > 0;
        int n = this.totalBuckets = this.isBucketed ? this.table.getSd().getNumBuckets() : 1;
        if (this.isBucketed) {
            this.bucketIds = this.getBucketColIDs(this.table.getSd().getBucketCols(), this.table.getSd().getCols());
            this.bucketFieldData = new Object[this.bucketIds.size()];
            this.bucketObjInspectors = AbstractRecordWriter.getObjectInspectorsForBucketedCols(this.bucketIds, this.inputRowObjectInspector);
            this.bucketStructFields = new StructField[this.bucketIds.size()];
            List allFields = this.inputRowObjectInspector.getAllStructFieldRefs();
            for (int i = 0; i < this.bucketIds.size(); ++i) {
                this.bucketStructFields[i] = (StructField)allFields.get(this.bucketIds.get(i));
            }
        }
    }

    protected void preparePartitioningFields() {
        int i;
        int numPartitions = this.table.getPartitionKeys().size();
        this.partitionFieldData = new Object[numPartitions];
        this.partitionObjInspectors = new ObjectInspector[numPartitions];
        int startIdx = this.inputRowObjectInspector.getAllStructFieldRefs().size() - numPartitions;
        int endIdx = this.inputRowObjectInspector.getAllStructFieldRefs().size();
        int j = 0;
        for (i = startIdx; i < endIdx; ++i) {
            StructField structField = (StructField)this.inputRowObjectInspector.getAllStructFieldRefs().get(i);
            this.partitionObjInspectors[j++] = structField.getFieldObjectInspector();
        }
        this.partitionStructFields = new StructField[this.partitionColumns.size()];
        for (i = 0; i < this.partitionColumns.size(); ++i) {
            String partCol = this.partitionColumns.get(i);
            this.partitionStructFields[i] = this.inputRowObjectInspector.getStructFieldRef(partCol);
        }
    }

    protected String getWatermark(String partition) {
        return partition + " writeIds[" + this.curBatchMinWriteId + "," + this.curBatchMaxWriteId + "]";
    }

    protected List<Integer> getBucketColIDs(List<String> bucketCols, List<FieldSchema> cols) {
        ArrayList<Integer> result = new ArrayList<Integer>(bucketCols.size());
        HashSet<String> bucketSet = new HashSet<String>(bucketCols);
        for (int i = 0; i < cols.size(); ++i) {
            if (!bucketSet.contains(cols.get(i).getName())) continue;
            result.add(i);
        }
        return result;
    }

    public abstract AbstractSerDe createSerde() throws SerializationError;

    public abstract Object encode(byte[] var1) throws SerializationError;

    protected int getBucket(Object row) {
        if (!this.isBucketed) {
            return 0;
        }
        Object[] bucketFields = this.getBucketFields(row);
        int bucketingVersion = Utilities.getBucketingVersion((String)((String)this.table.getParameters().get("bucketing_version")));
        return bucketingVersion == 2 ? ObjectInspectorUtils.getBucketNumber((Object[])bucketFields, (ObjectInspector[])this.bucketObjInspectors, (int)this.totalBuckets) : ObjectInspectorUtils.getBucketNumberOld((Object[])bucketFields, (ObjectInspector[])this.bucketObjInspectors, (int)this.totalBuckets);
    }

    protected List<String> getPartitionValues(Object row) {
        if (!this.conn.isPartitionedTable()) {
            return null;
        }
        ArrayList<String> partitionValues = new ArrayList();
        if (this.conn.isPartitionedTable() && this.conn.isDynamicPartitioning()) {
            Object[] partitionFields = this.getPartitionFields(row);
            for (int i = 0; i < this.partitionObjInspectors.length; ++i) {
                Object field = partitionFields[i];
                ObjectInspector oi = this.partitionObjInspectors[i];
                Object partitionValue = ObjectInspectorUtils.copyToStandardObject((Object)field, (ObjectInspector)oi, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                if (partitionValue == null || partitionValue.toString().length() == 0) {
                    partitionValues.add(this.defaultPartitionName);
                    continue;
                }
                partitionValues.add(partitionValue.toString());
            }
        } else {
            partitionValues = this.conn.getStaticPartitionValues();
        }
        return partitionValues;
    }

    @Override
    public void flush() throws StreamingIOFailure {
        try {
            if (LOG.isDebugEnabled()) {
                this.logStats("Stats before flush:");
            }
            for (Map.Entry<String, List<RecordUpdater>> entry : this.updaters.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Flushing record updater for partitions: {}", (Object)entry.getKey());
                }
                for (RecordUpdater updater : entry.getValue()) {
                    if (updater == null) continue;
                    updater.flush();
                }
            }
            this.ingestSizeBytes = 0L;
            if (LOG.isDebugEnabled()) {
                this.logStats("Stats after flush:");
            }
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Unable to flush recordUpdater", e);
        }
    }

    @Override
    public void close() throws StreamingIOFailure {
        if (this.heapMemoryMonitor != null) {
            this.heapMemoryMonitor.close();
        }
        boolean haveError = false;
        String partition = null;
        if (LOG.isDebugEnabled()) {
            this.logStats("Stats before close:");
        }
        for (Map.Entry<String, List<RecordUpdater>> entry : this.updaters.entrySet()) {
            partition = entry.getKey();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing updater for partitions: {}", (Object)partition);
            }
            for (RecordUpdater updater : entry.getValue()) {
                if (updater == null) continue;
                try {
                    updater.close(false);
                }
                catch (Exception ex) {
                    haveError = true;
                    LOG.error("Unable to close " + updater + " due to: " + ex.getMessage(), (Throwable)ex);
                }
            }
            entry.getValue().clear();
        }
        this.updaters.clear();
        this.updatedPartitions.clear();
        if (LOG.isDebugEnabled()) {
            this.logStats("Stats after close:");
        }
        try {
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error while closing FileSystem", e);
        }
        if (haveError) {
            throw new StreamingIOFailure("Encountered errors while closing (see logs) " + this.getWatermark(partition));
        }
    }

    protected static ObjectInspector[] getObjectInspectorsForBucketedCols(List<Integer> bucketIds, StructObjectInspector recordObjInspector) {
        ObjectInspector[] result = new ObjectInspector[bucketIds.size()];
        for (int i = 0; i < bucketIds.size(); ++i) {
            int bucketId = bucketIds.get(i);
            result[i] = ((StructField)recordObjInspector.getAllStructFieldRefs().get(bucketId)).getFieldObjectInspector();
        }
        return result;
    }

    protected Object[] getBucketFields(Object row) {
        for (int i = 0; i < this.bucketIds.size(); ++i) {
            this.bucketFieldData[i] = this.inputRowObjectInspector.getStructFieldData(row, this.bucketStructFields[i]);
        }
        return this.bucketFieldData;
    }

    protected Object[] getPartitionFields(Object row) {
        for (int i = 0; i < this.partitionFieldData.length; ++i) {
            this.partitionFieldData[i] = this.inputRowObjectInspector.getStructFieldData(row, this.partitionStructFields[i]);
        }
        return this.partitionFieldData;
    }

    @Override
    public void write(long writeId, InputStream inputStream) throws StreamingException {
        try (Scanner scanner = new Scanner(inputStream).useDelimiter(this.lineDelimiter);){
            while (scanner.hasNext()) {
                this.write(writeId, scanner.next().getBytes());
            }
        }
    }

    @Override
    public void write(long writeId, byte[] record) throws StreamingException {
        this.checkAutoFlush();
        this.ingestSizeBytes += (long)record.length;
        try {
            Object encodedRow = this.encode(record);
            int bucket = this.getBucket(encodedRow);
            List<String> partitionValues = this.getPartitionValues(encodedRow);
            this.getRecordUpdater(partitionValues, bucket).insert(writeId, encodedRow);
            this.conn.getConnectionStats().incrementRecordsWritten();
            this.conn.getConnectionStats().incrementRecordsSize(record.length);
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction write id (" + writeId + ")", e);
        }
    }

    protected void checkAutoFlush() throws StreamingIOFailure {
        MemoryMXBean mxBean;
        MemoryUsage heapUsage;
        float memUsedFraction;
        if (!this.autoFlush) {
            return;
        }
        if (this.lowMemoryCanary != null) {
            if (this.lowMemoryCanary.get() && this.ingestSizeBytes > this.ingestSizeThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Low memory canary is set and ingestion size (buffered) threshold '{}' exceeded. Flushing all record updaters..", (Object)LlapUtil.humanReadableByteCount((long)this.ingestSizeThreshold));
                }
                this.flush();
                this.conn.getConnectionStats().incrementAutoFlushCount();
                this.lowMemoryCanary.set(false);
            }
        } else if (this.ingestSizeBytes > this.ingestSizeThreshold && (memUsedFraction = (float)(heapUsage = (mxBean = ManagementFactory.getMemoryMXBean()).getHeapMemoryUsage()).getUsed() / (float)heapUsage.getMax()) > this.memoryUsageThreshold) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Memory usage threshold '{}' and ingestion size (buffered) threshold '{}' exceeded. Flushing all record updaters..", (Object)Float.valueOf(memUsedFraction), (Object)LlapUtil.humanReadableByteCount((long)this.ingestSizeThreshold));
            }
            this.flush();
            this.conn.getConnectionStats().incrementAutoFlushCount();
        }
    }

    @Override
    public Set<String> getPartitions() {
        return this.updatedPartitions;
    }

    protected RecordUpdater createRecordUpdater(List<String> partitionValues, Path partitionPath, int bucketId, Long minWriteId, Long maxWriteID) throws IOException {
        Properties tblProperties = new Properties();
        tblProperties.putAll((Map<?, ?>)this.table.getParameters());
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).inspector(this.outputRowObjectInspector).bucket(bucketId).tableProperties(tblProperties).minimumWriteId(minWriteId.longValue()).maximumWriteId(maxWriteID.longValue()).statementId(this.statementId.intValue()).finalDestination(partitionPath);
        this.conn.addWriteDirectoryInfo(partitionValues, AcidUtils.baseOrDeltaSubdirPath((Path)partitionPath, (AcidOutputFormat.Options)options));
        return this.acidOutputFormat.getRecordUpdater(partitionPath, options);
    }

    @Override
    public Path getDeltaFileLocation(List<String> partitionValues, Integer bucketId, Long minWriteId, Long maxWriteId, Integer statementId, Table table) throws StreamingException {
        Path destLocation;
        if (partitionValues == null) {
            destLocation = new Path(table.getSd().getLocation());
        } else {
            Map partSpec = Warehouse.makeSpecFromValues((List)table.getPartitionKeys(), partitionValues);
            try {
                destLocation = new Path(table.getDataLocation(), Warehouse.makePartPath((Map)partSpec));
            }
            catch (MetaException e) {
                throw new StreamingException("Unable to retrieve the delta file location for values: " + partitionValues + ", minWriteId: " + minWriteId + ", maxWriteId: " + maxWriteId + ", statementId: " + statementId, e);
            }
        }
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).inspector(this.outputRowObjectInspector).bucket(bucketId.intValue()).minimumWriteId(minWriteId.longValue()).maximumWriteId(maxWriteId.longValue()).statementId(statementId.intValue()).finalDestination(destLocation);
        return AcidUtils.createFilename((Path)destLocation, (AcidOutputFormat.Options)options);
    }

    protected RecordUpdater getRecordUpdater(List<String> partitionValues, int bucketId) throws StreamingIOFailure {
        RecordUpdater recordUpdater;
        Path destLocation;
        String key;
        try {
            String string = key = partitionValues == null ? this.fullyQualifiedTableName : partitionValues.toString();
            if (this.partitionPaths.containsKey(key)) {
                destLocation = this.partitionPaths.get(key);
            } else {
                if (partitionValues == null) {
                    destLocation = new Path(this.table.getSd().getLocation());
                } else {
                    PartitionInfo partitionInfo = this.conn.createPartitionIfNotExists(partitionValues);
                    this.updatedPartitions.add(partitionInfo.getName());
                    destLocation = new Path(partitionInfo.getPartitionLocation());
                }
                this.partitionPaths.put(key, destLocation);
            }
            this.updaters.computeIfAbsent(key, k -> this.initializeBuckets());
            recordUpdater = this.updaters.get(key).get(bucketId);
        }
        catch (StreamingException e) {
            throw new StreamingIOFailure("Unable to create partition: " + partitionValues + "for " + this.conn, e);
        }
        if (recordUpdater == null) {
            try {
                recordUpdater = this.createRecordUpdater(partitionValues, destLocation, bucketId, this.curBatchMinWriteId, this.curBatchMaxWriteId);
            }
            catch (IOException e) {
                String errMsg = "Failed creating RecordUpdater for " + this.getWatermark(destLocation.toString());
                LOG.error(errMsg, (Throwable)e);
                throw new StreamingIOFailure(errMsg, e);
            }
            List<RecordUpdater> partitionUpdaters = this.updaters.get(key);
            partitionUpdaters.set(bucketId, recordUpdater);
        }
        return recordUpdater;
    }

    protected List<RecordUpdater> initializeBuckets() {
        ArrayList<RecordUpdater> result = new ArrayList<RecordUpdater>(this.totalBuckets);
        for (int bucket = 0; bucket < this.totalBuckets; ++bucket) {
            result.add(bucket, null);
        }
        return result;
    }

    protected void logStats(String prefix) {
        int openRecordUpdaters = this.updaters.values().stream().mapToInt(List::size).sum();
        long bufferedRecords = this.updaters.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).mapToLong(RecordUpdater::getBufferedRowCount).sum();
        MemoryUsage memoryUsage = this.heapMemoryMonitor == null ? null : this.heapMemoryMonitor.getTenuredGenMemoryUsage();
        Object oldGenUsage = "NA";
        if (memoryUsage != null) {
            oldGenUsage = "used/max => " + LlapUtil.humanReadableByteCount((long)memoryUsage.getUsed()) + "/" + LlapUtil.humanReadableByteCount((long)memoryUsage.getMax());
        }
        LOG.debug("{} [record-updaters: {}, partitions: {}, buffered-records: {} total-records: {} buffered-ingest-size: {}, total-ingest-size: {} tenured-memory-usage: {}]", new Object[]{prefix, openRecordUpdaters, this.partitionPaths.size(), bufferedRecords, this.conn == null ? 0L : this.conn.getConnectionStats().getRecordsWritten(), LlapUtil.humanReadableByteCount((long)this.ingestSizeBytes), LlapUtil.humanReadableByteCount((long)(this.conn == null ? 0L : this.conn.getConnectionStats().getRecordsSize())), oldGenUsage});
    }

    protected static class OrcMemoryPressureMonitor
    implements HeapMemoryMonitor.Listener {
        private static final Logger LOG = LoggerFactory.getLogger((String)OrcMemoryPressureMonitor.class.getName());
        private final AtomicBoolean lowMemoryCanary;

        OrcMemoryPressureMonitor(AtomicBoolean lowMemoryCanary) {
            this.lowMemoryCanary = lowMemoryCanary;
        }

        public void memoryUsageAboveThreshold(long usedMemory, long maxMemory) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Orc memory pressure notified! usedMemory: {} maxMemory: {}.", (Object)LlapUtil.humanReadableByteCount((long)usedMemory), (Object)LlapUtil.humanReadableByteCount((long)maxMemory));
            }
            this.lowMemoryCanary.set(true);
        }
    }
}

