/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.streaming.ConnectionError;
import org.apache.hive.streaming.ConnectionStats;
import org.apache.hive.streaming.InvalidTable;
import org.apache.hive.streaming.PartitionInfo;
import org.apache.hive.streaming.RecordWriter;
import org.apache.hive.streaming.StreamingConnection;
import org.apache.hive.streaming.StreamingException;
import org.apache.hive.streaming.StreamingTransaction;
import org.apache.hive.streaming.TransactionBatch;
import org.apache.hive.streaming.UnManagedSingleTransaction;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStreamingConnection
implements StreamingConnection {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveStreamingConnection.class.getName());
    private static final String DEFAULT_METASTORE_URI = "thrift://localhost:9083";
    private static final int DEFAULT_TRANSACTION_BATCH_SIZE = 1;
    private static final boolean DEFAULT_STREAMING_OPTIMIZATIONS_ENABLED = true;
    private String database;
    private String table;
    private List<String> staticPartitionValues;
    private String agentInfo;
    private int transactionBatchSize;
    private RecordWriter recordWriter;
    private StreamingTransaction currentTransactionBatch;
    private HiveConf conf;
    private boolean streamingOptimizations;
    private AtomicBoolean isConnectionClosed = new AtomicBoolean(false);
    private boolean isPartitionedTable;
    private IMetaStoreClient msClient;
    private IMetaStoreClient heartbeatMSClient;
    private final String username;
    private final boolean secureMode;
    private Table tableObject = null;
    private String metastoreUri;
    private ConnectionStats connectionStats;
    private final Long writeId;
    private final Integer statementId;
    private boolean manageTransactions;
    private int countTransactions = 0;
    private Set<String> partitions;
    private Map<String, WriteDirInfo> writePaths;
    private Runnable onShutdownRunner;

    private HiveStreamingConnection(Builder builder) throws StreamingException {
        this.database = builder.database.toLowerCase();
        this.table = builder.table.toLowerCase();
        this.staticPartitionValues = builder.staticPartitionValues;
        this.conf = builder.hiveConf;
        this.agentInfo = builder.agentInfo;
        this.streamingOptimizations = builder.streamingOptimizations;
        this.writeId = builder.writeId;
        this.statementId = builder.statementId;
        this.tableObject = builder.tableObject;
        this.setPartitionedTable(builder.isPartitioned);
        this.manageTransactions = builder.manageTransactions;
        this.writePaths = new HashMap<String, WriteDirInfo>();
        UserGroupInformation loggedInUser = null;
        try {
            loggedInUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            LOG.warn("Unable to get logged in user via UGI. err: {}", (Object)e.getMessage());
        }
        if (loggedInUser == null) {
            this.username = System.getProperty("user.name");
            this.secureMode = false;
        } else {
            this.username = loggedInUser.getShortUserName();
            this.secureMode = loggedInUser.hasKerberosCredentials();
        }
        this.transactionBatchSize = builder.transactionBatchSize;
        this.recordWriter = builder.recordWriter;
        this.connectionStats = new ConnectionStats();
        if (this.agentInfo == null) {
            try {
                this.agentInfo = this.username + ":" + InetAddress.getLocalHost().getHostName() + ":" + Thread.currentThread().getName();
            }
            catch (UnknownHostException e) {
                this.agentInfo = UUID.randomUUID().toString();
            }
        }
        if (this.conf == null) {
            this.conf = this.createHiveConf(this.getClass(), DEFAULT_METASTORE_URI);
        }
        this.overrideConfSettings(this.conf);
        if (this.manageTransactions) {
            this.metastoreUri = this.conf.get(MetastoreConf.ConfVars.THRIFT_URIS.getHiveName());
            this.msClient = HiveStreamingConnection.getMetaStoreClient(this.conf, this.metastoreUri, this.secureMode, "streaming-connection");
            this.heartbeatMSClient = HiveStreamingConnection.getMetaStoreClient(this.conf, this.metastoreUri, this.secureMode, "streaming-connection-heartbeat");
            this.validateTable();
        }
        LOG.info("STREAMING CONNECTION INFO: {}", (Object)this.toConnectionInfoString());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void setPartitionedTable(Boolean isPartitionedTable) {
        this.isPartitionedTable = isPartitionedTable;
    }

    public String toString() {
        return "{ metaStoreUri: " + this.metastoreUri + ", database: " + this.database + ", table: " + this.table + " }";
    }

    private String toConnectionInfoString() {
        return "{ metastore-uri: " + this.metastoreUri + ", database: " + this.database + ", table: " + this.table + ", partitioned-table: " + this.isPartitionedTable() + ", dynamic-partitioning: " + this.isDynamicPartitioning() + ", username: " + this.username + ", secure-mode: " + this.secureMode + ", record-writer: " + this.recordWriter.getClass().getSimpleName() + ", agent-info: " + this.agentInfo + ", writeId: " + this.writeId + ", statementId: " + this.statementId + " }";
    }

    @VisibleForTesting
    String toTransactionString() {
        return this.currentTransactionBatch == null ? "" : this.currentTransactionBatch.toString();
    }

    @Override
    public PartitionInfo createPartitionIfNotExists(List<String> partitionValues) throws StreamingException {
        String partLocation = null;
        String partName = null;
        boolean exists = false;
        try {
            Map partSpec = Warehouse.makeSpecFromValues((List)this.tableObject.getPartitionKeys(), partitionValues);
            Path location = new Path(this.tableObject.getDataLocation(), Warehouse.makePartPath((Map)partSpec));
            location = new Path(Utilities.getQualifiedPath((HiveConf)this.conf, (Path)location));
            partLocation = location.toString();
            partName = Warehouse.makePartName((List)this.tableObject.getPartitionKeys(), partitionValues);
            org.apache.hadoop.hive.metastore.api.Partition partition = Partition.createMetaPartitionObject((Table)this.tableObject, (Map)partSpec, (Path)location);
            if (this.getMSC() == null) {
                return new PartitionInfo(partName, partLocation, false);
            }
            this.getMSC().add_partition(partition);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created partition {} for table {}", (Object)partName, (Object)this.tableObject.getFullyQualifiedName());
            }
        }
        catch (AlreadyExistsException e) {
            exists = true;
        }
        catch (HiveException | TException e) {
            throw new StreamingException("Unable to creation partition for values: " + partitionValues + " connection: " + this.toConnectionInfoString(), e);
        }
        return new PartitionInfo(partName, partLocation, exists);
    }

    @Override
    public Path getDeltaFileLocation(List<String> partitionValues, Integer bucketId, Long minWriteId, Long maxWriteId, Integer statementId) throws StreamingException {
        return this.recordWriter.getDeltaFileLocation(partitionValues, bucketId, minWriteId, maxWriteId, statementId, this.tableObject);
    }

    IMetaStoreClient getMSC() {
        this.connectionStats.incrementMetastoreCalls();
        return this.msClient;
    }

    IMetaStoreClient getHeatbeatMSC() {
        this.connectionStats.incrementMetastoreCalls();
        return this.heartbeatMSClient;
    }

    private void validateTable() throws InvalidTable, ConnectionError {
        block24: {
            try {
                this.tableObject = new Table(this.getMSC().getTable(this.database, this.table));
            }
            catch (Exception e) {
                LOG.warn("Unable to validate the table for connection: " + this.toConnectionInfoString(), (Throwable)e);
                throw new InvalidTable(this.database, this.table, e);
            }
            if (!AcidUtils.isFullAcidTable((Table)this.tableObject)) {
                LOG.error("HiveEndPoint " + this + " must use an acid table");
                throw new InvalidTable(this.database, this.table, "is not an Acid table");
            }
            if (this.tableObject.getPartitionKeys() != null && !this.tableObject.getPartitionKeys().isEmpty()) {
                this.setPartitionedTable(true);
            } else {
                this.setPartitionedTable(false);
            }
            if (!this.isPartitionedTable() && this.staticPartitionValues != null && !this.staticPartitionValues.isEmpty()) {
                String errMsg = this.toString() + " specifies partitions for un-partitioned table";
                LOG.error(errMsg);
                throw new ConnectionError(errMsg);
            }
            if (this.transactionBatchSize > 1) {
                try (FileSystem fs = this.tableObject.getDataLocation().getFileSystem((Configuration)this.conf);){
                    if (!BlobStorageUtils.isBlobStorageFileSystem((Configuration)this.conf, (FileSystem)fs)) break block24;
                    Path path = new Path("/tmp", "_tmp_stream_verify_" + UUID.randomUUID().toString());
                    try (FSDataOutputStream out = fs.create(path, false);){
                        if (!out.hasCapability("hflush")) {
                            throw new ConnectionError("The backing filesystem only supports transaction batch sizes of 1, but " + this.transactionBatchSize + " was requested.");
                        }
                        fs.deleteOnExit(path);
                    }
                    catch (IOException e) {
                        throw new ConnectionError("Could not create path for database", (Exception)e);
                    }
                }
                catch (IOException e) {
                    throw new ConnectionError("Could not retrieve FileSystem of table", (Exception)e);
                }
            }
        }
    }

    private void beginNextTransaction() throws StreamingException {
        if (this.currentTransactionBatch == null) {
            this.currentTransactionBatch = this.createNewTransactionBatch();
            LOG.info("Opened new transaction batch {}", (Object)this.currentTransactionBatch);
        }
        if (this.currentTransactionBatch.isClosed()) {
            throw new StreamingException("Cannot begin next transaction on a closed streaming connection");
        }
        if (this.currentTransactionBatch.remainingTransactions() == 0) {
            LOG.info("Transaction batch {} is done. Rolling over to next transaction batch.", (Object)this.currentTransactionBatch);
            this.closeCurrentTransactionBatch();
            this.currentTransactionBatch = this.createNewTransactionBatch();
            LOG.info("Rolled over to new transaction batch {}", (Object)this.currentTransactionBatch);
        }
        this.currentTransactionBatch.beginNextTransaction();
    }

    private StreamingTransaction createNewTransactionBatch() throws StreamingException {
        ++this.countTransactions;
        if (this.manageTransactions) {
            return new TransactionBatch(this);
        }
        if (this.countTransactions > 1) {
            throw new StreamingException("If a writeId is passed for the construction of HiveStreaming only one transaction batch can be done");
        }
        return new UnManagedSingleTransaction(this);
    }

    private void checkClosedState() throws StreamingException {
        if (this.isConnectionClosed.get()) {
            throw new StreamingException("Streaming connection is closed already.");
        }
    }

    private void checkState() throws StreamingException {
        this.checkClosedState();
        if (this.currentTransactionBatch == null) {
            throw new StreamingException("Transaction batch is null. Missing beginTransaction?");
        }
        if (this.currentTransactionBatch.getCurrentTransactionState() != TxnState.OPEN) {
            throw new StreamingException("Transaction state is not OPEN. Missing beginTransaction?");
        }
    }

    private void closeCurrentTransactionBatch() throws StreamingException {
        this.currentTransactionBatch.close();
        this.writePaths.clear();
    }

    @Override
    public void beginTransaction() throws StreamingException {
        this.checkClosedState();
        this.partitions = new HashSet<String>();
        this.beginNextTransaction();
    }

    @Override
    public void commitTransaction() throws StreamingException {
        this.commitTransaction(null);
    }

    @Override
    public void commitTransaction(Set<String> partitions) throws StreamingException {
        this.commitTransaction(partitions, null, null);
    }

    @Override
    public void commitTransaction(Set<String> partitions, String key, String value) throws StreamingException {
        this.checkState();
        HashSet<String> createdPartitions = new HashSet<String>();
        if (partitions != null) {
            for (String partition : partitions) {
                try {
                    PartitionInfo info = this.createPartitionIfNotExists(Warehouse.getPartValuesFromPartName((String)partition));
                    if (info.isExists()) continue;
                    createdPartitions.add(partition);
                }
                catch (MetaException e) {
                    throw new StreamingException("Partition " + partition + " is invalid.", e);
                }
            }
            this.connectionStats.incrementTotalPartitions(partitions.size());
        }
        this.currentTransactionBatch.commit(createdPartitions, key, value);
        this.partitions.addAll(this.currentTransactionBatch.getPartitions());
        this.connectionStats.incrementCreatedPartitions(createdPartitions.size());
        this.connectionStats.incrementCommittedTransactions();
    }

    @Override
    public void abortTransaction() throws StreamingException {
        this.checkState();
        this.currentTransactionBatch.abort();
        this.connectionStats.incrementAbortedTransactions();
    }

    @Override
    public void write(byte[] record) throws StreamingException {
        this.checkState();
        this.currentTransactionBatch.write(record);
    }

    @Override
    public void write(InputStream inputStream) throws StreamingException {
        this.checkState();
        this.currentTransactionBatch.write(inputStream);
    }

    @Override
    public void close() {
        if (this.isConnectionClosed.get()) {
            return;
        }
        this.isConnectionClosed.set(true);
        try {
            if (this.currentTransactionBatch != null) {
                this.closeCurrentTransactionBatch();
            }
        }
        catch (StreamingException e) {
            LOG.warn("Unable to close current transaction batch: " + this.currentTransactionBatch, (Throwable)e);
        }
        finally {
            if (this.manageTransactions) {
                this.getMSC().close();
                this.getHeatbeatMSC().close();
                try {
                    Hive.get((HiveConf)this.conf).getSynchronizedMSC().close();
                }
                catch (Exception e) {
                    LOG.warn("Error while closing HMS connection", (Throwable)e);
                }
            }
            if (!ShutdownHookManager.isShutdownInProgress()) {
                ShutdownHookManager.removeShutdownHook((Runnable)this.onShutdownRunner);
            }
        }
        LOG.info("Closed streaming connection. Agent: {} Stats: {}", (Object)this.getAgentInfo(), (Object)this.getConnectionStats());
    }

    @Override
    public ConnectionStats getConnectionStats() {
        return this.connectionStats;
    }

    private static IMetaStoreClient getMetaStoreClient(HiveConf conf, String metastoreUri, boolean secureMode, String owner) throws ConnectionError {
        if (metastoreUri != null) {
            conf.set(MetastoreConf.ConfVars.THRIFT_URIS.getHiveName(), metastoreUri);
        }
        if (secureMode) {
            conf.setBoolean(MetastoreConf.ConfVars.USE_THRIFT_SASL.getHiveName(), true);
        }
        try {
            LOG.info("Creating metastore client for {}", (Object)owner);
            return HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)conf);
        }
        catch (IOException | MetaException e) {
            throw new ConnectionError("Error connecting to Hive Metastore URI: " + metastoreUri + ". " + e.getMessage(), (Exception)e);
        }
    }

    @Override
    public void addWriteDirectoryInfo(List<String> partitionValues, Path writeDir) {
        String key;
        String string = key = partitionValues == null ? this.tableObject.getFullyQualifiedName() : partitionValues.toString();
        if (this.writePaths.containsKey(key)) {
            WriteDirInfo dirInfo = this.writePaths.get(key);
            assert (dirInfo.getWriteDir().equals((Object)writeDir));
        } else {
            this.writePaths.put(key, new WriteDirInfo(partitionValues, writeDir));
        }
    }

    @Override
    public void addWriteNotificationEvents() throws StreamingException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug("Write notification log is ignored as dml event logging is disabled.");
            return;
        }
        try {
            Long currentTxnId = this.getCurrentTxnId();
            Long currentWriteId = this.getCurrentWriteId();
            for (WriteDirInfo writeInfo : this.writePaths.values()) {
                LOG.debug("TxnId: " + currentTxnId + ", WriteId: " + currentWriteId + " - Logging write event for the files in path " + writeInfo.getWriteDir());
                FileSystem fs = this.tableObject.getDataLocation().getFileSystem((Configuration)this.conf);
                List newFiles = HdfsUtils.listLocatedFileStatus((FileSystem)fs, (Path)writeInfo.getWriteDir(), null, (boolean)true);
                if (newFiles.isEmpty()) {
                    LOG.debug("TxnId: " + currentTxnId + ", WriteId: " + currentWriteId + " - Skipping empty path " + writeInfo.getWriteDir());
                    continue;
                }
                Hive.addWriteNotificationLog((HiveConf)this.conf, (Table)this.tableObject, writeInfo.getPartitionVals(), (Long)currentTxnId, (Long)currentWriteId, (List)newFiles, null);
            }
        }
        catch (IOException | HiveException | TException e) {
            throw new StreamingException("Failed to log write notification events.", e);
        }
    }

    @VisibleForTesting
    TxnState getCurrentTransactionState() {
        return this.currentTransactionBatch.getCurrentTransactionState();
    }

    @VisibleForTesting
    int remainingTransactions() {
        return this.currentTransactionBatch.remainingTransactions();
    }

    @VisibleForTesting
    Long getCurrentTxnId() {
        return this.currentTransactionBatch.getCurrentTxnId();
    }

    private HiveConf createHiveConf(Class<?> clazz, String metaStoreUri) {
        HiveConf conf = new HiveConf(clazz);
        if (metaStoreUri != null) {
            conf.set(MetastoreConf.ConfVars.THRIFT_URIS.getHiveName(), metaStoreUri);
        }
        return conf;
    }

    private void overrideConfSettings(HiveConf conf) {
        HiveStreamingConnection.setHiveConf(conf, HiveConf.ConfVars.HIVE_TXN_MANAGER, DbTxnManager.class.getName());
        HiveStreamingConnection.setHiveConf(conf, HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        HiveStreamingConnection.setHiveConf(conf, MetastoreConf.ConfVars.EXECUTE_SET_UGI.getHiveName());
        HiveStreamingConnection.setHiveConf(conf, HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, "nonstrict");
        if (this.streamingOptimizations) {
            HiveStreamingConnection.setHiveConf(conf, HiveConf.ConfVars.HIVE_ORC_DELTA_STREAMING_OPTIMIZATIONS_ENABLED, true);
        }
        HiveStreamingConnection.setHiveConf(conf, HiveConf.ConfVars.METASTORE_CLIENT_CACHE_ENABLED, false);
    }

    private static void setHiveConf(HiveConf conf, HiveConf.ConfVars var, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overriding HiveConf setting : " + var + " = " + value);
        }
        conf.setVar(var, value);
    }

    private static void setHiveConf(HiveConf conf, HiveConf.ConfVars var, boolean value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overriding HiveConf setting : " + var + " = " + value);
        }
        conf.setBoolVar(var, value);
    }

    private static void setHiveConf(HiveConf conf, String var) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overriding HiveConf setting : " + var + " = true");
        }
        conf.setBoolean(var, true);
    }

    public List<TxnToWriteId> getTxnToWriteIds() {
        if (this.currentTransactionBatch != null) {
            return this.currentTransactionBatch.getTxnToWriteIds();
        }
        return null;
    }

    @Override
    public HiveConf getHiveConf() {
        return this.conf;
    }

    @Override
    public String getMetastoreUri() {
        return this.metastoreUri;
    }

    @Override
    public Table getTable() {
        return this.tableObject;
    }

    @Override
    public List<String> getStaticPartitionValues() {
        return this.staticPartitionValues;
    }

    @Override
    public String getAgentInfo() {
        return this.agentInfo;
    }

    @Override
    public boolean isPartitionedTable() {
        return this.isPartitionedTable;
    }

    @Override
    public boolean isDynamicPartitioning() {
        return this.isPartitionedTable() && (this.staticPartitionValues == null || this.staticPartitionValues.isEmpty());
    }

    @Override
    public Set<String> getPartitions() {
        return this.partitions;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabase() {
        return this.database;
    }

    public RecordWriter getRecordWriter() {
        return this.recordWriter;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Long getWriteId() {
        return this.writeId;
    }

    public Integer getStatementId() {
        return this.statementId;
    }

    public Long getCurrentWriteId() {
        return this.currentTransactionBatch.getCurrentWriteId();
    }

    public static class Builder {
        private String database;
        private String table;
        private List<String> staticPartitionValues;
        private String agentInfo;
        private HiveConf hiveConf;
        private int transactionBatchSize = 1;
        private boolean streamingOptimizations = true;
        private RecordWriter recordWriter;
        private long writeId = -1L;
        private int statementId = -1;
        private boolean manageTransactions = true;
        private Table tableObject;
        private boolean isPartitioned;

        public Builder withDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder withTable(String table) {
            this.table = table;
            return this;
        }

        public Builder withStaticPartitionValues(List<String> staticPartitionValues) {
            this.staticPartitionValues = staticPartitionValues == null ? null : new ArrayList<String>(staticPartitionValues);
            return this;
        }

        public Builder withAgentInfo(String agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        public Builder withHiveConf(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
            return this;
        }

        @InterfaceStability.Evolving
        public Builder withTransactionBatchSize(int transactionBatchSize) {
            this.transactionBatchSize = transactionBatchSize;
            return this;
        }

        public Builder withStreamingOptimizations(boolean enable) {
            this.streamingOptimizations = enable;
            return this;
        }

        public Builder withRecordWriter(RecordWriter recordWriter) {
            this.recordWriter = recordWriter;
            return this;
        }

        public Builder withWriteId(long writeId) {
            this.writeId = writeId;
            this.manageTransactions = false;
            return this;
        }

        public Builder withStatementId(int statementId) {
            this.statementId = statementId;
            return this;
        }

        public Builder withTableObject(Table table) {
            this.tableObject = table;
            this.isPartitioned = this.tableObject.getPartitionKeys() != null && !this.tableObject.getPartitionKeys().isEmpty();
            return this;
        }

        public HiveStreamingConnection connect() throws StreamingException {
            if (this.database == null) {
                throw new StreamingException("Database cannot be null for streaming connection");
            }
            if (this.table == null) {
                if (this.tableObject == null) {
                    throw new StreamingException("Table and table object cannot be null for streaming connection");
                }
                this.table = this.tableObject.getTableName();
            }
            if (this.tableObject != null && !this.tableObject.getTableName().equals(this.table)) {
                throw new StreamingException("Table must match tableObject table name");
            }
            if (this.recordWriter == null) {
                throw new StreamingException("Record writer cannot be null for streaming connection");
            }
            if (this.writeId != -1L && this.tableObject == null || this.writeId == -1L && this.tableObject != null) {
                throw new StreamingException("If writeId is set, tableObject must be set as well and vice versa");
            }
            HiveStreamingConnection streamingConnection = new HiveStreamingConnection(this);
            streamingConnection.onShutdownRunner = streamingConnection::close;
            ShutdownHookManager.addShutdownHook((Runnable)streamingConnection.onShutdownRunner, (int)11);
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> streamingConnection.close());
            return streamingConnection;
        }
    }

    public static enum TxnState {
        INACTIVE("I"),
        OPEN("O"),
        COMMITTED("C"),
        ABORTED("A"),
        PREPARED_FOR_COMMIT("P");

        private final String code;

        private TxnState(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }
    }

    private static class WriteDirInfo {
        List<String> partitionVals;
        Path writeDir;

        WriteDirInfo(List<String> partitionVals, Path writeDir) {
            this.partitionVals = partitionVals;
            this.writeDir = writeDir;
        }

        List<String> getPartitionVals() {
            return this.partitionVals;
        }

        Path getWriteDir() {
            return this.writeDir;
        }
    }
}

