/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.AuthenticationException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.AuthenticationProviderFactory;
import org.apache.hive.service.auth.HttpAuthService;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.hive.service.auth.HttpAuthenticationException;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthService
extends HttpAuthService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthService.class);
    private final PasswdAuthenticationProvider authProvider;

    public LdapAuthService(HiveConf hiveConf, PasswdAuthenticationProvider provider) {
        super(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_HTTP_COOKIE_DOMAIN), hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_HTTP_COOKIE_PATH), (int)hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_HTTP_COOKIE_MAX_AGE, TimeUnit.SECONDS), hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL), "hive.server2.webui.auth");
        if (provider != null) {
            this.authProvider = provider;
        } else {
            try {
                this.authProvider = AuthenticationProviderFactory.getAuthenticationProvider(AuthenticationProviderFactory.AuthMethods.LDAP, hiveConf);
            }
            catch (AuthenticationException e) {
                throw new ServiceException(e);
            }
        }
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        try {
            String clientUserName = this.validateCookie(request);
            if (clientUserName == null) {
                clientUserName = this.getUsername(request);
                this.authProvider.authenticate(clientUserName, this.getPassword(request));
                String cookieToken = HttpAuthUtils.createCookieToken(clientUserName);
                Cookie hs2Cookie = this.signAndCreateCookie(cookieToken);
                response.addCookie(hs2Cookie);
            }
        }
        catch (UnsupportedEncodingException | AuthenticationException | HttpAuthenticationException e) {
            LOG.debug("Error in authenticating HTTP request", (Throwable)e);
            return false;
        }
        return true;
    }
}

