/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation.hplsql;

import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.thrift.Type;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hplsql.Arguments;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.ResultListener;
import org.apache.hive.hplsql.executor.Metadata;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;

public class HplSqlOperation
extends ExecuteStatementOperation
implements ResultListener {
    private final Exec exec;
    private final boolean runInBackground;
    private RowSet rowSet;
    private TableSchema schema;

    public HplSqlOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, Exec exec) {
        super(parentSession, statement, confOverlay, runInBackground, false);
        this.exec = exec;
        this.runInBackground = runInBackground;
        this.exec.setResultListener((ResultListener)this);
    }

    @Override
    protected void runInternal() throws HiveSQLException {
        this.setState(OperationState.PENDING);
        if (!this.runInBackground) {
            this.interpret();
        } else {
            BackgroundWork work = new BackgroundWork(this.getCurrentUGI(), this.parentSession.getSessionHive(), SessionState.get());
            try {
                Future<?> backgroundHandle = this.getParentSession().submitBackgroundOperation(work);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
            }
        }
    }

    private void interpret() throws HiveSQLException {
        try {
            OperationState opState = this.getState();
            if (opState.isTerminal()) {
                this.log.info("Not running the query. Operation is already in terminal state: " + opState + ", perhaps cancelled due to query timeout or by another thread.");
                return;
            }
            this.setState(OperationState.RUNNING);
            Arguments args = new Arguments();
            args.parse(new String[]{"-e", this.statement});
            this.exec.parseAndEval(args);
            this.setState(OperationState.FINISHED);
        }
        catch (Throwable e) {
            if (this.getState().isTerminal()) {
                this.log.warn("Ignore exception in terminal state: {}", (Object)this.getState(), (Object)e);
                return;
            }
            this.setState(OperationState.ERROR);
            if (e instanceof HiveSQLException) {
                throw (HiveSQLException)e;
            }
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new HiveSQLException("Error running HPL/SQL operation", e);
        }
        finally {
            this.exec.printExceptions();
        }
    }

    @Override
    public void cancel(OperationState stateAfterCancel) {
        throw new UnsupportedOperationException("HplSqlOperation.cancel()");
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
        this.cleanupOperationLog(0L);
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        return this.schema;
    }

    private static TableSchema convertToTableSchema(Metadata metadata) {
        TableSchema tableSchema = new TableSchema(metadata.columnCount());
        for (int i = 0; i < metadata.columnCount(); ++i) {
            tableSchema.addPrimitiveColumn(metadata.columnName(i), Type.fromJavaSQLType((int)metadata.jdbcType(i)), null);
        }
        return tableSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }

    @Override
    public OperationType getType() {
        return OperationType.PROCEDURAL_SQL;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runInBackground;
    }

    public void onRow(Object[] rows) {
        this.rowSet.addRow(rows);
    }

    public void onMetadata(Metadata metadata) {
        this.schema = HplSqlOperation.convertToTableSchema(metadata);
        this.rowSet = RowSetFactory.create(this.schema, this.getProtocolVersion(), false);
        this.setHasResultSet(true);
    }

    private UserGroupInformation getCurrentUGI() throws HiveSQLException {
        try {
            return Utils.getUGI();
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get current user", e);
        }
    }

    private final class BackgroundWork
    implements Runnable {
        private final UserGroupInformation currentUGI;
        private final Hive parentHive;
        private final SessionState parentSessionState;

        private BackgroundWork(UserGroupInformation currentUGI, Hive parentHive, SessionState parentSessionState) {
            this.currentUGI = currentUGI;
            this.parentHive = parentHive;
            this.parentSessionState = parentSessionState;
        }

        @Override
        public void run() {
            PrivilegedExceptionAction<Object> doAsAction = () -> {
                assert (!this.parentHive.allowClose());
                Hive.set((Hive)this.parentHive);
                SessionState.setCurrentSessionState((SessionState)this.parentSessionState);
                SessionState.getPerfLogger();
                LogUtils.registerLoggingContext((Configuration)HplSqlOperation.this.queryState.getConf());
                ShimLoader.getHadoopShims().setHadoopQueryContext(String.format("%s_User:%s", HplSqlOperation.this.queryState.getQueryId(), this.parentSessionState.getUserName()));
                try {
                    HplSqlOperation.this.interpret();
                }
                catch (HiveSQLException e) {
                    HplSqlOperation.this.setOperationException(e);
                    HplSqlOperation.this.log.error("Error running hive query", (Throwable)e);
                }
                finally {
                    LogUtils.unregisterLoggingContext();
                    Hive.closeCurrent();
                }
                return null;
            };
            try {
                this.currentUGI.doAs(doAsAction);
            }
            catch (Exception e) {
                HplSqlOperation.this.setOperationException(new HiveSQLException(e));
                HplSqlOperation.this.log.error("Error running hive query as user : {}", (Object)this.currentUGI.getShortUserName(), (Object)e);
            }
            finally {
                if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
                    ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
                    currentThread.cacheThreadLocalRawStore();
                }
            }
        }
    }
}

