/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.ProactiveEvictingCachePolicy;

public class CacheContentsTracker
implements LowLevelCachePolicy,
ProactiveEvictingCachePolicy,
EvictionListener {
    private static final long CLEANUP_TIME_MS = 3600000L;
    private static final long MIN_TIME_MS = 300000L;
    private final ConcurrentSkipListMap<CacheTag, TagState> tagInfo = new ConcurrentSkipListMap();
    private EvictionListener evictionListener;
    private LowLevelCachePolicy realPolicy;
    private final Thread cleanupThread;

    public CacheContentsTracker(LowLevelCachePolicy realPolicy) {
        this.realPolicy = realPolicy;
        realPolicy.setEvictionListener(this);
        this.cleanupThread = new Thread(new CleanupRunnable());
        this.cleanupThread.start();
    }

    private void reportCached(LlapCacheableBuffer buffer) {
        long size = buffer.getMemoryUsage();
        TagState state = this.getTagState(buffer);
        this.reportCached(state, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCached(TagState state, long size) {
        TagState tagState = state;
        synchronized (tagState) {
            ++state.bufferCount;
            state.totalSize += size;
            state.maxSize = Math.max(state.maxSize, state.totalSize);
            state.maxCount = Math.max(state.maxCount, state.bufferCount);
        }
    }

    private void reportRemoved(LlapCacheableBuffer buffer) {
        long size = buffer.getMemoryUsage();
        TagState state = this.getTagState(buffer);
        this.reportRemoved(state, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportRemoved(TagState state, long size) {
        TagState tagState = state;
        synchronized (tagState) {
            --state.bufferCount;
            assert (state.bufferCount >= 0L);
            state.totalSize -= size;
            if (state.bufferCount == 0L) {
                state.emptyTimeNs = System.nanoTime();
            }
        }
    }

    private TagState getTagState(LlapCacheableBuffer buffer) {
        return this.getTagState(buffer.getTag());
    }

    private TagState getTagState(CacheTag tag) {
        TagState state = this.tagInfo.get(tag);
        if (state == null) {
            state = new TagState(tag);
            TagState old = this.tagInfo.putIfAbsent(tag, state);
            state = old == null ? state : old;
        }
        return state;
    }

    @Override
    public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority priority) {
        this.realPolicy.cache(buffer, priority);
        this.reportCached(buffer);
    }

    @Override
    public void notifyLock(LlapCacheableBuffer buffer) {
        this.realPolicy.notifyLock(buffer);
    }

    @Override
    public void notifyUnlock(LlapCacheableBuffer buffer) {
        this.realPolicy.notifyUnlock(buffer);
    }

    @Override
    public void setEvictionListener(EvictionListener listener) {
        this.evictionListener = listener;
    }

    @Override
    public long purge() {
        return this.realPolicy.purge();
    }

    @Override
    public long evictSomeBlocks(long memoryToReserve) {
        return this.realPolicy.evictSomeBlocks(memoryToReserve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugDumpShort(StringBuilder sb) {
        ArrayList<String> endResult = new ArrayList<String>();
        TreeMap<CacheTag, TagState> summaries = new TreeMap<CacheTag, TagState>();
        Iterator<TagState> iterator = this.tagInfo.values().iterator();
        while (iterator.hasNext()) {
            TagState state;
            TagState tagState = state = iterator.next();
            synchronized (tagState) {
                endResult.add(this.unsafePrintTagState(state));
                CacheTag parentTag = CacheTag.createParentCacheTag((CacheTag)state.cacheTag);
                while (parentTag != null) {
                    if (!summaries.containsKey(parentTag)) {
                        summaries.put(parentTag, new TagState(parentTag));
                    }
                    TagState parentState = (TagState)summaries.get(parentTag);
                    parentState.bufferCount += state.bufferCount;
                    parentState.maxCount += state.maxCount;
                    parentState.totalSize += state.totalSize;
                    parentState.maxSize += state.maxSize;
                    parentTag = CacheTag.createParentCacheTag((CacheTag)parentTag);
                }
            }
        }
        for (TagState state : summaries.values()) {
            endResult.add(this.unsafePrintTagState(state));
        }
        sb.append("\nCache state: \n");
        sb.append(endResult.stream().sorted().collect(Collectors.joining("\n")));
    }

    private String unsafePrintTagState(TagState state) {
        StringBuilder sb = new StringBuilder();
        sb.append(state.cacheTag.getTableName());
        if (state.cacheTag instanceof CacheTag.PartitionCacheTag) {
            sb.append("/").append(String.join((CharSequence)"/", ((CacheTag.PartitionCacheTag)state.cacheTag).partitionDescToString()));
        }
        sb.append(" : ").append(state.bufferCount).append("/").append(state.maxCount).append(", ").append(state.totalSize).append("/").append(state.maxSize);
        return sb.toString();
    }

    @Override
    public void notifyEvicted(LlapCacheableBuffer buffer) {
        this.evictionListener.notifyEvicted(buffer);
        this.reportRemoved(buffer);
    }

    @Override
    public void notifyProactivelyEvicted(LlapCacheableBuffer buffer) {
        this.evictionListener.notifyProactivelyEvicted(buffer);
        this.reportRemoved(buffer);
    }

    @Override
    public void notifyProactiveEvictionMark() {
        if (this.realPolicy instanceof ProactiveEvictingCachePolicy) {
            ((ProactiveEvictingCachePolicy)((Object)this.realPolicy)).notifyProactiveEvictionMark();
        }
    }

    private final class CleanupRunnable
    implements Runnable {
        private CleanupRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long cleanupTimeNs = 3600000000000L;
            long sleepTimeMs = 3600000L;
            try {
                while (true) {
                    Thread.sleep(sleepTimeMs);
                    long timeNs = System.nanoTime();
                    long nextCleanupInNs = 3600000000000L;
                    Iterator<TagState> iter = CacheContentsTracker.this.tagInfo.values().iterator();
                    while (iter.hasNext()) {
                        TagState v;
                        TagState tagState = v = iter.next();
                        synchronized (tagState) {
                            if (v.bufferCount > 0L) {
                                continue;
                            }
                            long deltaNs = timeNs - v.emptyTimeNs;
                            if (deltaNs < 3600000000000L) {
                                nextCleanupInNs = Math.min(nextCleanupInNs, deltaNs);
                                continue;
                            }
                            iter.remove();
                        }
                    }
                    sleepTimeMs = Math.max(300000L, nextCleanupInNs / 1000000L);
                }
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    private static class TagState {
        public final CacheTag cacheTag;
        public long emptyTimeNs;
        public long bufferCount;
        public long totalSize;
        public long maxCount;
        public long maxSize;

        TagState(CacheTag cacheTag) {
            this.cacheTag = cacheTag;
        }
    }
}

