/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import java.util.concurrent.Callable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.CompressionUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncTaskDownloadTezJars
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AsyncTaskDownloadTezJars.class.getName());
    private final HiveConf conf;
    private final FileSystem fs;
    private final FileSystem rawFs;
    private final Path libDir;
    private final Path tezDir;

    AsyncTaskDownloadTezJars(HiveConf conf, FileSystem fs, FileSystem rawFs, Path libDir, Path tezDir) {
        this.conf = conf;
        this.fs = fs;
        this.rawFs = rawFs;
        this.libDir = libDir;
        this.tezDir = tezDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        FileSystem fileSystem = this.fs;
        synchronized (fileSystem) {
            String tezLibs = this.conf.get("tez.lib.uris");
            if (tezLibs == null) {
                LOG.warn("Missing tez.lib.uris in tez-site.xml");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copying tez libs from " + tezLibs);
            }
            this.rawFs.mkdirs(this.tezDir);
            this.fs.copyToLocalFile(new Path(tezLibs), new Path(this.libDir, "tez.tar.gz"));
            CompressionUtils.unTar((String)new Path(this.libDir, "tez.tar.gz").toString(), (String)this.tezDir.toString(), (boolean)true);
            this.rawFs.delete(new Path(this.libDir, "tez.tar.gz"), false);
        }
        return null;
    }
}

