/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JvmPauseMonitor;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.OTELUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.hive.llap.LlapOutputFormatService;
import org.apache.hadoop.hive.llap.LlapUgiManager;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.daemon.ContainerRunner;
import org.apache.hadoop.hive.llap.daemon.QueryFailedHandler;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.ContainerRunnerImpl;
import org.apache.hadoop.hive.llap.daemon.impl.DefaultLlapTokenManager;
import org.apache.hadoop.hive.llap.daemon.impl.DummyTokenManager;
import org.apache.hadoop.hive.llap.daemon.impl.FunctionLocalizer;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemonMXBean;
import org.apache.hadoop.hive.llap.daemon.impl.LlapLoadGeneratorService;
import org.apache.hadoop.hive.llap.daemon.impl.LlapProtocolServerImpl;
import org.apache.hadoop.hive.llap.daemon.impl.LlapTokenManager;
import org.apache.hadoop.hive.llap.daemon.impl.LocalDirCleaner;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.daemon.impl.QueryTracker;
import org.apache.hadoop.hive.llap.daemon.impl.StaticPermanentFunctionChecker;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.daemon.services.impl.LlapWebServices;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.llap.metrics.LLAPOTELExporter;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonJvmMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.security.LlapExtClientJwtHelper;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.hive.llap.shufflehandler.ShuffleHandler;
import org.apache.hadoop.hive.ql.ServiceContext;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapDaemon
extends CompositeService
implements ContainerRunner,
LlapDaemonMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(LlapDaemon.class);
    private final Configuration shuffleHandlerConf;
    private final SecretManager secretManager;
    private final LlapProtocolServerImpl server;
    private final ContainerRunnerImpl containerRunner;
    private final AMReporter amReporter;
    private final LlapRegistryService registry;
    private final LlapWebServices webServices;
    private final LlapLoadGeneratorService llapLoadGeneratorService;
    private final AtomicLong numSubmissions = new AtomicLong(0L);
    private final JvmPauseMonitor pauseMonitor;
    private final ObjectName llapDaemonInfoBean;
    private final LlapDaemonExecutorMetrics metrics;
    private final FunctionLocalizer fnLocalizer;
    private final boolean llapIoEnabled;
    private final long executorMemoryPerInstance;
    private final long ioMemoryPerInstance;
    private final int numExecutors;
    private final long maxJvmMemory;
    private final String[] localDirs;
    private final DaemonId daemonId;
    private final SocketFactory socketFactory;
    private final LlapTokenManager llapTokenManager;
    private LLAPOTELExporter otelExporter = null;
    private final AtomicReference<InetSocketAddress> srvAddress = new AtomicReference();
    private final AtomicReference<InetSocketAddress> mngAddress = new AtomicReference();
    private final AtomicReference<Integer> shufflePort = new AtomicReference();

    public LlapDaemon(Configuration daemonConf, int numExecutors, long executorMemoryBytes, boolean ioEnabled, boolean isDirectCache, long ioMemoryBytes, String[] localDirs, int srvPort, boolean externalClientCloudSetupEnabled, int externalClientsRpcPort, int mngPort, int shufflePort, int webPort, String appName) {
        super("LlapDaemon");
        this.printAsciiArt();
        Preconditions.checkArgument((numExecutors > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((srvPort == 0 || srvPort > 1024 && srvPort < 65536 ? 1 : 0) != 0, (Object)"Server RPC Port must be between 1025 and 65535, or 0 automatic selection");
        if (externalClientCloudSetupEnabled) {
            Preconditions.checkArgument((externalClientsRpcPort == 0 || externalClientsRpcPort > 1024 && externalClientsRpcPort < 65536 ? 1 : 0) != 0, (Object)"Server RPC port for external clients must be between 1025 and 65535, or 0 automatic selection");
        }
        Preconditions.checkArgument((mngPort == 0 || mngPort > 1024 && mngPort < 65536 ? 1 : 0) != 0, (Object)"Management RPC Port must be between 1025 and 65535, or 0 automatic selection");
        Preconditions.checkArgument((localDirs != null && localDirs.length > 0 ? 1 : 0) != 0, (Object)"Work dirs must be specified");
        Preconditions.checkArgument((shufflePort == 0 || shufflePort > 1024 && shufflePort < 65536 ? 1 : 0) != 0, (Object)"Shuffle Port must be between 1024 and 65535, or 0 for automatic selection");
        int outputFormatServicePort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_OUTPUT_SERVICE_PORT);
        Preconditions.checkArgument((outputFormatServicePort == 0 || outputFormatServicePort > 1024 && outputFormatServicePort < 65536 ? 1 : 0) != 0, (Object)"OutputFormatService Port must be between 1024 and 65535, or 0 for automatic selection");
        String hosts = HiveConf.getTrimmedVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        if (hosts.startsWith("@")) {
            String zkHosts = HiveConf.getTrimmedVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM);
            LOG.info("Zookeeper Quorum: {}", (Object)zkHosts);
            Preconditions.checkArgument((zkHosts != null && !zkHosts.trim().isEmpty() ? 1 : 0) != 0, (Object)"LLAP service hosts startswith '@' but hive.zookeeper.quorum is not set. hive.zookeeper.quorum must be set.");
        }
        String hostName = MetricsUtils.getHostName();
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                String daemonPrincipal = HiveConf.getVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL);
                String daemonKeytab = HiveConf.getVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE);
                LlapUtil.loginWithKerberosAndUpdateCurrentUser((String)daemonPrincipal, (String)daemonKeytab);
            }
            String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
            LOG.info("Starting daemon as user: {}", (Object)currentUser);
            this.daemonId = new DaemonId(currentUser, LlapUtil.generateClusterName((Configuration)daemonConf), hostName, appName, System.currentTimeMillis());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.maxJvmMemory = LlapDaemon.getTotalHeapSize();
        this.llapIoEnabled = ioEnabled;
        long xmxHeadRoomBytes = LlapDaemon.determineXmxHeadroom(daemonConf, executorMemoryBytes, this.maxJvmMemory);
        this.executorMemoryPerInstance = executorMemoryBytes - xmxHeadRoomBytes;
        this.ioMemoryPerInstance = ioMemoryBytes;
        this.numExecutors = numExecutors;
        this.localDirs = localDirs;
        int waitQueueSize = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_WAIT_QUEUE_SIZE);
        boolean enablePreemption = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_ENABLE_PREEMPTION);
        int timedWindowAverageDataPoints = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_METRICS_TIMED_WINDOW_AVERAGE_DATA_POINTS);
        long timedWindowAverageWindowLength = HiveConf.getTimeVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_METRICS_TIMED_WINDOW_AVERAGE_WINDOW_LENGTH, (TimeUnit)TimeUnit.NANOSECONDS);
        int simpleAverageWindowDataSize = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_METRICS_SIMPLE_AVERAGE_DATA_POINTS);
        Preconditions.checkArgument((timedWindowAverageDataPoints >= 0 ? 1 : 0) != 0, (Object)"hive.llap.daemon.metrics.timed.window.average.data.points should be greater or equal to 0");
        Preconditions.checkArgument((timedWindowAverageDataPoints == 0 || timedWindowAverageWindowLength > 0L ? 1 : 0) != 0, (Object)"hive.llap.daemon.metrics.timed.window.average.window.length should be greater than 0 if hive.llap.daemon.metrics.average.timed.window.data.points is set fo greater than 0");
        Preconditions.checkArgument((simpleAverageWindowDataSize >= 0 ? 1 : 0) != 0, (Object)"hive.llap.daemon.metrics.simple.average.data.points should be greater or equal to 0");
        if (ioEnabled) {
            int numThreads = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
            Preconditions.checkArgument((numThreads >= numExecutors ? 1 : 0) != 0, (String)"hive.llap.io.threadpool.size (%s) should be greater or equal to hive.llap.daemon.num.executors (%s)", (int)numThreads, (int)numExecutors);
        }
        String logMsg = "Attempting to start LlapDaemon with the following configuration: maxJvmMemory=" + this.maxJvmMemory + " (" + LlapUtil.humanReadableByteCount((long)this.maxJvmMemory) + "), requestedExecutorMemory=" + executorMemoryBytes + " (" + LlapUtil.humanReadableByteCount((long)executorMemoryBytes) + "), llapIoCacheSize=" + ioMemoryBytes + " (" + LlapUtil.humanReadableByteCount((long)ioMemoryBytes) + "), xmxHeadRoomMemory=" + xmxHeadRoomBytes + " (" + LlapUtil.humanReadableByteCount((long)xmxHeadRoomBytes) + "), adjustedExecutorMemory=" + this.executorMemoryPerInstance + " (" + LlapUtil.humanReadableByteCount((long)this.executorMemoryPerInstance) + "), numExecutors=" + numExecutors + ", llapIoEnabled=" + ioEnabled + ", llapIoCacheIsDirect=" + isDirectCache + ", rpcListenerPort=" + srvPort + ", externalClientCloudSetupEnabled=" + externalClientCloudSetupEnabled + ", rpcListenerPortForExternalClients=" + externalClientsRpcPort + ", mngListenerPort=" + mngPort + ", webPort=" + webPort + ", outputFormatSvcPort=" + outputFormatServicePort + ", workDirs=" + Arrays.toString(localDirs) + ", shufflePort=" + shufflePort + ", waitQueueSize= " + waitQueueSize + ", enablePreemption= " + enablePreemption + ", timedWindowAverageDataPoints= " + timedWindowAverageDataPoints + ", timedWindowAverageWindowLength= " + timedWindowAverageWindowLength + ", simpleAverageWindowDataSize= " + simpleAverageWindowDataSize + ", versionInfo= (" + HiveVersionInfo.getBuildVersion() + ")";
        LOG.info(logMsg);
        String currTSISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        System.err.println(currTSISO8601 + " " + logMsg);
        long memRequired = executorMemoryBytes + (ioEnabled && !isDirectCache ? ioMemoryBytes : 0L);
        Preconditions.checkState((this.maxJvmMemory >= memRequired ? 1 : 0) != 0, (Object)("Invalid configuration. Xmx value too small. maxAvailable=" + LlapUtil.humanReadableByteCount((long)this.maxJvmMemory) + ", configured(exec + io if enabled)=" + LlapUtil.humanReadableByteCount((long)memRequired)));
        this.shuffleHandlerConf = new Configuration(daemonConf);
        this.shuffleHandlerConf.setInt("llap.shuffle.port", shufflePort);
        this.shuffleHandlerConf.set("llap.shuffle.handler.local-dirs", StringUtils.arrayToString((String[])localDirs));
        this.shuffleHandlerConf.setBoolean("llap.shuffle.dir-watcher.enabled", HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SHUFFLE_DIR_WATCHER_ENABLED));
        int numHandlers = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_NUM_HANDLERS);
        ClassLoader executorClassLoader = null;
        if (HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_DOWNLOAD_PERMANENT_FNS)) {
            this.fnLocalizer = new FunctionLocalizer(daemonConf, localDirs[0]);
            executorClassLoader = this.fnLocalizer.getClassLoader();
            SerializationUtilities.setGlobalHook((SerializationUtilities.Hook)new LlapGlobalUdfChecker(this.fnLocalizer));
        } else {
            this.fnLocalizer = null;
            SerializationUtilities.setGlobalHook((SerializationUtilities.Hook)new LlapGlobalUdfChecker(new StaticPermanentFunctionChecker(daemonConf)));
            executorClassLoader = Thread.currentThread().getContextClassLoader();
        }
        LlapMetricsSystem.initialize((String)"LlapDaemon");
        this.pauseMonitor = new JvmPauseMonitor(daemonConf);
        this.pauseMonitor.start();
        String displayNameJvm = "LlapDaemonJvmMetrics-" + hostName;
        String sessionId = MetricsUtils.getUUID();
        LlapDaemonJvmMetrics.create(displayNameJvm, sessionId, daemonConf);
        String displayName = "LlapDaemonExecutorMetrics-" + hostName;
        daemonConf.set("llap.daemon.metrics.sessionid", sessionId);
        Object[] strIntervals = HiveConf.getTrimmedStringsVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_TASK_PREEMPTION_METRICS_INTERVALS);
        ArrayList<Integer> intervalList = new ArrayList<Integer>();
        if (strIntervals != null) {
            for (String string : strIntervals) {
                try {
                    intervalList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Ignoring task pre-emption metrics interval {} from {} as it is invalid", (Object)string, (Object)Arrays.toString(strIntervals));
                }
            }
        }
        this.metrics = LlapDaemonExecutorMetrics.create(displayName, sessionId, numExecutors, waitQueueSize, Ints.toArray(intervalList), timedWindowAverageDataPoints, timedWindowAverageWindowLength, simpleAverageWindowDataSize);
        this.metrics.setMemoryPerInstance(this.executorMemoryPerInstance);
        this.metrics.setCacheMemoryPerInstance(ioMemoryBytes);
        this.metrics.setJvmMaxMemory(this.maxJvmMemory);
        this.metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        this.llapDaemonInfoBean = MBeans.register((String)"LlapDaemon", (String)"LlapDaemonInfo", (Object)this);
        LOG.info("Started LlapMetricsSystem with displayName: " + displayName + " sessionId: " + sessionId);
        int maxAmReporterThreads = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_AM_REPORTER_MAX_THREADS);
        this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)daemonConf);
        this.amReporter = new AMReporter(numExecutors, maxAmReporterThreads, this.srvAddress, new QueryFailedHandlerProxy(), daemonConf, this.daemonId, this.socketFactory);
        SecretManager sm = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            sm = SecretManager.createSecretManager((Configuration)daemonConf, (String)this.daemonId.getClusterString());
            this.llapTokenManager = new DefaultLlapTokenManager(daemonConf, sm);
        } else {
            this.llapTokenManager = new DummyTokenManager();
        }
        this.secretManager = sm;
        this.server = new LlapProtocolServerImpl(this.secretManager, numHandlers, this, this.srvAddress, this.mngAddress, srvPort, externalClientsRpcPort, mngPort, this.daemonId, this.metrics).withTokenManager(this.llapTokenManager);
        LlapUgiManager llapUgiManager = LlapUgiManager.getInstance(daemonConf);
        QueryTracker queryTracker = new QueryTracker(daemonConf, localDirs, this.daemonId.getClusterString());
        String waitQueueSchedulerClassName = HiveConf.getVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WAIT_QUEUE_COMPARATOR_CLASS_NAME);
        TaskExecutorService executorService = new TaskExecutorService(numExecutors, waitQueueSize, waitQueueSchedulerClassName, enablePreemption, executorClassLoader, this.metrics, null);
        this.addIfService((Object)queryTracker);
        this.addIfService(executorService);
        this.containerRunner = new ContainerRunnerImpl(daemonConf, numExecutors, this.shufflePort, this.srvAddress, this.executorMemoryPerInstance, this.metrics, this.amReporter, queryTracker, executorService, this.daemonId, llapUgiManager, this.socketFactory);
        this.addIfService(this.containerRunner);
        this.registry = new LlapRegistryService(true);
        if (HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST) && Integer.parseInt(HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT.getDefaultValue()) == webPort) {
            LOG.info("Web UI was disabled in test mode because hive.llap.daemon.web.port was not specified or has default value ({})", (Object)webPort);
            this.webServices = null;
        } else {
            this.webServices = new LlapWebServices(webPort, this, this.registry);
            this.addIfService((Object)this.webServices);
        }
        if (HiveConf.getVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_HOSTNAMES).isEmpty()) {
            this.llapLoadGeneratorService = null;
        } else {
            this.llapLoadGeneratorService = new LlapLoadGeneratorService();
            this.addIfService((Object)this.llapLoadGeneratorService);
        }
        this.addIfService((Object)this.server);
        this.addIfService((Object)this.amReporter);
        this.addIfService((Object)new LocalDirCleaner(localDirs, daemonConf));
    }

    private static long determineXmxHeadroom(Configuration daemonConf, long executorMemoryBytes, long maxJvmMemory) {
        String headroomStr = HiveConf.getVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_XMX_HEADROOM).trim();
        long xmxHeadRoomBytes = Long.MAX_VALUE;
        try {
            if (headroomStr.endsWith("%")) {
                long percentage = Integer.parseInt(headroomStr.substring(0, headroomStr.length() - 1));
                Preconditions.checkState((percentage >= 0L && percentage < 100L ? 1 : 0) != 0, (Object)("Headroom percentage should be in [0, 100) range; found " + headroomStr));
                xmxHeadRoomBytes = maxJvmMemory * percentage / 100L;
            } else {
                xmxHeadRoomBytes = HiveConf.toSizeBytes((String)headroomStr);
            }
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Invalid headroom configuration " + headroomStr);
        }
        Preconditions.checkArgument((xmxHeadRoomBytes < executorMemoryBytes ? 1 : 0) != 0, (Object)("LLAP daemon headroom size should be less than daemon max memory size. headRoomBytes: " + xmxHeadRoomBytes + " executorMemoryBytes: " + executorMemoryBytes + " (derived from " + headroomStr + " out of xmx of " + maxJvmMemory + ")"));
        return xmxHeadRoomBytes;
    }

    private static void initializeLogging(Configuration conf) {
        URL llap_l4j2;
        long start = System.currentTimeMillis();
        String log4j2FileName = System.getenv("LLAP_LOG4J2_PROPERTIES_FILE_NAME");
        if (log4j2FileName == null || log4j2FileName.isEmpty()) {
            log4j2FileName = "llap-daemon-log4j2.properties";
        }
        if ((llap_l4j2 = LlapDaemon.class.getClassLoader().getResource(log4j2FileName)) == null) {
            throw new RuntimeException("Log initialization failed. Unable to locate llap-daemon-log4j2.properties file in classpath");
        }
        boolean async = LogUtils.checkAndSetAsyncLogging((Configuration)conf);
        System.setProperty("isThreadContextMapInheritable", "true");
        Configurator.initialize((String)"LlapDaemonLog4j2", (String)llap_l4j2.toString());
        long end = System.currentTimeMillis();
        LOG.debug("LLAP daemon logging initialized from {} in {} ms. Async: {}", new Object[]{llap_l4j2, end - start, async});
    }

    public static long getTotalHeapSize() {
        long total = 0L;
        for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
            long sz = mp.getUsage().getMax();
            if (mp.getName().contains("Survivor")) {
                sz *= 2L;
            }
            if (!mp.getType().equals((Object)MemoryType.HEAP)) continue;
            total += sz;
        }
        total += total % 0x100000L;
        return total;
    }

    private void printAsciiArt() {
        String asciiArt = "$$\\       $$\\        $$$$$$\\  $$$$$$$\\\n$$ |      $$ |      $$  __$$\\ $$  __$$\\\n$$ |      $$ |      $$ /  $$ |$$ |  $$ |\n$$ |      $$ |      $$$$$$$$ |$$$$$$$  |\n$$ |      $$ |      $$  __$$ |$$  ____/\n$$ |      $$ |      $$ |  $$ |$$ |\n$$$$$$$$\\ $$$$$$$$\\ $$ |  $$ |$$ |\n\\________|\\________|\\__|  \\__|\\__|\n\n";
        LOG.info("\n\n$$\\       $$\\        $$$$$$\\  $$$$$$$\\\n$$ |      $$ |      $$  __$$\\ $$  __$$\\\n$$ |      $$ |      $$ /  $$ |$$ |  $$ |\n$$ |      $$ |      $$$$$$$$ |$$$$$$$  |\n$$ |      $$ |      $$  __$$ |$$  ____/\n$$ |      $$ |      $$ |  $$ |$$ |\n$$$$$$$$\\ $$$$$$$$\\ $$ |  $$ |$$ |\n\\________|\\________|\\__|  \\__|\\__|\n\n");
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        LlapProxy.setDaemon((boolean)true);
        if (this.fnLocalizer != null) {
            this.fnLocalizer.init();
            this.fnLocalizer.startLocalizeAllFunctions();
        }
        if (this.isIoEnabled()) {
            LlapProxy.initializeLlapIo((Configuration)conf);
        }
    }

    public void serviceStart() throws Exception {
        ShuffleHandler.initializeAndStart(this.shuffleHandlerConf);
        LOG.info("Setting shuffle port to: " + ShuffleHandler.get().getPort());
        this.shufflePort.set(ShuffleHandler.get().getPort());
        this.getConfig().setInt(HiveConf.ConfVars.LLAP_DAEMON_YARN_SHUFFLE_PORT.varname, ShuffleHandler.get().getPort());
        LlapOutputFormatService.initializeAndStart((Configuration)this.getConfig(), (SecretManager)this.secretManager);
        super.serviceStart();
        this.getConfig().setInt(HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT.varname, this.server.getBindAddress().getPort());
        this.getConfig().setInt(HiveConf.ConfVars.LLAP_MANAGEMENT_RPC_PORT.varname, this.server.getManagementBindAddress().getPort());
        if (this.webServices != null) {
            this.getConfig().setInt(HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT.varname, this.webServices.getPort());
        }
        this.getConfig().setInt(HiveConf.ConfVars.LLAP_DAEMON_OUTPUT_SERVICE_PORT.varname, LlapOutputFormatService.get().getPort());
        if (LlapUtil.isCloudDeployment((Configuration)this.getConfig())) {
            new LlapExtClientJwtHelper(this.getConfig());
            this.getConfig().setInt(HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_RPC_PORT.varname, this.server.getExternalClientsRpcServerBindAddress().getPort());
        }
        this.getConfig().setIfUnset(HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_WAIT_QUEUE_SIZE.varname, HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_WAIT_QUEUE_SIZE.getDefaultValue());
        this.registry.init(this.getConfig());
        this.registry.start();
        LOG.info("LlapDaemon serviceStart complete. RPC Port={}, ManagementPort={}, ShuflePort={}, WebPort={}", new Object[]{this.server.getBindAddress().getPort(), this.server.getManagementBindAddress().getPort(), ShuffleHandler.get().getPort(), this.webServices == null ? "" : Integer.valueOf(this.webServices.getPort())});
        long otelExporterFrequency = HiveConf.getTimeVar((Configuration)this.getConfig(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OTEL_METRICS_FREQUENCY_SECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
        if (otelExporterFrequency > 0L) {
            this.otelExporter = new LLAPOTELExporter(OTELUtils.getOpenTelemetry((Configuration)this.getConfig()), otelExporterFrequency, this.server.getBindAddress().toString());
            this.otelExporter.setName("LLAP OTEL Exporter");
            this.otelExporter.setDaemon(true);
            this.otelExporter.start();
            LOG.info("Started OTEL exporter with frequency {}", (Object)otelExporterFrequency);
        }
    }

    public void serviceStop() throws Exception {
        if (this.registry != null) {
            this.registry.stop();
        }
        super.serviceStop();
        ShuffleHandler.shutdown();
        this.shutdown();
        LlapOutputFormatService.get().stop();
        LOG.info("LlapDaemon shutdown complete");
    }

    public void shutdown() {
        LOG.info("LlapDaemon shutdown invoked");
        this.llapTokenManager.close();
        if (this.llapDaemonInfoBean != null) {
            try {
                MBeans.unregister((ObjectName)this.llapDaemonInfoBean);
            }
            catch (Throwable ex) {
                LOG.info("Error unregistering the bean; ignoring", ex);
            }
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        if (this.metrics != null) {
            LlapMetricsSystem.shutdown();
        }
        LlapProxy.close();
        if (this.fnLocalizer != null) {
            this.fnLocalizer.close();
        }
        if (this.otelExporter != null) {
            this.otelExporter.interrupt();
        }
    }

    public static void main(String[] args) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new LlapDaemonUncaughtExceptionHandler());
        LlapDaemon llapDaemon = null;
        try {
            LlapDaemonConfiguration daemonConf = new LlapDaemonConfiguration();
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String appName = null;
            if (containerIdStr != null && !containerIdStr.isEmpty()) {
                daemonConf.set(HiveConf.ConfVars.LLAP_DAEMON_CONTAINER_ID.varname, containerIdStr);
                appName = ConverterUtils.toContainerId((String)containerIdStr).getApplicationAttemptId().getApplicationId().toString();
            } else {
                daemonConf.unset(HiveConf.ConfVars.LLAP_DAEMON_CONTAINER_ID.varname);
                LOG.error("Cannot find " + ApplicationConstants.Environment.CONTAINER_ID.toString() + "; LLAP tokens may grant access to subsequent instances of the cluster with the same name");
                appName = null;
            }
            String nmHost = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nmPort = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nmHost) && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nmPort)) {
                String nmAddress = nmHost + ":" + nmPort;
                daemonConf.set(HiveConf.ConfVars.LLAP_DAEMON_NM_ADDRESS.varname, nmAddress);
            } else {
                daemonConf.unset(HiveConf.ConfVars.LLAP_DAEMON_NM_ADDRESS.varname);
                LOG.warn("NodeManager host/port not found in environment. Values retrieved: host={}, port={}", (Object)nmHost, (Object)nmPort);
            }
            String workDirsString = System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name());
            String localDirList = LlapUtil.getDaemonLocalDirString((Configuration)daemonConf, (String)workDirsString);
            String[] localDirs = localDirList == null || localDirList.isEmpty() ? new String[]{} : StringUtils.getTrimmedStrings((String)localDirList);
            int rpcPort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT);
            int externalClientCloudRpcPort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_RPC_PORT);
            boolean externalClientCloudSetupEnabled = LlapUtil.isCloudDeployment((Configuration)daemonConf);
            int mngPort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_MANAGEMENT_RPC_PORT);
            int shufflePort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_YARN_SHUFFLE_PORT);
            int webPort = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT);
            LlapDaemonInfo.initialize((String)appName, (Configuration)daemonConf);
            int numExecutors = LlapDaemonInfo.INSTANCE.getNumExecutors();
            long executorMemoryBytes = LlapDaemonInfo.INSTANCE.getExecutorMemory();
            long ioMemoryBytes = LlapDaemonInfo.INSTANCE.getCacheSize();
            boolean isDirectCache = LlapDaemonInfo.INSTANCE.isDirectCache();
            boolean isLlapIo = LlapDaemonInfo.INSTANCE.isLlapIo();
            daemonConf.set("hive.cluster.id", ServiceContext.findClusterId());
            LlapDaemon.initializeLogging(daemonConf);
            llapDaemon = new LlapDaemon(daemonConf, numExecutors, executorMemoryBytes, isLlapIo, isDirectCache, ioMemoryBytes, localDirs, rpcPort, externalClientCloudSetupEnabled, externalClientCloudRpcPort, mngPort, shufflePort, webPort, appName);
            LOG.info("Adding shutdown hook for LlapDaemon");
            ShutdownHookManager.addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)llapDaemon), (int)1);
            llapDaemon.init(daemonConf);
            llapDaemon.start();
            LOG.info("Started LlapDaemon with PID: {}", (Object)LlapDaemonInfo.INSTANCE.getPID());
        }
        catch (Throwable t) {
            LOG.error("Failed to start LLAP Daemon with exception", t);
            if (llapDaemon != null) {
                llapDaemon.shutdown();
            }
            System.exit(-1);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.RegisterDagResponseProto registerDag(LlapDaemonProtocolProtos.RegisterDagRequestProto request) throws IOException {
        return this.containerRunner.registerDag(request);
    }

    @Override
    public LlapDaemonProtocolProtos.SubmitWorkResponseProto submitWork(LlapDaemonProtocolProtos.SubmitWorkRequestProto request) throws IOException {
        this.numSubmissions.incrementAndGet();
        return this.containerRunner.submitWork(request);
    }

    @Override
    public LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto sourceStateUpdated(LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request) throws IOException {
        return this.containerRunner.sourceStateUpdated(request);
    }

    @Override
    public LlapDaemonProtocolProtos.QueryCompleteResponseProto queryComplete(LlapDaemonProtocolProtos.QueryCompleteRequestProto request) throws IOException {
        return this.containerRunner.queryComplete(request);
    }

    @Override
    public LlapDaemonProtocolProtos.TerminateFragmentResponseProto terminateFragment(LlapDaemonProtocolProtos.TerminateFragmentRequestProto request) throws IOException {
        return this.containerRunner.terminateFragment(request);
    }

    @Override
    public LlapDaemonProtocolProtos.UpdateFragmentResponseProto updateFragment(LlapDaemonProtocolProtos.UpdateFragmentRequestProto request) throws IOException {
        return this.containerRunner.updateFragment(request);
    }

    @Override
    public LlapDaemonProtocolProtos.SetCapacityResponseProto setCapacity(LlapDaemonProtocolProtos.SetCapacityRequestProto request) throws IOException {
        HashMap<String, String> capacityValues = new HashMap<String, String>(2);
        capacityValues.put("hive.llap.daemon.num.enabled.executors", Integer.toString(request.getExecutorNum()));
        capacityValues.put("hive.llap.daemon.task.scheduler.enabled.wait.queue.size", Integer.toString(request.getQueueSize()));
        this.registry.updateRegistration(capacityValues.entrySet());
        return this.containerRunner.setCapacity(request);
    }

    @VisibleForTesting
    public long getNumSubmissions() {
        return this.numSubmissions.get();
    }

    public InetSocketAddress getListenerAddress() {
        return this.server.getBindAddress();
    }

    @Override
    public int getRpcPort() {
        return this.server.getBindAddress().getPort();
    }

    @Override
    public int getNumExecutors() {
        return this.numExecutors;
    }

    @Override
    public int getShufflePort() {
        return ShuffleHandler.get().getPort();
    }

    @Override
    public String getLocalDirs() {
        return Joiner.on((String)",").skipNulls().join((Object[])this.localDirs);
    }

    @Override
    public Set<String> getExecutorsStatus() {
        return this.containerRunner.getExecutorStatus();
    }

    @Override
    public int getNumActive() {
        return this.containerRunner.getNumActive();
    }

    @Override
    public long getExecutorMemoryPerInstance() {
        return this.executorMemoryPerInstance;
    }

    @Override
    public long getIoMemoryPerInstance() {
        return this.ioMemoryPerInstance;
    }

    @Override
    public boolean isIoEnabled() {
        return this.llapIoEnabled;
    }

    @Override
    public long getMaxJvmMemory() {
        return this.maxJvmMemory;
    }

    private static final class LlapGlobalUdfChecker
    extends SerializationUtilities.Hook {
        private GenericUDFBridge.UdfWhitelistChecker fnCheckerImpl;

        public LlapGlobalUdfChecker(GenericUDFBridge.UdfWhitelistChecker fnCheckerImpl) {
            this.fnCheckerImpl = fnCheckerImpl;
        }

        public boolean preRead(Class<?> type) {
            if (GenericUDFBridge.class == type) {
                return true;
            }
            if (!GenericUDF.class.isAssignableFrom(type) && !UDF.class.isAssignableFrom(type) || this.fnCheckerImpl.isUdfAllowed(type)) {
                return false;
            }
            throw new SecurityException("UDF " + type.getCanonicalName() + " is not allowed");
        }

        public Object postRead(Object o) {
            if (o == null) {
                return o;
            }
            Class<?> type = o.getClass();
            if (GenericUDFBridge.class == type) {
                ((GenericUDFBridge)o).setUdfChecker(this.fnCheckerImpl);
            }
            this.preRead(type);
            return o;
        }
    }

    private class QueryFailedHandlerProxy
    implements QueryFailedHandler {
        private QueryFailedHandlerProxy() {
        }

        @Override
        public void queryFailed(QueryIdentifier queryIdentifier) {
            LlapDaemon.this.containerRunner.queryFailed(queryIdentifier);
        }
    }

    private static class LlapDaemonUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private LlapDaemonUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.info("UncaughtExceptionHandler invoked");
            if (ShutdownHookManager.isShutdownInProgress()) {
                LOG.warn("Thread {} threw a Throwable, but we are shutting down, so ignoring this", (Object)t, (Object)e);
            } else if (e instanceof Error) {
                try {
                    LOG.error("Thread {} threw an Error.  Shutting down now...", (Object)t, (Object)e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (e instanceof OutOfMemoryError) {
                    try {
                        System.err.println("Halting due to Out Of Memory Error...");
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ExitUtil.halt((int)-1);
                } else {
                    ExitUtil.terminate((int)-1);
                }
            } else {
                LOG.error("Thread {} threw an Exception. Shutting down now...", (Object)t, (Object)e);
                ExitUtil.terminate((int)-1);
            }
        }
    }
}

