/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.io.encoded.LlapRecordReaderUtils;
import org.apache.hadoop.hive.llap.io.encoded.OrcEncodedDataReader;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedOrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.orc.encoded.LlapDataReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.OrcCodecPool;

public class LlapOrcCacheLoader
implements AutoCloseable {
    private Path path;
    private Object fileKey;
    private Configuration daemonConf;
    private DataCache cache;
    private FileMetadataCache metadataCache;
    private CacheTag cacheTag;
    private FixedSizedObjectPool<IoTrace> tracePool;
    private Supplier<FileSystem> fsSupplier;
    private Reader orcReader;
    private LlapDataReader rawDataReader;
    private EncodedReader encodedReader;

    public LlapOrcCacheLoader(Path path, Object fileKey, Configuration daemonConf, DataCache cache, FileMetadataCache metadataCache, CacheTag cacheTag, FixedSizedObjectPool<IoTrace> tracePool) {
        this.path = path;
        this.fileKey = fileKey;
        this.daemonConf = daemonConf;
        this.cache = cache;
        this.metadataCache = metadataCache;
        this.cacheTag = cacheTag;
        this.tracePool = tracePool;
    }

    public void init() throws IOException {
        this.fsSupplier = OrcEncodedDataReader.getFsSupplier(this.path, this.daemonConf);
        Object fileKey = LlapHiveUtils.createFileIdUsingFS((FileSystem)this.fsSupplier.get(), (Path)this.path, (Configuration)this.daemonConf);
        if (!fileKey.equals(this.fileKey)) {
            throw new IOException("File key mismatch.");
        }
        EncodedOrcFile.EncodedReaderOptions opts = EncodedOrcFile.readerOptions((Configuration)this.daemonConf).filesystem(this.fsSupplier);
        this.orcReader = EncodedOrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRanges(DiskRangeList ranges) throws IOException {
        boolean useZeroCopy = this.daemonConf != null && OrcConf.USE_ZEROCOPY.getBoolean(this.daemonConf);
        InStream.StreamOptions options = InStream.options().withCodec(OrcCodecPool.getCodec((CompressionKind)this.orcReader.getCompressionKind())).withBufferSize(this.orcReader.getCompressionSize());
        this.rawDataReader = LlapRecordReaderUtils.createDefaultLlapDataReader(DataReaderProperties.builder().withFileSystemSupplier(this.fsSupplier).withPath(this.path).withCompression(options).withZeroCopy(useZeroCopy).build());
        this.rawDataReader.open();
        IoTrace ioTrace = (IoTrace)this.tracePool.take();
        try {
            this.encodedReader = this.orcReader.encodedReader(this.fileKey, this.cache, this.rawDataReader, null, ioTrace, false, this.cacheTag, false);
            this.encodedReader.preReadDataRanges(ranges);
        }
        finally {
            this.tracePool.offer((Object)ioTrace);
        }
    }

    public void loadFileFooter() {
        MemoryBufferOrBuffers tailBuffers = this.metadataCache.getFileMetadata(this.fileKey);
        if (tailBuffers == null) {
            ByteBuffer tailBufferBb = this.orcReader.getSerializedFileFooter();
            this.metadataCache.putFileMetadata(this.fileKey, tailBufferBb, this.cacheTag, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.orcReader != null) {
            IOUtils.closeQuietly((Closeable)this.orcReader);
        }
        if (this.encodedReader != null) {
            this.encodedReader.close();
        }
    }
}

