/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.DropPartitionCommand;
import org.apache.hive.hcatalog.api.repl.commands.NoopCommand;
import org.apache.hive.hcatalog.messaging.DropPartitionMessage;

public class DropPartitionReplicationTask
extends ReplicationTask {
    DropPartitionMessage dropPartitionMessage = null;

    public DropPartitionReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "DROP_PARTITION");
        this.dropPartitionMessage = messageFactory.getDeserializer().getDropPartitionMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return false;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        return Collections.singletonList(new NoopCommand(this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        final String dstDbName = ReplicationUtils.mapIfMapAvailable(this.dropPartitionMessage.getDB(), (Function<String, String>)this.dbNameMapping);
        final String dstTableName = ReplicationUtils.mapIfMapAvailable(this.dropPartitionMessage.getTable(), (Function<String, String>)this.tableNameMapping);
        return Iterables.transform((Iterable)this.dropPartitionMessage.getPartitions(), (Function)new Function<Map<String, String>, Command>(){

            public Command apply(@Nullable Map<String, String> ptnDesc) {
                return new DropPartitionCommand(dstDbName, dstTableName, ptnDesc, true, DropPartitionReplicationTask.this.event.getEventId());
            }
        });
    }
}

