/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Query {
    String sql;
    Connection conn;
    Statement stmt;
    PreparedStatement pstmt;
    ResultSet rs;
    Exception exception;

    Query() {
    }

    public Query(String sql) {
        this.sql = sql;
    }

    public void set(Connection conn, Statement stmt, ResultSet rs) {
        this.conn = conn;
        this.stmt = stmt;
        this.rs = rs;
    }

    public void set(Connection conn, PreparedStatement pstmt) {
        this.conn = conn;
        this.pstmt = pstmt;
    }

    public void closeStatement() {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setError(Exception e) {
        this.exception = e;
    }

    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public PreparedStatement getPreparedStatement() {
        return this.pstmt;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public boolean error() {
        return this.exception != null;
    }

    public String errorText() {
        if (this.exception != null) {
            if (this.exception instanceof ClassNotFoundException) {
                return "ClassNotFoundException: " + this.exception.getMessage();
            }
            return this.exception.getMessage();
        }
        return "";
    }

    public Exception getException() {
        return this.exception;
    }
}

