/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hive.hcatalog.templeton.JsonBuilder;
import org.apache.hive.hcatalog.templeton.tool.HDFSStorage;
import org.apache.hive.hcatalog.templeton.tool.NotFoundException;
import org.apache.hive.hcatalog.templeton.tool.TempletonStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobState {
    private static final Logger LOG = LoggerFactory.getLogger(JobState.class);
    private String id;
    private TempletonStorage storage = null;
    private static TempletonStorage.Type type = TempletonStorage.Type.JOB;
    private Configuration config = null;

    public JobState(String id, Configuration conf) throws IOException {
        this.id = id;
        this.config = conf;
        this.storage = JobState.getStorage(conf);
    }

    public void delete() throws IOException {
        try {
            this.storage.delete(type, this.id);
        }
        catch (Exception e) {
            LOG.info("Couldn't delete " + this.id);
        }
    }

    public static TempletonStorage getStorageInstance(Configuration conf) {
        TempletonStorage storage = null;
        try {
            storage = (TempletonStorage)JavaUtils.loadClass((String)conf.get("templeton.storage.class")).newInstance();
        }
        catch (Exception e) {
            LOG.warn("No storage method found: " + e.getMessage());
            try {
                storage = new HDFSStorage();
            }
            catch (Exception ex) {
                LOG.error("Couldn't create storage.");
            }
        }
        return storage;
    }

    public static TempletonStorage getStorage(Configuration conf) throws IOException {
        TempletonStorage storage = JobState.getStorageInstance(conf);
        storage.openStorage(conf);
        return storage;
    }

    public void close() throws IOException {
        this.storage.closeStorage();
    }

    public String getId() {
        return this.id;
    }

    public String getPercentComplete() throws IOException {
        return this.getField("percentComplete");
    }

    public void setPercentComplete(String percent) throws IOException {
        this.setField("percentComplete", percent);
    }

    public String getJobType() throws IOException {
        return this.getField("jobType");
    }

    public void setJobType(String jobType) throws IOException {
        this.setField("jobType", jobType);
    }

    public void addChild(String jobid) throws IOException {
        Object jobids = "";
        try {
            jobids = this.getField("children");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jobids == null) {
            jobids = "";
        }
        if (!((String)jobids).equals("")) {
            jobids = (String)jobids + ",";
        }
        jobids = (String)jobids + jobid;
        this.setField("children", (String)jobids);
    }

    public void setParent(String id) throws IOException {
        this.setField("parent", id);
    }

    public String getParent() throws IOException {
        return this.getField("parent");
    }

    public List<JobState> getChildren() throws IOException {
        ArrayList<JobState> children = new ArrayList<JobState>();
        String childJobIDs = this.getField("children");
        if (childJobIDs != null) {
            for (String jobid : childJobIDs.split(",")) {
                children.add(new JobState(jobid, this.config));
            }
        }
        return children;
    }

    public Long getExitValue() throws IOException {
        return this.getLongField("exitValue");
    }

    public void setExitValue(long exitValue) throws IOException {
        this.setLongField("exitValue", exitValue);
    }

    public Long getCreated() throws IOException {
        return this.getLongField("created");
    }

    public void setCreated(long created) throws IOException {
        this.setLongField("created", created);
    }

    public String getUser() throws IOException {
        return this.getField("user");
    }

    public void setUser(String user) throws IOException {
        this.setField("user", user);
    }

    public Map<String, Object> getUserArgs() throws IOException {
        String jsonString = this.getField("userArgs");
        return JsonBuilder.jsonToMap(jsonString);
    }

    public void setUserArgs(Map<String, Object> userArgs) throws IOException {
        String jsonString = JsonBuilder.mapToJson(userArgs);
        this.setField("userArgs", jsonString);
    }

    public String getCallback() throws IOException {
        return this.getField("callback");
    }

    public void setCallback(String callback) throws IOException {
        this.setField("callback", callback);
    }

    public String getCompleteStatus() throws IOException {
        return this.getField("completed");
    }

    public void setCompleteStatus(String complete) throws IOException {
        this.setField("completed", complete);
    }

    public Long getNotifiedTime() throws IOException {
        return this.getLongField("notified");
    }

    public void setNotifiedTime(long notified) throws IOException {
        this.setLongField("notified", notified);
    }

    public Long getLongField(String name) throws IOException {
        String s = this.storage.getField(type, this.id, name);
        if (s == null) {
            return null;
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            LOG.error("templeton: bug " + name + " " + s + " : " + e);
            return null;
        }
    }

    public void setField(String name, String val) throws IOException {
        try {
            this.storage.saveField(type, this.id, name, val);
        }
        catch (NotFoundException ne) {
            throw new IOException(ne.getMessage());
        }
    }

    public String getField(String name) throws IOException {
        return this.storage.getField(type, this.id, name);
    }

    public void setLongField(String name, long val) throws IOException {
        try {
            this.storage.saveField(type, this.id, name, String.valueOf(val));
        }
        catch (NotFoundException ne) {
            throw new IOException("Job " + this.id + " was not found: " + ne.getMessage());
        }
    }

    public static List<String> getJobs(Configuration conf) throws IOException {
        try {
            return JobState.getStorage(conf).getAllForType(type);
        }
        catch (Exception e) {
            throw new IOException("Can't get jobs", e);
        }
    }
}

