/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetCDF", value="_FUNC_(sketch, [inclusive,] split points...)", extended="Returns an approximation to the Cumulative Distribution Function (CDF) from a sketch given a set of split points (values). The optional boolean parameter 'inclusive' (default: true) determines whether the rank of an item includes its own weight. If true, such items are included in the interval to the left of the split point; otherwise they are included in the interval to the right of the split point. Split points are an array of M unique, monotonically increasing values that divide the domain into M+1 consecutive disjoint intervals. The function returns an array of M+1 double valuess, the first M of which are approximations to the ranks of the corresponding split points (fraction of input stream values that are less than a split point). The last value is always 1. CDF can also be viewed as a cumulative version of PMF.")
public class GetCdfFromStringsSketchUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch, String ... splitPoints) {
        return this.evaluate(serializedSketch, true, splitPoints);
    }

    public List<Double> evaluate(BytesWritable serializedSketch, Boolean inclusive, String ... splitPoints) {
        if (serializedSketch == null) {
            return null;
        }
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, (Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        if (sketch.isEmpty()) {
            return null;
        }
        double[] cdf = sketch.getCDF((Object[])splitPoints, inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
        if (cdf == null) {
            return null;
        }
        return Util.primitivesToList(cdf);
    }
}

