/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.MemberIdRequiredException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public abstract class AbstractCoordinator
implements Closeable {
    public static final String HEARTBEAT_THREAD_PREFIX = "kafka-coordinator-heartbeat-thread";
    private final Logger log;
    private final GroupCoordinatorMetrics sensors;
    private final Heartbeat heartbeat;
    private final GroupRebalanceConfig rebalanceConfig;
    protected final ConsumerNetworkClient client;
    protected final Time time;
    private Node coordinator = null;
    private boolean rejoinNeeded = true;
    private boolean needsJoinPrepare = true;
    private MemberState state = MemberState.UNJOINED;
    private HeartbeatThread heartbeatThread = null;
    private RequestFuture<ByteBuffer> joinFuture = null;
    private RequestFuture<Void> findCoordinatorFuture = null;
    private volatile RuntimeException findCoordinatorException = null;
    private Generation generation = Generation.NO_GENERATION;
    private long lastRebalanceStartMs = -1L;
    private long lastRebalanceEndMs = -1L;

    public AbstractCoordinator(GroupRebalanceConfig rebalanceConfig, LogContext logContext, ConsumerNetworkClient client, Metrics metrics, String metricGrpPrefix, Time time) {
        Objects.requireNonNull(rebalanceConfig.groupId, "Expected a non-null group id for coordinator construction");
        this.rebalanceConfig = rebalanceConfig;
        this.log = logContext.logger(AbstractCoordinator.class);
        this.client = client;
        this.time = time;
        this.heartbeat = new Heartbeat(rebalanceConfig, time);
        this.sensors = new GroupCoordinatorMetrics(metrics, metricGrpPrefix);
    }

    protected abstract String protocolType();

    protected abstract JoinGroupRequestData.JoinGroupRequestProtocolCollection metadata();

    protected abstract void onJoinPrepare(int var1, String var2);

    protected abstract Map<String, ByteBuffer> performAssignment(String var1, String var2, List<JoinGroupResponseData.JoinGroupResponseMember> var3);

    protected abstract void onJoinComplete(int var1, String var2, String var3, ByteBuffer var4);

    protected void onLeavePrepare() {
    }

    protected synchronized boolean ensureCoordinatorReady(Timer timer) {
        if (!this.coordinatorUnknown()) {
            return true;
        }
        do {
            if (this.findCoordinatorException != null && !(this.findCoordinatorException instanceof RetriableException)) {
                RuntimeException fatalException = this.findCoordinatorException;
                this.findCoordinatorException = null;
                throw fatalException;
            }
            RequestFuture<Void> future = this.lookupCoordinator();
            this.client.poll(future, timer);
            if (!future.isDone()) break;
            if (future.failed()) {
                if (future.isRetriable()) {
                    this.log.debug("Coordinator discovery failed, refreshing metadata");
                    this.client.awaitMetadataUpdate(timer);
                    continue;
                }
                throw future.exception();
            }
            if (this.coordinator == null || !this.client.isUnavailable(this.coordinator)) continue;
            this.markCoordinatorUnknown();
            timer.sleep(this.rebalanceConfig.retryBackoffMs);
        } while (this.coordinatorUnknown() && timer.notExpired());
        return !this.coordinatorUnknown();
    }

    protected synchronized RequestFuture<Void> lookupCoordinator() {
        if (this.findCoordinatorFuture == null) {
            Node node = this.client.leastLoadedNode();
            if (node == null) {
                this.log.debug("No broker available to send FindCoordinator request");
                return RequestFuture.noBrokersAvailable();
            }
            this.findCoordinatorFuture = this.sendFindCoordinatorRequest(node);
            this.findCoordinatorFuture.addListener(new RequestFutureListener<Void>(){

                @Override
                public void onSuccess(Void value) {
                }

                @Override
                public void onFailure(RuntimeException e) {
                    AbstractCoordinator.this.findCoordinatorException = e;
                }
            });
        }
        return this.findCoordinatorFuture;
    }

    private synchronized void clearFindCoordinatorFuture() {
        this.findCoordinatorFuture = null;
    }

    protected synchronized boolean rejoinNeededOrPending() {
        return this.rejoinNeeded || this.joinFuture != null;
    }

    protected synchronized void pollHeartbeat(long now) {
        if (this.heartbeatThread != null) {
            if (this.heartbeatThread.hasFailed()) {
                RuntimeException cause = this.heartbeatThread.failureCause();
                this.heartbeatThread = null;
                throw cause;
            }
            if (this.heartbeat.shouldHeartbeat(now)) {
                this.notify();
            }
            this.heartbeat.poll(now);
        }
    }

    protected synchronized long timeToNextHeartbeat(long now) {
        if (this.state == MemberState.UNJOINED) {
            return Long.MAX_VALUE;
        }
        return this.heartbeat.timeToNextHeartbeat(now);
    }

    public void ensureActiveGroup() {
        while (!this.ensureActiveGroup(this.time.timer(Long.MAX_VALUE))) {
            this.log.warn("still waiting to ensure active group");
        }
    }

    boolean ensureActiveGroup(Timer timer) {
        if (!this.ensureCoordinatorReady(timer)) {
            return false;
        }
        this.startHeartbeatThreadIfNeeded();
        return this.joinGroupIfNeeded(timer);
    }

    private synchronized void startHeartbeatThreadIfNeeded() {
        if (this.heartbeatThread == null) {
            this.heartbeatThread = new HeartbeatThread();
            this.heartbeatThread.start();
        }
    }

    private synchronized void disableHeartbeatThread() {
        if (this.heartbeatThread != null) {
            this.heartbeatThread.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHeartbeatThread() {
        HeartbeatThread thread = null;
        AbstractCoordinator abstractCoordinator = this;
        synchronized (abstractCoordinator) {
            if (this.heartbeatThread == null) {
                return;
            }
            this.heartbeatThread.close();
            thread = this.heartbeatThread;
            this.heartbeatThread = null;
        }
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for consumer heartbeat thread to close");
            throw new InterruptException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean joinGroupIfNeeded(Timer timer) {
        while (this.rejoinNeededOrPending()) {
            if (!this.ensureCoordinatorReady(timer)) {
                return false;
            }
            if (this.needsJoinPrepare) {
                this.needsJoinPrepare = false;
                this.onJoinPrepare(this.generation.generationId, this.generation.memberId);
            }
            RequestFuture<ByteBuffer> future = this.initiateJoinGroup();
            this.client.poll(future, timer);
            if (!future.isDone()) {
                return false;
            }
            if (future.succeeded()) {
                Generation generationSnapshot;
                AbstractCoordinator abstractCoordinator = this;
                synchronized (abstractCoordinator) {
                    generationSnapshot = this.generation;
                }
                if (generationSnapshot != Generation.NO_GENERATION) {
                    ByteBuffer memberAssignment = future.value().duplicate();
                    this.onJoinComplete(generationSnapshot.generationId, generationSnapshot.memberId, generationSnapshot.protocolName, memberAssignment);
                    this.resetJoinGroupFuture();
                    this.needsJoinPrepare = true;
                    continue;
                }
                this.log.info("Generation data was cleared by heartbeat thread. Initiating rejoin.");
                this.resetStateAndRejoin();
                this.resetJoinGroupFuture();
                return false;
            }
            RuntimeException exception = future.exception();
            this.log.info("Join group failed with {}", (Object)exception.toString());
            this.resetJoinGroupFuture();
            if (exception instanceof UnknownMemberIdException || exception instanceof RebalanceInProgressException || exception instanceof IllegalGenerationException || exception instanceof MemberIdRequiredException) continue;
            if (!future.isRetriable()) {
                throw exception;
            }
            timer.sleep(this.rebalanceConfig.retryBackoffMs);
        }
        return true;
    }

    private synchronized void resetJoinGroupFuture() {
        this.joinFuture = null;
    }

    private synchronized void resetStateAndRejoin() {
        this.rejoinNeeded = true;
        this.state = MemberState.UNJOINED;
    }

    private synchronized RequestFuture<ByteBuffer> initiateJoinGroup() {
        if (this.joinFuture == null) {
            this.disableHeartbeatThread();
            this.state = MemberState.REBALANCING;
            if (this.lastRebalanceStartMs == -1L) {
                this.lastRebalanceStartMs = this.time.milliseconds();
            }
            this.joinFuture = this.sendJoinGroupRequest();
            this.joinFuture.addListener(new RequestFutureListener<ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(ByteBuffer value) {
                    AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                    synchronized (abstractCoordinator) {
                        if (AbstractCoordinator.this.generation != Generation.NO_GENERATION) {
                            AbstractCoordinator.this.log.info("Successfully joined group with generation {}", (Object)((AbstractCoordinator)AbstractCoordinator.this).generation.generationId);
                            AbstractCoordinator.this.state = MemberState.STABLE;
                            AbstractCoordinator.this.rejoinNeeded = false;
                            AbstractCoordinator.this.lastRebalanceEndMs = AbstractCoordinator.this.time.milliseconds();
                            ((AbstractCoordinator)AbstractCoordinator.this).sensors.successfulRebalanceSensor.record(AbstractCoordinator.this.lastRebalanceEndMs - AbstractCoordinator.this.lastRebalanceStartMs);
                            AbstractCoordinator.this.lastRebalanceStartMs = -1L;
                            if (AbstractCoordinator.this.heartbeatThread != null) {
                                AbstractCoordinator.this.heartbeatThread.enable();
                            }
                        } else {
                            AbstractCoordinator.this.log.info("Generation data was cleared by heartbeat thread. Rejoin failed.");
                            this.recordRebalanceFailure();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(RuntimeException e) {
                    AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                    synchronized (abstractCoordinator) {
                        this.recordRebalanceFailure();
                    }
                }

                private void recordRebalanceFailure() {
                    AbstractCoordinator.this.state = MemberState.UNJOINED;
                    ((AbstractCoordinator)AbstractCoordinator.this).sensors.failedRebalanceSensor.record();
                }
            });
        }
        return this.joinFuture;
    }

    RequestFuture<ByteBuffer> sendJoinGroupRequest() {
        if (this.coordinatorUnknown()) {
            return RequestFuture.coordinatorNotAvailable();
        }
        this.log.info("(Re-)joining group");
        JoinGroupRequest.Builder requestBuilder = new JoinGroupRequest.Builder(new JoinGroupRequestData().setGroupId(this.rebalanceConfig.groupId).setSessionTimeoutMs(this.rebalanceConfig.sessionTimeoutMs).setMemberId(this.generation.memberId).setGroupInstanceId(this.rebalanceConfig.groupInstanceId.orElse(null)).setProtocolType(this.protocolType()).setProtocols(this.metadata()).setRebalanceTimeoutMs(this.rebalanceConfig.rebalanceTimeoutMs));
        this.log.debug("Sending JoinGroup ({}) to coordinator {}", (Object)requestBuilder, (Object)this.coordinator);
        int joinGroupTimeoutMs = Math.max(this.rebalanceConfig.rebalanceTimeoutMs, this.rebalanceConfig.rebalanceTimeoutMs + 5000);
        return this.client.send(this.coordinator, requestBuilder, joinGroupTimeoutMs).compose(new JoinGroupResponseHandler());
    }

    private RequestFuture<ByteBuffer> onJoinFollower() {
        SyncGroupRequest.Builder requestBuilder = new SyncGroupRequest.Builder(new SyncGroupRequestData().setGroupId(this.rebalanceConfig.groupId).setMemberId(this.generation.memberId).setProtocolType(this.protocolType()).setProtocolName(this.generation.protocolName).setGroupInstanceId(this.rebalanceConfig.groupInstanceId.orElse(null)).setGenerationId(this.generation.generationId).setAssignments(Collections.emptyList()));
        this.log.debug("Sending follower SyncGroup to coordinator {} at generation {}: {}", new Object[]{this.coordinator, this.generation, requestBuilder});
        return this.sendSyncGroupRequest(requestBuilder);
    }

    private RequestFuture<ByteBuffer> onJoinLeader(JoinGroupResponse joinResponse) {
        try {
            Map<String, ByteBuffer> groupAssignment = this.performAssignment(joinResponse.data().leader(), joinResponse.data().protocolName(), joinResponse.data().members());
            ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> groupAssignmentList = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
            for (Map.Entry<String, ByteBuffer> assignment : groupAssignment.entrySet()) {
                groupAssignmentList.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(assignment.getKey()).setAssignment(Utils.toArray(assignment.getValue())));
            }
            SyncGroupRequest.Builder requestBuilder = new SyncGroupRequest.Builder(new SyncGroupRequestData().setGroupId(this.rebalanceConfig.groupId).setMemberId(this.generation.memberId).setProtocolType(this.protocolType()).setProtocolName(this.generation.protocolName).setGroupInstanceId(this.rebalanceConfig.groupInstanceId.orElse(null)).setGenerationId(this.generation.generationId).setAssignments(groupAssignmentList));
            this.log.debug("Sending leader SyncGroup to coordinator {} at generation {}: {}", new Object[]{this.coordinator, this.generation, requestBuilder});
            return this.sendSyncGroupRequest(requestBuilder);
        }
        catch (RuntimeException e) {
            return RequestFuture.failure(e);
        }
    }

    private RequestFuture<ByteBuffer> sendSyncGroupRequest(SyncGroupRequest.Builder requestBuilder) {
        if (this.coordinatorUnknown()) {
            return RequestFuture.coordinatorNotAvailable();
        }
        return this.client.send(this.coordinator, requestBuilder).compose(new SyncGroupResponseHandler());
    }

    private RequestFuture<Void> sendFindCoordinatorRequest(Node node) {
        this.log.debug("Sending FindCoordinator request to broker {}", (Object)node);
        FindCoordinatorRequest.Builder requestBuilder = new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(this.rebalanceConfig.groupId));
        return this.client.send(node, requestBuilder).compose(new FindCoordinatorResponseHandler());
    }

    public boolean coordinatorUnknown() {
        return this.checkAndGetCoordinator() == null;
    }

    protected synchronized Node checkAndGetCoordinator() {
        if (this.coordinator != null && this.client.isUnavailable(this.coordinator)) {
            this.markCoordinatorUnknown(true);
            return null;
        }
        return this.coordinator;
    }

    private synchronized Node coordinator() {
        return this.coordinator;
    }

    protected synchronized void markCoordinatorUnknown() {
        this.markCoordinatorUnknown(false);
    }

    protected synchronized void markCoordinatorUnknown(boolean isDisconnected) {
        if (this.coordinator != null) {
            this.log.info("Group coordinator {} is unavailable or invalid, will attempt rediscovery", (Object)this.coordinator);
            Node oldCoordinator = this.coordinator;
            this.coordinator = null;
            if (!isDisconnected) {
                this.client.disconnectAsync(oldCoordinator);
            }
        }
    }

    protected synchronized Generation generation() {
        return this.generation;
    }

    protected synchronized Generation generationIfStable() {
        if (this.state != MemberState.STABLE) {
            return null;
        }
        return this.generation;
    }

    protected synchronized boolean rebalanceInProgress() {
        return this.state == MemberState.REBALANCING;
    }

    protected synchronized String memberId() {
        return this.generation.memberId;
    }

    private synchronized void resetGeneration() {
        this.rejoinNeeded = true;
        this.generation = Generation.NO_GENERATION;
    }

    synchronized void resetGenerationOnResponseError(ApiKeys api, Errors error) {
        this.log.debug("Resetting generation after encountering {} from {} response and requesting re-join", (Object)error, (Object)api);
        if (this.state != MemberState.REBALANCING) {
            this.state = MemberState.UNJOINED;
        }
        this.resetGeneration();
    }

    synchronized void resetGenerationOnLeaveGroup() {
        this.log.debug("Resetting generation due to consumer pro-actively leaving the group");
        this.state = MemberState.UNJOINED;
        this.resetGeneration();
    }

    protected synchronized void requestRejoin() {
        this.rejoinNeeded = true;
    }

    private boolean isProtocolTypeInconsistent(String protocolType) {
        return protocolType != null && !protocolType.equals(this.protocolType());
    }

    private boolean isProtocolNameInconsistent(String protocolName) {
        return protocolName != null && this.generation() != Generation.NO_GENERATION && !protocolName.equals(this.generation().protocolName);
    }

    @Override
    public final void close() {
        this.close(this.time.timer(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Timer timer) {
        try {
            this.closeHeartbeatThread();
        }
        finally {
            AbstractCoordinator abstractCoordinator = this;
            synchronized (abstractCoordinator) {
                Node coordinator;
                if (this.rebalanceConfig.leaveGroupOnClose) {
                    this.onLeavePrepare();
                    this.maybeLeaveGroup("the consumer is being closed");
                }
                if ((coordinator = this.checkAndGetCoordinator()) != null && !this.client.awaitPendingRequests(coordinator, timer)) {
                    this.log.warn("Close timed out with {} pending requests to coordinator, terminating client connections", (Object)this.client.pendingRequestCount(coordinator));
                }
            }
        }
    }

    public synchronized RequestFuture<Void> maybeLeaveGroup(String leaveReason) {
        RequestFuture<Void> future = null;
        if (this.isDynamicMember() && !this.coordinatorUnknown() && this.state != MemberState.UNJOINED && this.generation.hasMemberId()) {
            this.log.info("Member {} sending LeaveGroup request to coordinator {} due to {}", new Object[]{this.generation.memberId, this.coordinator, leaveReason});
            LeaveGroupRequest.Builder request = new LeaveGroupRequest.Builder(this.rebalanceConfig.groupId, Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId(this.generation.memberId)));
            future = this.client.send(this.coordinator, request).compose(new LeaveGroupResponseHandler());
            this.client.pollNoWakeup();
        }
        this.resetGenerationOnLeaveGroup();
        return future;
    }

    protected boolean isDynamicMember() {
        return !this.rebalanceConfig.groupInstanceId.isPresent();
    }

    synchronized RequestFuture<Void> sendHeartbeatRequest() {
        this.log.debug("Sending Heartbeat request with generation {} and member id {} to coordinator {}", new Object[]{this.generation.generationId, this.generation.memberId, this.coordinator});
        HeartbeatRequest.Builder requestBuilder = new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId(this.rebalanceConfig.groupId).setMemberId(this.generation.memberId).setGroupInstanceId(this.rebalanceConfig.groupInstanceId.orElse(null)).setGenerationId(this.generation.generationId));
        return this.client.send(this.coordinator, requestBuilder).compose(new HeartbeatResponseHandler(this.generation));
    }

    protected Meter createMeter(Metrics metrics, String groupName, String baseName, String descriptiveName) {
        return new Meter(new WindowedCount(), metrics.metricName(baseName + "-rate", groupName, String.format("The number of %s per second", descriptiveName)), metrics.metricName(baseName + "-total", groupName, String.format("The total number of %s", descriptiveName)));
    }

    public Heartbeat heartbeat() {
        return this.heartbeat;
    }

    final void setLastRebalanceTime(long timestamp) {
        this.lastRebalanceEndMs = timestamp;
    }

    final boolean hasMatchingGenerationId(int generationId) {
        return this.generation != Generation.NO_GENERATION && this.generation.generationId == generationId;
    }

    final boolean hasUnknownGeneration() {
        return this.generation == Generation.NO_GENERATION;
    }

    final boolean hasValidMemberId() {
        return this.generation != Generation.NO_GENERATION && this.generation.hasMemberId();
    }

    private static class UnjoinedGroupException
    extends RetriableException {
        private UnjoinedGroupException() {
        }
    }

    protected static class Generation {
        public static final Generation NO_GENERATION = new Generation(-1, "", null);
        public final int generationId;
        public final String memberId;
        public final String protocolName;

        public Generation(int generationId, String memberId, String protocolName) {
            this.generationId = generationId;
            this.memberId = memberId;
            this.protocolName = protocolName;
        }

        public boolean hasMemberId() {
            return !this.memberId.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Generation that = (Generation)o;
            return this.generationId == that.generationId && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.protocolName, that.protocolName);
        }

        public int hashCode() {
            return Objects.hash(this.generationId, this.memberId, this.protocolName);
        }

        public String toString() {
            return "Generation{generationId=" + this.generationId + ", memberId='" + this.memberId + '\'' + ", protocol='" + this.protocolName + '\'' + '}';
        }
    }

    private class HeartbeatThread
    extends KafkaThread
    implements AutoCloseable {
        private boolean enabled;
        private boolean closed;
        private AtomicReference<RuntimeException> failed;

        private HeartbeatThread() {
            super(AbstractCoordinator.HEARTBEAT_THREAD_PREFIX + (((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId.isEmpty() ? "" : " | " + ((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId), true);
            this.enabled = false;
            this.closed = false;
            this.failed = new AtomicReference<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enable() {
            AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
            synchronized (abstractCoordinator) {
                AbstractCoordinator.this.log.debug("Enabling heartbeat thread");
                this.enabled = true;
                AbstractCoordinator.this.heartbeat.resetTimeouts();
                AbstractCoordinator.this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disable() {
            AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
            synchronized (abstractCoordinator) {
                AbstractCoordinator.this.log.debug("Disabling heartbeat thread");
                this.enabled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
            synchronized (abstractCoordinator) {
                this.closed = true;
                AbstractCoordinator.this.notify();
            }
        }

        private boolean hasFailed() {
            return this.failed.get() != null;
        }

        private RuntimeException failureCause() {
            return this.failed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                AbstractCoordinator.this.log.debug("Heartbeat thread started");
                while (true) {
                    AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                    // MONITORENTER : abstractCoordinator
                    if (this.closed) {
                        // MONITOREXIT : abstractCoordinator
                        return;
                    }
                    if (!this.enabled) {
                        AbstractCoordinator.this.wait();
                        // MONITOREXIT : abstractCoordinator
                        continue;
                    }
                    if (AbstractCoordinator.this.state != MemberState.STABLE) {
                        this.disable();
                        // MONITOREXIT : abstractCoordinator
                        continue;
                    }
                    AbstractCoordinator.this.client.pollNoWakeup();
                    long now = AbstractCoordinator.this.time.milliseconds();
                    if (AbstractCoordinator.this.coordinatorUnknown()) {
                        if (AbstractCoordinator.this.findCoordinatorFuture != null || AbstractCoordinator.this.lookupCoordinator().failed()) {
                            AbstractCoordinator.this.wait(((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.retryBackoffMs);
                        }
                    } else if (AbstractCoordinator.this.heartbeat.sessionTimeoutExpired(now)) {
                        AbstractCoordinator.this.markCoordinatorUnknown();
                    } else if (AbstractCoordinator.this.heartbeat.pollTimeoutExpired(now)) {
                        String leaveReason = "consumer poll timeout has expired. This means the time between subsequent calls to poll() was longer than the configured max.poll.interval.ms, which typically implies that the poll loop is spending too much time processing messages. You can address this either by increasing max.poll.interval.ms or by reducing the maximum size of batches returned in poll() with max.poll.records.";
                        AbstractCoordinator.this.maybeLeaveGroup(leaveReason);
                    } else if (!AbstractCoordinator.this.heartbeat.shouldHeartbeat(now)) {
                        AbstractCoordinator.this.wait(((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.retryBackoffMs);
                    } else {
                        AbstractCoordinator.this.heartbeat.sentHeartbeat(now);
                        RequestFuture<Void> heartbeatFuture = AbstractCoordinator.this.sendHeartbeatRequest();
                        heartbeatFuture.addListener(new RequestFutureListener<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onSuccess(Void value) {
                                AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                                synchronized (abstractCoordinator) {
                                    AbstractCoordinator.this.heartbeat.receiveHeartbeat();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onFailure(RuntimeException e) {
                                AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                                synchronized (abstractCoordinator) {
                                    if (e instanceof RebalanceInProgressException) {
                                        AbstractCoordinator.this.heartbeat.receiveHeartbeat();
                                    } else if (e instanceof FencedInstanceIdException) {
                                        AbstractCoordinator.this.log.error("Caught fenced group.instance.id {} error in heartbeat thread", ((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupInstanceId);
                                        AbstractCoordinator.this.heartbeatThread.failed.set(e);
                                        AbstractCoordinator.this.heartbeatThread.disable();
                                    } else {
                                        AbstractCoordinator.this.heartbeat.failHeartbeat();
                                        AbstractCoordinator.this.notify();
                                    }
                                }
                            }
                        });
                    }
                    // MONITOREXIT : abstractCoordinator
                    continue;
                    break;
                }
            }
            catch (AuthenticationException e) {
                AbstractCoordinator.this.log.error("An authentication error occurred in the heartbeat thread", (Throwable)e);
                this.failed.set(e);
                return;
            }
            catch (GroupAuthorizationException e) {
                AbstractCoordinator.this.log.error("A group authorization error occurred in the heartbeat thread", (Throwable)e);
                this.failed.set(e);
                return;
            }
            catch (InterruptedException | InterruptException e) {
                Thread.interrupted();
                AbstractCoordinator.this.log.error("Unexpected interrupt received in heartbeat thread", (Throwable)e);
                this.failed.set(new RuntimeException(e));
                return;
            }
            catch (Throwable e) {
                AbstractCoordinator.this.log.error("Heartbeat thread failed due to unexpected error", e);
                if (e instanceof RuntimeException) {
                    this.failed.set((RuntimeException)e);
                    return;
                }
                this.failed.set(new RuntimeException(e));
                return;
            }
            finally {
                AbstractCoordinator.this.log.debug("Heartbeat thread has closed");
            }
        }
    }

    private class GroupCoordinatorMetrics {
        public final String metricGrpName;
        public final Sensor heartbeatSensor;
        public final Sensor joinSensor;
        public final Sensor syncSensor;
        public final Sensor successfulRebalanceSensor;
        public final Sensor failedRebalanceSensor;

        public GroupCoordinatorMetrics(Metrics metrics, String metricGrpPrefix) {
            this.metricGrpName = metricGrpPrefix + "-coordinator-metrics";
            this.heartbeatSensor = metrics.sensor("heartbeat-latency");
            this.heartbeatSensor.add(metrics.metricName("heartbeat-response-time-max", this.metricGrpName, "The max time taken to receive a response to a heartbeat request"), new Max());
            this.heartbeatSensor.add(AbstractCoordinator.this.createMeter(metrics, this.metricGrpName, "heartbeat", "heartbeats"));
            this.joinSensor = metrics.sensor("join-latency");
            this.joinSensor.add(metrics.metricName("join-time-avg", this.metricGrpName, "The average time taken for a group rejoin"), new Avg());
            this.joinSensor.add(metrics.metricName("join-time-max", this.metricGrpName, "The max time taken for a group rejoin"), new Max());
            this.joinSensor.add(AbstractCoordinator.this.createMeter(metrics, this.metricGrpName, "join", "group joins"));
            this.syncSensor = metrics.sensor("sync-latency");
            this.syncSensor.add(metrics.metricName("sync-time-avg", this.metricGrpName, "The average time taken for a group sync"), new Avg());
            this.syncSensor.add(metrics.metricName("sync-time-max", this.metricGrpName, "The max time taken for a group sync"), new Max());
            this.syncSensor.add(AbstractCoordinator.this.createMeter(metrics, this.metricGrpName, "sync", "group syncs"));
            this.successfulRebalanceSensor = metrics.sensor("rebalance-latency");
            this.successfulRebalanceSensor.add(metrics.metricName("rebalance-latency-avg", this.metricGrpName, "The average time taken for a group to complete a successful rebalance, which may be composed of several failed re-trials until it succeeded"), new Avg());
            this.successfulRebalanceSensor.add(metrics.metricName("rebalance-latency-max", this.metricGrpName, "The max time taken for a group to complete a successful rebalance, which may be composed of several failed re-trials until it succeeded"), new Max());
            this.successfulRebalanceSensor.add(metrics.metricName("rebalance-latency-total", this.metricGrpName, "The total number of milliseconds this consumer has spent in successful rebalances since creation"), new CumulativeSum());
            this.successfulRebalanceSensor.add(metrics.metricName("rebalance-total", this.metricGrpName, "The total number of successful rebalance events, each event is composed of several failed re-trials until it succeeded"), new CumulativeCount());
            this.successfulRebalanceSensor.add(metrics.metricName("rebalance-rate-per-hour", this.metricGrpName, "The number of successful rebalance events per hour, each event is composed of several failed re-trials until it succeeded"), new Rate(TimeUnit.HOURS, new WindowedCount()));
            this.failedRebalanceSensor = metrics.sensor("failed-rebalance");
            this.failedRebalanceSensor.add(metrics.metricName("failed-rebalance-total", this.metricGrpName, "The total number of failed rebalance events"), new CumulativeCount());
            this.failedRebalanceSensor.add(metrics.metricName("failed-rebalance-rate-per-hour", this.metricGrpName, "The number of failed rebalance events per hour"), new Rate(TimeUnit.HOURS, new WindowedCount()));
            Measurable lastRebalance = (config, now) -> {
                if (AbstractCoordinator.this.lastRebalanceEndMs == -1L) {
                    return -1.0;
                }
                return TimeUnit.SECONDS.convert(now - AbstractCoordinator.this.lastRebalanceEndMs, TimeUnit.MILLISECONDS);
            };
            metrics.addMetric(metrics.metricName("last-rebalance-seconds-ago", this.metricGrpName, "The number of seconds since the last successful rebalance event"), lastRebalance);
            Measurable lastHeartbeat = (config, now) -> {
                if (AbstractCoordinator.this.heartbeat.lastHeartbeatSend() == 0L) {
                    return -1.0;
                }
                return TimeUnit.SECONDS.convert(now - AbstractCoordinator.this.heartbeat.lastHeartbeatSend(), TimeUnit.MILLISECONDS);
            };
            metrics.addMetric(metrics.metricName("last-heartbeat-seconds-ago", this.metricGrpName, "The number of seconds since the last coordinator heartbeat was sent"), lastHeartbeat);
        }
    }

    protected abstract class CoordinatorResponseHandler<R, T>
    extends RequestFutureAdapter<ClientResponse, T> {
        protected ClientResponse response;

        protected CoordinatorResponseHandler() {
        }

        public abstract void handle(R var1, RequestFuture<T> var2);

        @Override
        public void onFailure(RuntimeException e, RequestFuture<T> future) {
            if (e instanceof DisconnectException) {
                AbstractCoordinator.this.markCoordinatorUnknown(true);
            }
            future.raise(e);
        }

        @Override
        public void onSuccess(ClientResponse clientResponse, RequestFuture<T> future) {
            block2: {
                try {
                    this.response = clientResponse;
                    AbstractResponse responseObj = clientResponse.responseBody();
                    this.handle(responseObj, future);
                }
                catch (RuntimeException e) {
                    if (future.isDone()) break block2;
                    future.raise(e);
                }
            }
        }
    }

    private class HeartbeatResponseHandler
    extends CoordinatorResponseHandler<HeartbeatResponse, Void> {
        private final Generation sentGeneration;

        private HeartbeatResponseHandler(Generation generation) {
            this.sentGeneration = generation;
        }

        @Override
        public void handle(HeartbeatResponse heartbeatResponse, RequestFuture<Void> future) {
            ((AbstractCoordinator)AbstractCoordinator.this).sensors.heartbeatSensor.record(this.response.requestLatencyMs());
            Errors error = heartbeatResponse.error();
            if (error == Errors.NONE) {
                AbstractCoordinator.this.log.debug("Received successful Heartbeat response");
                future.complete(null);
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                AbstractCoordinator.this.log.info("Attempt to heartbeat failed since coordinator {} is either not started or not valid", (Object)AbstractCoordinator.this.coordinator());
                AbstractCoordinator.this.markCoordinatorUnknown();
                future.raise(error);
            } else if (error == Errors.REBALANCE_IN_PROGRESS) {
                AbstractCoordinator.this.log.info("Attempt to heartbeat failed since group is rebalancing");
                AbstractCoordinator.this.requestRejoin();
                future.raise(error);
            } else if (error == Errors.ILLEGAL_GENERATION) {
                AbstractCoordinator.this.log.info("Attempt to heartbeat failed since generation {} is not current", (Object)this.sentGeneration.generationId);
                AbstractCoordinator.this.resetGenerationOnResponseError(ApiKeys.HEARTBEAT, error);
                future.raise(error);
            } else if (error == Errors.FENCED_INSTANCE_ID) {
                AbstractCoordinator.this.log.error("Received fatal exception: group.instance.id gets fenced");
                future.raise(error);
            } else if (error == Errors.UNKNOWN_MEMBER_ID) {
                AbstractCoordinator.this.log.info("Attempt to heartbeat failed for since member id {} is not valid.", (Object)this.sentGeneration.memberId);
                AbstractCoordinator.this.resetGenerationOnResponseError(ApiKeys.HEARTBEAT, error);
                future.raise(error);
            } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                future.raise(GroupAuthorizationException.forGroupId(((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId));
            } else {
                future.raise(new KafkaException("Unexpected error in heartbeat response: " + error.message()));
            }
        }
    }

    private class LeaveGroupResponseHandler
    extends CoordinatorResponseHandler<LeaveGroupResponse, Void> {
        private LeaveGroupResponseHandler() {
        }

        @Override
        public void handle(LeaveGroupResponse leaveResponse, RequestFuture<Void> future) {
            Errors error;
            List<LeaveGroupResponseData.MemberResponse> members = leaveResponse.memberResponses();
            if (members.size() > 1) {
                future.raise(new IllegalStateException("The expected leave group response should only contain no more than one member info, however get " + members));
            }
            if ((error = leaveResponse.error()) == Errors.NONE) {
                AbstractCoordinator.this.log.debug("LeaveGroup request returned successfully");
                future.complete(null);
            } else {
                AbstractCoordinator.this.log.error("LeaveGroup request failed with error: {}", (Object)error.message());
                future.raise(error);
            }
        }
    }

    private class FindCoordinatorResponseHandler
    extends RequestFutureAdapter<ClientResponse, Void> {
        private FindCoordinatorResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientResponse resp, RequestFuture<Void> future) {
            AbstractCoordinator.this.log.debug("Received FindCoordinator response {}", (Object)resp);
            AbstractCoordinator.this.clearFindCoordinatorFuture();
            FindCoordinatorResponse findCoordinatorResponse = (FindCoordinatorResponse)resp.responseBody();
            Errors error = findCoordinatorResponse.error();
            if (error == Errors.NONE) {
                AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                synchronized (abstractCoordinator) {
                    int coordinatorConnectionId = Integer.MAX_VALUE - findCoordinatorResponse.data().nodeId();
                    AbstractCoordinator.this.coordinator = new Node(coordinatorConnectionId, findCoordinatorResponse.data().host(), findCoordinatorResponse.data().port());
                    AbstractCoordinator.this.log.info("Discovered group coordinator {}", (Object)AbstractCoordinator.this.coordinator);
                    AbstractCoordinator.this.client.tryConnect(AbstractCoordinator.this.coordinator);
                    AbstractCoordinator.this.heartbeat.resetSessionTimeout();
                }
                future.complete(null);
            } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                future.raise(GroupAuthorizationException.forGroupId(((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId));
            } else {
                AbstractCoordinator.this.log.debug("Group coordinator lookup failed: {}", (Object)findCoordinatorResponse.data().errorMessage());
                future.raise(error);
            }
        }

        @Override
        public void onFailure(RuntimeException e, RequestFuture<Void> future) {
            AbstractCoordinator.this.clearFindCoordinatorFuture();
            super.onFailure(e, future);
        }
    }

    private class SyncGroupResponseHandler
    extends CoordinatorResponseHandler<SyncGroupResponse, ByteBuffer> {
        private SyncGroupResponseHandler() {
        }

        @Override
        public void handle(SyncGroupResponse syncResponse, RequestFuture<ByteBuffer> future) {
            Errors error = syncResponse.error();
            if (error == Errors.NONE) {
                if (AbstractCoordinator.this.isProtocolTypeInconsistent(syncResponse.data.protocolType())) {
                    AbstractCoordinator.this.log.debug("SyncGroup failed due to inconsistent Protocol Type, received {} but expected {}", (Object)syncResponse.data.protocolType(), (Object)AbstractCoordinator.this.protocolType());
                    future.raise(Errors.INCONSISTENT_GROUP_PROTOCOL);
                } else if (AbstractCoordinator.this.isProtocolNameInconsistent(syncResponse.data.protocolName())) {
                    AbstractCoordinator.this.log.debug("SyncGroup failed due to inconsistent Protocol Name, received {} but expected {}", (Object)syncResponse.data.protocolName(), (Object)AbstractCoordinator.this.generation().protocolName);
                    future.raise(Errors.INCONSISTENT_GROUP_PROTOCOL);
                } else {
                    AbstractCoordinator.this.log.debug("Received successful SyncGroup response: {}", (Object)syncResponse);
                    ((AbstractCoordinator)AbstractCoordinator.this).sensors.syncSensor.record(this.response.requestLatencyMs());
                    future.complete(ByteBuffer.wrap(syncResponse.data.assignment()));
                }
            } else {
                AbstractCoordinator.this.requestRejoin();
                if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                    future.raise(GroupAuthorizationException.forGroupId(((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId));
                } else if (error == Errors.REBALANCE_IN_PROGRESS) {
                    AbstractCoordinator.this.log.debug("SyncGroup failed because the group began another rebalance");
                    future.raise(error);
                } else if (error == Errors.FENCED_INSTANCE_ID) {
                    AbstractCoordinator.this.log.error("Received fatal exception: group.instance.id gets fenced");
                    future.raise(error);
                } else if (error == Errors.UNKNOWN_MEMBER_ID || error == Errors.ILLEGAL_GENERATION) {
                    AbstractCoordinator.this.log.debug("SyncGroup failed: {}", (Object)error.message());
                    AbstractCoordinator.this.resetGenerationOnResponseError(ApiKeys.SYNC_GROUP, error);
                    future.raise(error);
                } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                    AbstractCoordinator.this.log.debug("SyncGroup failed: {}", (Object)error.message());
                    AbstractCoordinator.this.markCoordinatorUnknown();
                    future.raise(error);
                } else {
                    future.raise(new KafkaException("Unexpected error from SyncGroup: " + error.message()));
                }
            }
        }
    }

    private class JoinGroupResponseHandler
    extends CoordinatorResponseHandler<JoinGroupResponse, ByteBuffer> {
        private JoinGroupResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(JoinGroupResponse joinResponse, RequestFuture<ByteBuffer> future) {
            Errors error = joinResponse.error();
            if (error == Errors.NONE) {
                if (AbstractCoordinator.this.isProtocolTypeInconsistent(joinResponse.data().protocolType())) {
                    AbstractCoordinator.this.log.debug("JoinGroup failed due to inconsistent Protocol Type, received {} but expected {}", (Object)joinResponse.data().protocolType(), (Object)AbstractCoordinator.this.protocolType());
                    future.raise(Errors.INCONSISTENT_GROUP_PROTOCOL);
                } else {
                    AbstractCoordinator.this.log.debug("Received successful JoinGroup response: {}", (Object)joinResponse);
                    ((AbstractCoordinator)AbstractCoordinator.this).sensors.joinSensor.record(this.response.requestLatencyMs());
                    AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                    synchronized (abstractCoordinator) {
                        if (AbstractCoordinator.this.state != MemberState.REBALANCING) {
                            future.raise(new UnjoinedGroupException());
                        } else {
                            AbstractCoordinator.this.generation = new Generation(joinResponse.data().generationId(), joinResponse.data().memberId(), joinResponse.data().protocolName());
                            if (joinResponse.isLeader()) {
                                AbstractCoordinator.this.onJoinLeader(joinResponse).chain(future);
                            } else {
                                AbstractCoordinator.this.onJoinFollower().chain(future);
                            }
                        }
                    }
                }
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS) {
                AbstractCoordinator.this.log.debug("Attempt to join group rejected since coordinator {} is loading the group.", (Object)AbstractCoordinator.this.coordinator());
                future.raise(error);
            } else if (error == Errors.UNKNOWN_MEMBER_ID) {
                AbstractCoordinator.this.resetGenerationOnResponseError(ApiKeys.JOIN_GROUP, error);
                AbstractCoordinator.this.log.debug("Attempt to join group failed due to unknown member id.");
                future.raise(error);
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                AbstractCoordinator.this.markCoordinatorUnknown();
                AbstractCoordinator.this.log.debug("Attempt to join group failed due to obsolete coordinator information: {}", (Object)error.message());
                future.raise(error);
            } else if (error == Errors.FENCED_INSTANCE_ID) {
                AbstractCoordinator.this.log.error("Received fatal exception: group.instance.id gets fenced");
                future.raise(error);
            } else if (error == Errors.INCONSISTENT_GROUP_PROTOCOL || error == Errors.INVALID_SESSION_TIMEOUT || error == Errors.INVALID_GROUP_ID || error == Errors.GROUP_AUTHORIZATION_FAILED || error == Errors.GROUP_MAX_SIZE_REACHED) {
                AbstractCoordinator.this.log.error("Attempt to join group failed due to fatal error: {}", (Object)error.message());
                if (error == Errors.GROUP_MAX_SIZE_REACHED) {
                    future.raise(new GroupMaxSizeReachedException("Consumer group " + ((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId + " already has the configured maximum number of members."));
                } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                    future.raise(GroupAuthorizationException.forGroupId(((AbstractCoordinator)AbstractCoordinator.this).rebalanceConfig.groupId));
                } else {
                    future.raise(error);
                }
            } else if (error == Errors.UNSUPPORTED_VERSION) {
                AbstractCoordinator.this.log.error("Attempt to join group failed due to unsupported version error. Please unset field group.instance.id and retry to see if the problem resolves");
                future.raise(error);
            } else if (error == Errors.MEMBER_ID_REQUIRED) {
                AbstractCoordinator abstractCoordinator = AbstractCoordinator.this;
                synchronized (abstractCoordinator) {
                    AbstractCoordinator.this.generation = new Generation(-1, joinResponse.data().memberId(), null);
                    AbstractCoordinator.this.resetStateAndRejoin();
                }
                future.raise(error);
            } else {
                AbstractCoordinator.this.log.error("Attempt to join group failed due to unexpected error: {}", (Object)error.message());
                future.raise(new KafkaException("Unexpected error in join group response: " + error.message()));
            }
        }
    }

    protected static enum MemberState {
        UNJOINED,
        REBALANCING,
        STABLE;

    }
}

