/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.desc.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.database.drop.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.database.show.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.ddl.database.use.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.DescTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.set.location.AlterTableSetLocationDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateDatabaseHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateTableHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;

public class HCatSemanticAnalyzer
extends HCatSemanticAnalyzerBase {
    private AbstractSemanticAnalyzerHook hook;
    private ASTNode ast;

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        this.ast = ast;
        switch (ast.getToken().getType()) {
            case 954: {
                this.hook = new CreateTableHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 949: {
                this.hook = new CreateDatabaseHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 856: {
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 876) {
                    return ast;
                }
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 878) {
                    throw new SemanticException("Operation not supported.");
                }
                return ast;
            }
            case 843: 
            case 857: 
            case 859: 
            case 862: 
            case 863: 
            case 870: 
            case 881: 
            case 882: 
            case 883: 
            case 886: 
            case 888: 
            case 890: 
            case 893: 
            case 895: 
            case 899: 
            case 902: 
            case 904: 
            case 905: 
            case 953: 
            case 955: 
            case 990: 
            case 992: 
            case 993: 
            case 1001: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1021: 
            case 1038: 
            case 1040: 
            case 1042: 
            case 1088: 
            case 1179: 
            case 1180: 
            case 1204: 
            case 1207: 
            case 1208: 
            case 1210: 
            case 1211: 
            case 1217: 
            case 1219: 
            case 1222: 
            case 1242: 
            case 1302: {
                return ast;
            }
        }
        throw new SemanticException("Operation not supported.");
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<?>> rootTasks) throws SemanticException {
        try {
            switch (this.ast.getToken().getType()) {
                case 843: 
                case 949: 
                case 954: 
                case 990: 
                case 1001: 
                case 1204: 
                case 1242: {
                    break;
                }
                case 899: {
                    switch (this.ast.getChild(1).getType()) {
                        default: 
                    }
                    break;
                }
                case 953: 
                case 955: 
                case 992: 
                case 1005: 
                case 1007: 
                case 1021: 
                case 1038: 
                case 1040: 
                case 1042: 
                case 1088: 
                case 1179: 
                case 1180: 
                case 1207: 
                case 1208: 
                case 1217: 
                case 1219: 
                case 1302: {
                    break;
                }
                case 856: {
                    switch (this.ast.getChild(1).getType()) {
                        default: 
                    }
                    break;
                }
                case 993: 
                case 1006: 
                case 1210: 
                case 1211: 
                case 1222: {
                    break;
                }
                default: {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, "Unexpected token: " + this.ast.getToken());
                }
            }
            this.authorizeDDL(context, rootTasks);
        }
        catch (HCatException e) {
            throw new SemanticException((Throwable)e);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        if (this.hook != null) {
            this.hook.postAnalyze(context, rootTasks);
        }
    }

    private String extractTableName(String compoundName) {
        String[] words = compoundName.split("\\.");
        return words[0];
    }

    @Override
    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext cntxt, Hive hive, DDLWork work) throws HiveException {
        DDLDesc ddlDesc = work.getDDLDesc();
        if (ddlDesc instanceof ShowDatabasesDesc) {
            this.authorize(HiveOperation.SHOWDATABASES.getInputRequiredPrivileges(), HiveOperation.SHOWDATABASES.getOutputRequiredPrivileges());
        } else if (ddlDesc instanceof DropDatabaseDesc) {
            DropDatabaseDesc dropDb = (DropDatabaseDesc)ddlDesc;
            Database db = cntxt.getHive().getDatabase(dropDb.getDatabaseName());
            if (db != null) {
                this.authorize(db, Privilege.DROP);
            }
        } else if (ddlDesc instanceof DescDatabaseDesc) {
            DescDatabaseDesc descDb = (DescDatabaseDesc)ddlDesc;
            Database db = cntxt.getHive().getDatabase(descDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        } else if (ddlDesc instanceof SwitchDatabaseDesc) {
            SwitchDatabaseDesc switchDb = (SwitchDatabaseDesc)ddlDesc;
            Database db = cntxt.getHive().getDatabase(switchDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        } else if (ddlDesc instanceof ShowTablesDesc) {
            ShowTablesDesc showTables = (ShowTablesDesc)ddlDesc;
            String dbName = showTables.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTables.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        } else if (ddlDesc instanceof DescTableDesc) {
            DescTableDesc descTable = (DescTableDesc)ddlDesc;
            String tableName = this.extractTableName(descTable.getDbTableName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        } else if (ddlDesc instanceof ShowTableStatusDesc) {
            ShowTableStatusDesc showTableStatus = (ShowTableStatusDesc)ddlDesc;
            String dbName = showTableStatus.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTableStatus.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        } else if (ddlDesc instanceof AlterTableDropPartitionDesc) {
            AlterTableDropPartitionDesc dropPartition = (AlterTableDropPartitionDesc)ddlDesc;
            for (AlterTableDropPartitionDesc.PartitionDesc partSpec : dropPartition.getPartSpecs()) {
                Table table = hive.getTable(SessionState.get().getCurrentDatabase(), dropPartition.getTableName());
                List partitions = null;
                try {
                    partitions = hive.getPartitionsByFilter(table, partSpec.getPartSpec().getExprString());
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
                for (Partition part : partitions) {
                    this.authorize(part, Privilege.DROP);
                }
            }
        } else if (ddlDesc instanceof ShowPartitionsDesc) {
            ShowPartitionsDesc showParts = (ShowPartitionsDesc)ddlDesc;
            String tableName = this.extractTableName(showParts.getTabName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        } else if (ddlDesc instanceof AlterTableSetLocationDesc) {
            AlterTableSetLocationDesc alterTable = (AlterTableSetLocationDesc)ddlDesc;
            Table table = hive.getTable(SessionState.get().getCurrentDatabase(), Utilities.getDbTableName((String)alterTable.getDbTableName())[1], false);
            Partition part = null;
            if (alterTable.getPartitionSpec() != null) {
                part = hive.getPartition(table, alterTable.getPartitionSpec(), false);
            }
            String newLocation = alterTable.getLocation();
            if (part != null) {
                this.authorize(part, Privilege.ALTER_DATA);
                part.setLocation(newLocation);
                this.authorize(part, Privilege.ALTER_DATA);
            } else {
                this.authorize(table, Privilege.ALTER_DATA);
                table.getTTable().getSd().setLocation(newLocation);
                this.authorize(table, Privilege.ALTER_DATA);
            }
        }
    }
}

