/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.kafka.KafkaInputSplit;
import org.apache.hadoop.hive.kafka.KafkaRecordReader;
import org.apache.hadoop.hive.kafka.KafkaScanTrimmer;
import org.apache.hadoop.hive.kafka.KafkaUtils;
import org.apache.hadoop.hive.kafka.KafkaWritable;
import org.apache.hadoop.hive.kafka.RetryUtils;
import org.apache.hadoop.hive.kafka.VectorizedKafkaRecordReader;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.kafkaesque.clients.consumer.KafkaConsumer;
import org.apache.kafkaesque.common.PartitionInfo;
import org.apache.kafkaesque.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaInputFormat
extends InputFormat<NullWritable, KafkaWritable>
implements org.apache.hadoop.mapred.InputFormat<NullWritable, KafkaWritable>,
VectorizedInputFormatInterface {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaInputFormat.class);

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int i) throws IOException {
        List<KafkaInputSplit> inputSplits;
        try {
            inputSplits = this.computeSplits((Configuration)jobConf);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        org.apache.hadoop.mapred.InputSplit[] inputSplitsArray = new org.apache.hadoop.mapred.InputSplit[inputSplits.size()];
        return inputSplits.toArray(inputSplitsArray);
    }

    private static List<KafkaInputSplit> buildFullScanFromKafka(String topic, KafkaConsumer<byte[], byte[]> consumer, Path[] tablePaths, int maxTries) {
        List topicPartitions;
        RetryUtils.Task<List> fetchTPTask = () -> KafkaInputFormat.fetchTopicPartitions(topic, consumer);
        try {
            topicPartitions = RetryUtils.retry(fetchTPTask, error -> !KafkaUtils.exceptionIsFatal(error), maxTries);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map<TopicPartition, Long> starOffsetsMap = consumer.beginningOffsets(topicPartitions);
        Map<TopicPartition, Long> endOffsetsMap = consumer.endOffsets(topicPartitions);
        if (LOG.isDebugEnabled()) {
            LOG.info("Found the following partitions [{}]", (Object)topicPartitions.stream().map(TopicPartition::toString).collect(Collectors.joining(",")));
            starOffsetsMap.forEach((tp, start) -> LOG.info("TPartition [{}],Start offsets [{}]", tp, start));
            endOffsetsMap.forEach((tp, end) -> LOG.info("TPartition [{}],End offsets [{}]", tp, end));
        }
        return topicPartitions.stream().map(topicPartition -> new KafkaInputSplit(topicPartition.topic(), topicPartition.partition(), (Long)starOffsetsMap.get(topicPartition), (Long)endOffsetsMap.get(topicPartition), tablePaths[0])).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private List<KafkaInputSplit> computeSplits(Configuration configuration) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<TopicPartition> fetchTopicPartitions(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        List<PartitionInfo> partitions = consumer.partitionsFor(topic);
        return partitions.stream().map(p -> new TopicPartition(topic, p.partition())).collect(Collectors.toList());
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, KafkaWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit inputSplit, JobConf jobConf, Reporter reporter) {
        if (Utilities.getIsVectorized((Configuration)jobConf)) {
            return new VectorizedKafkaRecordReader((KafkaInputSplit)inputSplit, (Configuration)jobConf);
        }
        return new KafkaRecordReader((KafkaInputSplit)inputSplit, (Configuration)jobConf);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.computeSplits(jobContext.getConfiguration()).stream().map(kafkaPullerInputSplit -> kafkaPullerInputSplit).collect(Collectors.toList());
    }

    public RecordReader<NullWritable, KafkaWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        return new KafkaRecordReader();
    }

    public VectorizedSupport.Support[] getSupportedFeatures() {
        return new VectorizedSupport.Support[0];
    }

    private static /* synthetic */ boolean lambda$computeSplits$8(KafkaInputSplit split) {
        return split.getStartOffset() < split.getEndOffset();
    }

    private static /* synthetic */ List lambda$computeSplits$7(KafkaScanTrimmer kafkaScanTrimmer, ExprNodeGenericFuncDesc filterExpr) throws Exception {
        return kafkaScanTrimmer.computeOptimizedScan(filterExpr).entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$computeSplits$6(ImmutableMap.Builder fullHouseMapBuilder, KafkaInputSplit input) {
        fullHouseMapBuilder.put((Object)new TopicPartition(input.getTopic(), input.getPartition()), (Object)input);
    }

    private static /* synthetic */ List lambda$computeSplits$5(String topic, KafkaConsumer consumer, Path[] tablePaths, int maxTries) throws Exception {
        return KafkaInputFormat.buildFullScanFromKafka(topic, consumer, tablePaths, maxTries);
    }
}

