/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.CompactArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.utils.ByteUtils;

public class DeleteAclsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<DeleteAclsFilterResult> filterResults;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new ArrayOf(DeleteAclsFilterResult.SCHEMA_0), "The results for each filter."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new ArrayOf(DeleteAclsFilterResult.SCHEMA_1), "The results for each filter."));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new CompactArrayOf(DeleteAclsFilterResult.SCHEMA_2), "The results for each filter."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public DeleteAclsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteAclsResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DeleteAclsResponseData() {
        this.throttleTimeMs = 0;
        this.filterResults = new ArrayList<DeleteAclsFilterResult>();
    }

    @Override
    public short apiKey() {
        return 31;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DeleteAclsFilterResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filterResults was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilterResult(_readable, _version));
            }
            this.filterResults = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filterResults was serialized as null");
            }
            newCollection = new ArrayList<DeleteAclsFilterResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilterResult(_readable, _version));
            }
            this.filterResults = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.filterResults.size() + 1);
            for (DeleteAclsFilterResult filterResultsElement : this.filterResults) {
                filterResultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.filterResults.size());
            for (DeleteAclsFilterResult filterResultsElement : this.filterResults) {
                filterResultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] _nestedObjects = struct.getArray("filter_results");
        this.filterResults = new ArrayList<DeleteAclsFilterResult>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.filterResults.add(new DeleteAclsFilterResult((Struct)nestedObject, _version));
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] _nestedObjects = new Struct[this.filterResults.size()];
        int i = 0;
        for (DeleteAclsFilterResult element : this.filterResults) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("filter_results", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.filterResults.size() + 1)) : (_arraySize += 4);
        for (DeleteAclsFilterResult filterResultsElement : this.filterResults) {
            _arraySize += filterResultsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsResponseData)) {
            return false;
        }
        DeleteAclsResponseData other = (DeleteAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.filterResults == null ? other.filterResults != null : !this.filterResults.equals(other.filterResults));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.filterResults == null ? 0 : this.filterResults.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", filterResults=" + MessageUtil.deepToString(this.filterResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DeleteAclsFilterResult> filterResults() {
        return this.filterResults;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteAclsResponseData setFilterResults(List<DeleteAclsFilterResult> v) {
        this.filterResults = v;
        return this;
    }

    public static class DeleteAclsMatchingAcl
    implements Message {
        private short errorCode;
        private String errorMessage;
        private byte resourceType;
        private String resourceName;
        private byte patternType;
        private String principal;
        private String host;
        private byte operation;
        private byte permissionType;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.STRING, "The ACL resource name."), new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.STRING, "The ACL resource name."), new Field("pattern_type", Type.INT8, "The ACL resource pattern type."), new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.COMPACT_STRING, "The ACL resource name."), new Field("pattern_type", Type.INT8, "The ACL resource pattern type."), new Field("principal", Type.COMPACT_STRING, "The ACL principal."), new Field("host", Type.COMPACT_STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

        public DeleteAclsMatchingAcl(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteAclsMatchingAcl(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DeleteAclsMatchingAcl() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.resourceType = 0;
            this.resourceName = "";
            this.patternType = (byte)3;
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsMatchingAcl");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            this.resourceType = _readable.readByte();
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            this.patternType = _version >= 1 ? _readable.readByte() : (byte)3;
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principal was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principal had invalid length " + length);
            }
            this.principal = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteAclsMatchingAcl");
            }
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.resourceType);
            _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.patternType);
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            _stringBytes = _cache.getSerializedValue(this.principal);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsMatchingAcl");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            this.patternType = _version >= 1 ? struct.getByte("pattern_type") : (byte)3;
            this.principal = struct.getString("principal");
            this.host = struct.getString("host");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteAclsMatchingAcl");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            if (_version >= 1) {
                struct.set("pattern_type", (Object)this.patternType);
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            struct.set("principal", (Object)this.principal);
            struct.set("host", (Object)this.host);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsMatchingAcl");
            }
            _size += 2;
            if (this.errorMessage == null) {
                _size = _version >= 2 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            ++_size;
            _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (_version >= 1) {
                ++_size;
            }
            if ((_stringBytes = this.principal.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
                throw new RuntimeException("'principal' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principal, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            ++_size;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsMatchingAcl)) {
                return false;
            }
            DeleteAclsMatchingAcl other = (DeleteAclsMatchingAcl)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public String toString() {
            return "DeleteAclsMatchingAcl(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", patternType=" + this.patternType + ", principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte patternType() {
            return this.patternType;
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsMatchingAcl setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeleteAclsMatchingAcl setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DeleteAclsMatchingAcl setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public DeleteAclsMatchingAcl setHost(String v) {
            this.host = v;
            return this;
        }

        public DeleteAclsMatchingAcl setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }
    }

    public static class DeleteAclsFilterResult
    implements Message {
        private short errorCode;
        private String errorMessage;
        private List<DeleteAclsMatchingAcl> matchingAcls;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new ArrayOf(DeleteAclsMatchingAcl.SCHEMA_0), "The ACLs which matched this filter."));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new ArrayOf(DeleteAclsMatchingAcl.SCHEMA_1), "The ACLs which matched this filter."));
        public static final Schema SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new CompactArrayOf(DeleteAclsMatchingAcl.SCHEMA_2), "The ACLs which matched this filter."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

        public DeleteAclsFilterResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteAclsFilterResult(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DeleteAclsFilterResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DeleteAclsMatchingAcl> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilterResult");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field matchingAcls was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DeleteAclsMatchingAcl(_readable, _version));
                }
                this.matchingAcls = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field matchingAcls was serialized as null");
                }
                newCollection = new ArrayList<DeleteAclsMatchingAcl>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DeleteAclsMatchingAcl(_readable, _version));
                }
                this.matchingAcls = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteAclsFilterResult");
            }
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.matchingAcls.size() + 1);
                _stringBytes = this.matchingAcls.iterator();
                while (_stringBytes.hasNext()) {
                    DeleteAclsMatchingAcl matchingAclsElement = (DeleteAclsMatchingAcl)_stringBytes.next();
                    matchingAclsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.matchingAcls.size());
                _stringBytes = this.matchingAcls.iterator();
                while (_stringBytes.hasNext()) {
                    DeleteAclsMatchingAcl matchingAclsElement = (DeleteAclsMatchingAcl)_stringBytes.next();
                    matchingAclsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilterResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            Object[] _nestedObjects = struct.getArray("matching_acls");
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.matchingAcls.add(new DeleteAclsMatchingAcl((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteAclsFilterResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            Struct[] _nestedObjects = new Struct[this.matchingAcls.size()];
            int i = 0;
            for (DeleteAclsMatchingAcl element : this.matchingAcls) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("matching_acls", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsFilterResult");
            }
            _size += 2;
            if (this.errorMessage == null) {
                _size = _version >= 2 ? ++_size : (_size += 2);
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.matchingAcls.size() + 1)) : (_arraySize += 4);
            for (DeleteAclsMatchingAcl matchingAclsElement : this.matchingAcls) {
                _arraySize += matchingAclsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilterResult)) {
                return false;
            }
            DeleteAclsFilterResult other = (DeleteAclsFilterResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return !(this.matchingAcls == null ? other.matchingAcls != null : !this.matchingAcls.equals(other.matchingAcls));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.matchingAcls == null ? 0 : this.matchingAcls.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeleteAclsFilterResult(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", matchingAcls=" + MessageUtil.deepToString(this.matchingAcls.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<DeleteAclsMatchingAcl> matchingAcls() {
            return this.matchingAcls;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsFilterResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeleteAclsFilterResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DeleteAclsFilterResult setMatchingAcls(List<DeleteAclsMatchingAcl> v) {
            this.matchingAcls = v;
            return this;
        }
    }
}

