/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.apache.hadoop.hive.metastore.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(Configuration conf) {
        Collection<String> userFilter = MetastoreConf.getStringCollection(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER);
        if (userFilter.size() == 1 && userFilter.contains("")) {
            userFilter = Collections.emptySet();
        }
        if (userFilter.isEmpty()) {
            return null;
        }
        return new UserFilter(userFilter);
    }

    private static final class UserFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(UserFilter.class);
        private final Set<String> userFilter = new HashSet<String>();

        UserFilter(Collection<String> userFilter) {
            for (String userFilterItem : userFilter) {
                this.userFilter.add(userFilterItem.toLowerCase());
            }
        }

        @Override
        public void apply(DirSearch ldap, String user) throws AuthenticationException {
            LOG.info("Authenticating user '{}' using user filter", (Object)user);
            String userName = LdapUtils.extractUserName(user).toLowerCase();
            if (!this.userFilter.contains(userName)) {
                LOG.info("Authentication failed based on user membership");
                throw new AuthenticationException("Authentication failed: User not a member of specified list");
            }
        }
    }
}

