/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter;

import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMPoolTrigger;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter.JsonShowResourcePlanFormatter;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter.TextShowResourcePlanFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;

public abstract class ShowResourcePlanFormatter {
    public static ShowResourcePlanFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowResourcePlanFormatter();
        }
        return new TextShowResourcePlanFormatter();
    }

    public abstract void showResourcePlans(DataOutputStream var1, List<WMResourcePlan> var2) throws HiveException;

    public abstract void showFullResourcePlan(DataOutputStream var1, WMFullResourcePlan var2) throws HiveException;

    static void formatFullRP(RPFormatter rpFormatter, WMFullResourcePlan fullResourcePlan) throws HiveException {
        try {
            WMResourcePlan plan = fullResourcePlan.getPlan();
            Integer parallelism = plan.isSetQueryParallelism() ? Integer.valueOf(plan.getQueryParallelism()) : null;
            String defaultPool = plan.isSetDefaultPoolPath() ? plan.getDefaultPoolPath() : null;
            rpFormatter.startRP(plan.getName(), "status", plan.getStatus().toString(), "parallelism", parallelism, "defaultPool", defaultPool);
            rpFormatter.startPools();
            PoolTreeNode root = PoolTreeNode.makePoolTree(fullResourcePlan);
            root.sortChildren();
            for (PoolTreeNode pool : root.children) {
                pool.writePoolTreeNode(rpFormatter);
            }
            rpFormatter.endPools();
            rpFormatter.endRP();
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public static interface RPFormatter {
        public void startRP(String var1, Object ... var2) throws IOException;

        public void endRP() throws IOException;

        public void startPools() throws IOException;

        public void startPool(String var1, Object ... var2) throws IOException;

        public void endPool() throws IOException;

        public void endPools() throws IOException;

        public void startTriggers() throws IOException;

        public void formatTrigger(String var1, String var2, String var3) throws IOException;

        public void endTriggers() throws IOException;

        public void startMappings() throws IOException;

        public void formatMappingType(String var1, List<String> var2) throws IOException;

        public void endMappings() throws IOException;
    }

    private static final class PoolTreeNode {
        private String nonPoolName;
        private WMPool pool;
        private boolean isDefault;
        private final List<PoolTreeNode> children = new ArrayList<PoolTreeNode>();
        private final List<WMTrigger> triggers = new ArrayList<WMTrigger>();
        private final Map<String, List<String>> mappings = new HashMap<String, List<String>>();

        private PoolTreeNode() {
        }

        private void writePoolTreeNode(RPFormatter rpFormatter) throws IOException {
            if (this.pool != null) {
                String path = this.pool.getPoolPath();
                int n = path.lastIndexOf(46);
                if (n != -1) {
                    path = path.substring(n + 1);
                }
                Double allocFraction = this.pool.getAllocFraction();
                String schedulingPolicy = this.pool.isSetSchedulingPolicy() ? this.pool.getSchedulingPolicy() : null;
                Integer parallelism = this.pool.getQueryParallelism();
                rpFormatter.startPool(path, "allocFraction", allocFraction, "schedulingPolicy", schedulingPolicy, "parallelism", parallelism);
            } else {
                rpFormatter.startPool(this.nonPoolName, new Object[0]);
            }
            rpFormatter.startTriggers();
            for (WMTrigger wMTrigger : this.triggers) {
                rpFormatter.formatTrigger(wMTrigger.getTriggerName(), wMTrigger.getActionExpression(), wMTrigger.getTriggerExpression());
            }
            rpFormatter.endTriggers();
            rpFormatter.startMappings();
            for (Map.Entry entry : this.mappings.entrySet()) {
                ((List)entry.getValue()).sort(String::compareTo);
                rpFormatter.formatMappingType((String)entry.getKey(), (List)entry.getValue());
            }
            if (this.isDefault) {
                rpFormatter.formatMappingType("default", Lists.newArrayList());
            }
            rpFormatter.endMappings();
            rpFormatter.startPools();
            for (PoolTreeNode poolTreeNode : this.children) {
                poolTreeNode.writePoolTreeNode(rpFormatter);
            }
            rpFormatter.endPools();
            rpFormatter.endPool();
        }

        private void sortChildren() {
            this.children.sort((p1, p2) -> {
                if (p2.pool == null) {
                    return p1.pool == null ? 0 : -1;
                }
                if (p1.pool == null) {
                    return 1;
                }
                return Double.compare(p2.pool.getAllocFraction(), p1.pool.getAllocFraction());
            });
            for (PoolTreeNode child : this.children) {
                child.sortChildren();
            }
            this.triggers.sort((t1, t2) -> t1.getTriggerName().compareTo(t2.getTriggerName()));
        }

        static PoolTreeNode makePoolTree(WMFullResourcePlan fullRp) {
            PoolTreeNode root = new PoolTreeNode();
            HashMap<String, PoolTreeNode> poolMap = new HashMap<String, PoolTreeNode>();
            PoolTreeNode.buildPoolTree(fullRp, root, poolMap);
            HashMap<String, WMTrigger> triggerMap = new HashMap<String, WMTrigger>();
            ArrayList<WMTrigger> unmanagedTriggers = new ArrayList<WMTrigger>();
            HashSet<WMTrigger> unusedTriggers = new HashSet<WMTrigger>();
            PoolTreeNode.sortTriggers(fullRp, poolMap, triggerMap, unmanagedTriggers, unusedTriggers);
            HashMap<String, List<String>> unmanagedMappings = new HashMap<String, List<String>>();
            HashMap<String, List<String>> invalidMappings = new HashMap<String, List<String>>();
            PoolTreeNode.sortMappings(fullRp, poolMap, unmanagedMappings, invalidMappings);
            PoolTreeNode.addNonPoolNodes(root, poolMap, unmanagedTriggers, unusedTriggers, unmanagedMappings, invalidMappings);
            return root;
        }

        private static void buildPoolTree(WMFullResourcePlan fullRp, PoolTreeNode root, Map<String, PoolTreeNode> poolMap) {
            for (WMPool pool : fullRp.getPools()) {
                PoolTreeNode parent;
                int ind;
                String path = pool.getPoolPath();
                PoolTreeNode curr = poolMap.get(path);
                if (curr == null) {
                    curr = new PoolTreeNode();
                    poolMap.put(path, curr);
                }
                curr.pool = pool;
                if (fullRp.getPlan().isSetDefaultPoolPath() && fullRp.getPlan().getDefaultPoolPath().equals(path)) {
                    curr.isDefault = true;
                }
                if ((ind = path.lastIndexOf(46)) == -1) {
                    parent = root;
                } else {
                    String parentPath = path.substring(0, ind);
                    parent = poolMap.get(parentPath);
                    if (parent == null) {
                        parent = new PoolTreeNode();
                        poolMap.put(parentPath, parent);
                    }
                }
                parent.children.add(curr);
            }
        }

        private static void sortTriggers(WMFullResourcePlan fullRp, Map<String, PoolTreeNode> poolMap, Map<String, WMTrigger> triggerMap, List<WMTrigger> unmanagedTriggers, Set<WMTrigger> unusedTriggers) {
            if (fullRp.isSetTriggers()) {
                for (WMTrigger trigger : fullRp.getTriggers()) {
                    triggerMap.put(trigger.getTriggerName(), trigger);
                    if (trigger.isIsInUnmanaged()) {
                        unmanagedTriggers.add(trigger);
                        continue;
                    }
                    unusedTriggers.add(trigger);
                }
            }
            if (fullRp.isSetPoolTriggers()) {
                for (WMPoolTrigger pool2Trigger : fullRp.getPoolTriggers()) {
                    PoolTreeNode node = poolMap.get(pool2Trigger.getPool());
                    WMTrigger trigger = triggerMap.get(pool2Trigger.getTrigger());
                    if (node == null || trigger == null) {
                        throw new IllegalStateException("Invalid trigger to pool: " + pool2Trigger.getPool() + ", " + pool2Trigger.getTrigger());
                    }
                    unusedTriggers.remove(trigger);
                    node.triggers.add(trigger);
                }
            }
        }

        private static void sortMappings(WMFullResourcePlan fullRp, Map<String, PoolTreeNode> poolMap, Map<String, List<String>> unmanagedMappings, Map<String, List<String>> invalidMappings) {
            if (fullRp.isSetMappings()) {
                for (WMMapping mapping : fullRp.getMappings()) {
                    if (mapping.isSetPoolPath()) {
                        PoolTreeNode destNode = poolMap.get(mapping.getPoolPath());
                        PoolTreeNode.addMappingToMap(destNode == null ? invalidMappings : destNode.mappings, mapping);
                        continue;
                    }
                    PoolTreeNode.addMappingToMap(unmanagedMappings, mapping);
                }
            }
        }

        private static void addMappingToMap(Map<String, List<String>> map, WMMapping mapping) {
            List<String> list = map.get(mapping.getEntityType());
            if (list == null) {
                list = new ArrayList<String>();
                map.put(mapping.getEntityType(), list);
            }
            list.add(mapping.getEntityName());
        }

        private static void addNonPoolNodes(PoolTreeNode root, Map<String, PoolTreeNode> poolMap, List<WMTrigger> unmanagedTriggers, Set<WMTrigger> unusedTriggers, Map<String, List<String>> unmanagedMappings, Map<String, List<String>> invalidMappings) {
            PoolTreeNode curr;
            if (!unmanagedTriggers.isEmpty() || !unmanagedMappings.isEmpty()) {
                curr = PoolTreeNode.createNonPoolNode(poolMap, "unmanaged queries", root);
                curr.triggers.addAll(unmanagedTriggers);
                curr.mappings.putAll(unmanagedMappings);
            }
            if (!unusedTriggers.isEmpty()) {
                curr = PoolTreeNode.createNonPoolNode(poolMap, "unused triggers", root);
                curr.triggers.addAll(unusedTriggers);
            }
            if (!invalidMappings.isEmpty()) {
                curr = PoolTreeNode.createNonPoolNode(poolMap, "invalid mappings", root);
                curr.mappings.putAll(invalidMappings);
            }
        }

        private static PoolTreeNode createNonPoolNode(Map<String, PoolTreeNode> poolMap, String name, PoolTreeNode root) {
            PoolTreeNode result;
            while ((result = poolMap.get(name = "<" + (String)name + ">")) != null) {
            }
            result = new PoolTreeNode();
            result.nonPoolName = name;
            poolMap.put((String)name, result);
            root.children.add(result);
            return result;
        }
    }
}

