/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.tez.LlapObjectCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.mapred.JobConf;

public class LimitOperator
extends Operator<LimitDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LIMIT_REACHED_KEY_SUFFIX = "_limit_reached";
    protected transient int limit;
    protected transient int offset;
    protected transient int leastRow;
    protected transient int currCount;
    protected transient boolean isMap;
    protected transient ObjectCache runtimeCache;
    protected transient String limitKey;

    protected LimitOperator() {
    }

    public LimitOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.limit = ((LimitDesc)this.conf).getLimit();
        this.leastRow = ((LimitDesc)this.conf).getLeastRows();
        this.offset = ((LimitDesc)this.conf).getOffset() == null ? 0 : ((LimitDesc)this.conf).getOffset();
        this.currCount = 0;
        this.isMap = hconf.getBoolean("mapred.task.is.map", true);
        String queryId = HiveConf.getVar((Configuration)this.getConfiguration(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        this.runtimeCache = ObjectCacheFactory.getCache(this.getConfiguration(), queryId, false, true);
        if (this.runtimeCache == null) {
            if (!HiveConf.isLoadHiveServer2Config()) {
                throw new IllegalStateException("Cannot get a query cache object while working outside of HS2, this is unexpected");
            }
            this.runtimeCache = new LlapObjectCache();
        }
        this.limitKey = this.getOperatorId() + "_record_count";
        AtomicInteger currentCountForAllTasks = this.getCurrentCount();
        int currentCountForAllTasksInt = currentCountForAllTasks.get();
        if (currentCountForAllTasksInt >= this.limit) {
            this.LOG.info("LimitOperator exits early as query limit already reached: {} >= {}", (Object)currentCountForAllTasksInt, (Object)this.limit);
            this.onLimitReached();
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        AtomicInteger currentCountForAllTasks = this.getCurrentCount();
        int currentCountForAllTasksInt = currentCountForAllTasks.get();
        if (this.offset <= this.currCount && this.currCount < this.offset + this.limit && this.offset <= currentCountForAllTasksInt && currentCountForAllTasksInt < this.offset + this.limit) {
            this.forward(row, this.inputObjInspectors[tag]);
            ++this.currCount;
            currentCountForAllTasks.incrementAndGet();
        } else if (this.offset > this.currCount) {
            ++this.currCount;
            currentCountForAllTasks.incrementAndGet();
        } else {
            this.onLimitReached();
        }
    }

    @Override
    public String getName() {
        return LimitOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "LIM";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.LIMIT;
    }

    protected void onLimitReached() {
        super.setDone(true);
        String limitReachedKey = LimitOperator.getLimitReachedKey(this.getConfiguration());
        try {
            this.runtimeCache.retrieve(limitReachedKey, new Callable<AtomicBoolean>(){

                @Override
                public AtomicBoolean call() {
                    return new AtomicBoolean(false);
                }
            }).set(true);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!this.isMap && this.currCount < this.leastRow) {
            throw new HiveException("No sufficient row found");
        }
        super.closeOp(abort);
    }

    public AtomicInteger getCurrentCount() {
        try {
            return this.runtimeCache.retrieve(this.limitKey, new Callable<AtomicInteger>(){

                @Override
                public AtomicInteger call() {
                    return new AtomicInteger();
                }
            });
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLimitReachedKey(Configuration conf) {
        return conf.get("hive.tez.vertex.name") + LIMIT_REACHED_KEY_SUFFIX;
    }

    public static boolean checkLimitReached(JobConf jobConf) {
        String queryId = HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        String limitReachedKey = LimitOperator.getLimitReachedKey((Configuration)jobConf);
        return LimitOperator.checkLimitReached(jobConf, queryId, limitReachedKey);
    }

    public static boolean checkLimitReachedForVertex(JobConf jobConf, String vertexName) {
        String queryId = HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        return LimitOperator.checkLimitReached(jobConf, queryId, vertexName + LIMIT_REACHED_KEY_SUFFIX);
    }

    private static boolean checkLimitReached(JobConf jobConf, String queryId, String limitReachedKey) {
        try {
            return ObjectCacheFactory.getCache((Configuration)jobConf, queryId, false, true).retrieve(limitReachedKey, new Callable<AtomicBoolean>(){

                @Override
                public AtomicBoolean call() {
                    return new AtomicBoolean(false);
                }
            }).get();
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }
}

