/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metadata;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplUtils {
    public static final String LAST_REPL_ID_KEY = "hive.repl.last.repl.id";
    public static final String FUNCTIONS_ROOT_DIR_NAME = "_functions";
    public static final String CONSTRAINTS_ROOT_DIR_NAME = "_constraints";
    public static final String INC_BOOTSTRAP_ROOT_DIR_NAME = "_bootstrap";
    public static final String REPL_HIVE_BASE_DIR = "hive";
    public static final String REPL_RANGER_BASE_DIR = "ranger";
    public static final String REPL_ATLAS_BASE_DIR = "atlas";
    public static final String REPL_ATLAS_EXPORT_FILE_NAME = "atlas_export.zip";
    public static final String DEFAULT_FS_CONFIG = "fs.defaultFS";
    public static final String REPL_TABLE_LIST_DIR_NAME = "_tables";
    public static final String REPL_DUMP_INCLUDE_ACID_TABLES = "hive.repl.dump.include.acid.tables";
    public static final String DFS_MAX_DIR_ITEMS_CONFIG = "dfs.namenode.fs-limits.max-directory-items";
    public static final int RESERVED_DIR_ITEMS_COUNT = 10;
    public static final String RANGER_AUTHORIZER = "ranger";
    public static final String HIVE_RANGER_POLICIES_FILE_NAME = "ranger_policies.json";
    public static final String RANGER_REST_URL = "ranger.plugin.hive.policy.rest.url";
    public static final String RANGER_HIVE_SERVICE_NAME = "ranger.plugin.hive.service.name";
    public static final String RANGER_CONFIGURATION_RESOURCE_NAME = "ranger-hive-security.xml";
    public static final String REPL_HIVE_SERVICE = "hive";
    public static final String REPL_RANGER_SERVICE = "ranger";
    public static final String REPL_ATLAS_SERVICE = "atlas";
    public static final String INC_EVENTS_BATCH = "events_batch_%d";
    public static final String DISTCP_JOB_ID_CONF = "distcp.job.id";
    public static final String DISTCP_JOB_ID_CONF_DEFAULT = "UNAVAILABLE";
    private static Logger LOG = LoggerFactory.getLogger(ReplUtils.class);

    public static Map<Integer, List<ExprNodeGenericFuncDesc>> genPartSpecs(Table table, List<Map<String, String>> partitions) throws SemanticException {
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        int partPrefixLength = 0;
        if (partitions.size() > 0) {
            partPrefixLength = partitions.get(0).size();
        }
        ArrayList<ExprNodeGenericFuncDesc> partitionDesc = new ArrayList<ExprNodeGenericFuncDesc>();
        for (Map<String, String> ptn : partitions) {
            ExprNodeGenericFuncDesc expr = null;
            for (Map.Entry<String, String> kvp : ptn.entrySet()) {
                String key = kvp.getKey();
                String val = kvp.getValue();
                String type = table.getPartColByName(key).getType();
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)pti, key, null, true);
                ExprNodeGenericFuncDesc op = PartitionUtils.makeBinaryPredicate("=", column, new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, val));
                expr = expr == null ? op : PartitionUtils.makeBinaryPredicate("and", expr, op);
            }
            if (expr == null) continue;
            partitionDesc.add(expr);
        }
        if (partitionDesc.size() > 0) {
            partSpecs.put(partPrefixLength, partitionDesc);
        }
        return partSpecs;
    }

    public static void unsetDbPropIfSet(Database db, String prop, Hive hiveDb) throws HiveException {
        if (db == null) {
            return;
        }
        Map dbProps = db.getParameters();
        if (dbProps == null || !dbProps.containsKey(prop)) {
            return;
        }
        LOG.info("Removing property: {} from database: {}", (Object)prop, (Object)db.getName());
        dbProps.remove(prop);
        hiveDb.alterDatabase(db.getName(), db);
    }

    public static Task<?> getTableReplLogTask(ImportTableDesc tableDesc, ReplLogger replLogger, HiveConf conf, ReplicationMetricCollector metricCollector, String dumpRoot) throws SemanticException {
        TableType tableType = tableDesc.isExternal() ? TableType.EXTERNAL_TABLE : tableDesc.tableType();
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, metricCollector, tableDesc.getTableName(), tableType, dumpRoot);
        return TaskFactory.get(replLogWork, conf);
    }

    public static Task<?> getTableCheckpointTask(ImportTableDesc tableDesc, HashMap<String, String> partSpec, String dumpRoot, ReplicationMetricCollector metricCollector, HiveConf conf) throws SemanticException {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put("hive.repl.ckpt.key", dumpRoot);
        TableName tName = TableName.fromString((String)tableDesc.getTableName(), null, (String)tableDesc.getDatabaseName());
        AlterTableSetPropertiesDesc alterTblDesc = new AlterTableSetPropertiesDesc(tName, partSpec, null, false, mapProp, false, false, null);
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterTblDesc, true, new Path(dumpRoot).getParent().toString(), metricCollector), conf);
    }

    public static boolean replCkptStatus(String dbName, Map<String, String> props, String dumpRoot) throws InvalidOperationException {
        if (props != null && props.containsKey("hive.repl.ckpt.key") && !props.get("hive.repl.ckpt.key").isEmpty()) {
            if (props.get("hive.repl.ckpt.key").equals(dumpRoot)) {
                return true;
            }
            throw new InvalidOperationException(ErrorMsg.REPL_BOOTSTRAP_LOAD_PATH_NOT_VALID.format(new String[]{dumpRoot, props.get("hive.repl.ckpt.key")}));
        }
        return false;
    }

    public static String getNonEmpty(String configParam, HiveConf hiveConf, String errorMsgFormat) throws SemanticException {
        String val = hiveConf.get(configParam);
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{String.format(errorMsgFormat, configParam), "atlas"}));
        }
        return val;
    }

    public static List<Task<?>> addChildTask(Task<?> childTask) {
        ArrayList taskList = new ArrayList();
        taskList.add(childTask);
        return taskList;
    }

    public static List<Task<?>> addTasksForLoadingColStats(ColumnStatistics colStats, HiveConf conf, UpdatedMetaDataTracker updatedMetadata, org.apache.hadoop.hive.metastore.api.Table tableObj, long writeId, String nonRecoverableMarkPath, ReplicationMetricCollector metricCollector) throws IOException, TException {
        ArrayList taskList = new ArrayList();
        ColumnStatsUpdateWork work = new ColumnStatsUpdateWork(colStats, nonRecoverableMarkPath, metricCollector, true);
        work.setWriteId(writeId);
        Task<ColumnStatsUpdateWork> task = TaskFactory.get(work, conf);
        taskList.add(task);
        return taskList;
    }

    public static PathFilter getEventsDirectoryFilter(FileSystem fs) {
        return p -> {
            try {
                return fs.isDirectory(p) && !p.getName().equalsIgnoreCase(INC_BOOTSTRAP_ROOT_DIR_NAME) && !p.getName().equalsIgnoreCase(REPL_TABLE_LIST_DIR_NAME) && !p.getName().equalsIgnoreCase("metadata");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static PathFilter getBootstrapDirectoryFilter(FileSystem fs) {
        return p -> {
            try {
                return fs.isDirectory(p) && !p.getName().equalsIgnoreCase(REPL_TABLE_LIST_DIR_NAME) && !p.getName().equalsIgnoreCase("metadata");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int handleException(boolean isReplication, Throwable e, String nonRecoverablePath, ReplicationMetricCollector metricCollector, String stageName, HiveConf conf) {
        int errorCode = isReplication && e instanceof SnapshotException ? ErrorMsg.getErrorMsg((String)"SNAPSHOT_ERROR").getErrorCode() : ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
        if (isReplication) {
            try {
                if (nonRecoverablePath != null) {
                    int recoverableLimit = ErrorMsg.GENERIC_ERROR.getErrorCode();
                    String metricStage = ReplUtils.getMetricStageName(stageName, metricCollector);
                    if (errorCode > recoverableLimit) {
                        Path nonRecoverableMarker = new Path(new Path(nonRecoverablePath), ReplAck.NON_RECOVERABLE_MARKER.toString());
                        Utils.writeStackTrace(e, nonRecoverableMarker, conf);
                        metricCollector.reportStageEnd(metricStage, Status.FAILED_ADMIN, nonRecoverableMarker.toString());
                    } else {
                        metricCollector.reportStageEnd(metricStage, Status.FAILED);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Failed to collect Metrics ", (Throwable)ex);
            }
        }
        return errorCode;
    }

    public static boolean shouldIgnoreOnError(DDLOperation<?> ddlOperation, Throwable e) {
        return ReplUtils.isCreateOperation(ddlOperation) && e.getMessage().contains("java.lang.NumberFormatException");
    }

    public static boolean isCreateOperation(DDLOperation<?> ddlOperation) {
        return ddlOperation instanceof CreateTableOperation;
    }

    private static String getMetricStageName(String stageName, ReplicationMetricCollector metricCollector) {
        if (stageName == "REPL_DUMP" || stageName == "REPL_LOAD" || stageName == "ATLAS_DUMP" || stageName == "ATLAS_LOAD" || stageName == "RANGER_DUMP" || stageName == "RANGER_LOAD" || stageName == "RANGER_DENY") {
            return stageName;
        }
        if (ReplUtils.isDumpMetricCollector(metricCollector)) {
            return "REPL_DUMP";
        }
        return "REPL_LOAD";
    }

    private static boolean isDumpMetricCollector(ReplicationMetricCollector metricCollector) {
        return metricCollector instanceof BootstrapDumpMetricCollector || metricCollector instanceof IncrementalDumpMetricCollector;
    }

    private static boolean isLoadMetricCollector(ReplicationMetricCollector metricCollector) {
        return metricCollector instanceof BootstrapLoadMetricCollector || metricCollector instanceof IncrementalLoadMetricCollector;
    }

    public static boolean isFirstIncPending(Map<String, String> parameters) {
        return parameters != null && "true".equalsIgnoreCase(parameters.get("hive.repl.first.inc.pending"));
    }

    public static List<Long> getOpenTxns(ValidTxnList validTxnList) {
        long[] invalidTxns = validTxnList.getInvalidTransactions();
        ArrayList<Long> openTxns = new ArrayList<Long>();
        for (long invalidTxn : invalidTxns) {
            if (validTxnList.isTxnAborted(invalidTxn)) continue;
            openTxns.add(invalidTxn);
        }
        return openTxns;
    }

    public static List<Long> getOpenTxns(HiveTxnManager hiveTxnManager, ValidTxnList validTxnList, String dbName) throws LockException {
        HiveLockManager lockManager = hiveTxnManager.getLockManager();
        long[] invalidTxns = validTxnList.getInvalidTransactions();
        ArrayList<Long> openTxns = new ArrayList<Long>();
        HashSet<Long> dbTxns = new HashSet<Long>();
        if (lockManager instanceof DbLockManager) {
            ShowLocksRequest request = new ShowLocksRequest();
            request.setDbname(dbName.toLowerCase());
            ShowLocksResponse showLocksResponse = ((DbLockManager)lockManager).getLocks(request);
            for (ShowLocksResponseElement showLocksResponseElement : showLocksResponse.getLocks()) {
                dbTxns.add(showLocksResponseElement.getTxnid());
            }
            for (Object invalidTxn : (Object)invalidTxns) {
                if (!dbTxns.contains((long)invalidTxn) || validTxnList.isTxnAborted((long)invalidTxn)) continue;
                openTxns.add((long)invalidTxn);
            }
        } else {
            for (long invalidTxn : invalidTxns) {
                if (validTxnList.isTxnAborted(invalidTxn)) continue;
                openTxns.add(invalidTxn);
            }
        }
        return openTxns;
    }

    public static MessageDeserializer getEventDeserializer(NotificationEvent event) {
        try {
            return MessageFactory.getInstance((String)event.getMessageFormat()).getDeserializer();
        }
        catch (Exception e) {
            String message = "could not create appropriate messageFactory for format " + event.getMessageFormat();
            LOG.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public static EnvironmentContext setReplDataLocationChangedFlag(EnvironmentContext envContext) {
        if (envContext == null) {
            envContext = new EnvironmentContext();
        }
        envContext.putToProperties("REPL_DATA_LOCATION_CHANGED", "true");
        return envContext;
    }

    public static boolean includeAcidTableInDump(HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)) {
            return conf.getBoolean(REPL_DUMP_INCLUDE_ACID_TABLES, true);
        }
        return true;
    }

    public static boolean tableIncludedInReplScope(ReplScope replScope, String tableName) {
        return replScope == null || replScope.tableIncludedInReplScope(tableName);
    }

    public static boolean failedWithNonRecoverableError(Path dumpRoot, HiveConf conf) throws SemanticException {
        if (dumpRoot == null) {
            return false;
        }
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).build();
        try {
            return retryable.executeCallable(() -> {
                FileSystem fs = dumpRoot.getFileSystem((Configuration)conf);
                if (fs.exists(new Path(dumpRoot, ReplAck.NON_RECOVERABLE_MARKER.toString()))) {
                    return true;
                }
                return false;
            });
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    public static Path getEncodedDumpRootPath(HiveConf conf, String dbname) throws UnsupportedEncodingException {
        return new Path(conf.getVar(HiveConf.ConfVars.REPL_DIR), Base64.getEncoder().encodeToString(dbname.getBytes(StandardCharsets.UTF_8.name())));
    }

    public static Path getLatestDumpPath(Path dumpRoot, HiveConf conf) throws IOException {
        FileStatus[] statuses;
        FileSystem fs = dumpRoot.getFileSystem((Configuration)conf);
        if (fs.exists(dumpRoot) && (statuses = fs.listStatus(dumpRoot)).length > 0) {
            FileStatus latestValidStatus = statuses[0];
            for (FileStatus status : statuses) {
                LOG.info("Evaluating previous dump dir path:{}", (Object)status.getPath());
                if (status.getModificationTime() <= latestValidStatus.getModificationTime()) continue;
                latestValidStatus = status;
            }
            return latestValidStatus.getPath();
        }
        return null;
    }

    public static String getDistCpCustomName(HiveConf conf, String dbName) {
        Object userChosenName = conf.get("mapreduce.job.name");
        if (StringUtils.isEmpty((CharSequence)userChosenName)) {
            String policyName = conf.get("scheduled.query.schedulename", "");
            if (policyName.isEmpty()) {
                userChosenName = "Repl#" + dbName;
            } else {
                String executionId = conf.get("scheduled.query.executionid", "");
                userChosenName = "Repl#" + policyName + "#" + executionId + "#" + dbName;
            }
            LOG.info("Using {} as job name for map-reduce jobs.", userChosenName);
        } else {
            LOG.info("Job Name is explicitly configured as {}, not using replication job custom name.", userChosenName);
        }
        return userChosenName;
    }

    public static String convertToHumanReadableTime(long time) {
        long seconds = time / 1000L;
        long minutes = seconds / 60L;
        return String.format("%d:%02d.%03ds", minutes, seconds % 60L, time % 1000L);
    }

    public static void addLoggerTask(ReplLogger replLogger, List<Task<?>> tasks, HiveConf conf) {
        String message = "Completed all external table copy tasks.";
        ReplStateLogWork replStateLogWork = new ReplStateLogWork(replLogger, message);
        Task<ReplStateLogWork> task = TaskFactory.get(replStateLogWork, conf);
        if (tasks.isEmpty()) {
            tasks.add(task);
        } else {
            DAGTraversal.traverse(tasks, new AddDependencyToLeaves(Collections.singletonList(task)));
        }
    }

    public static void reportStatusInReplicationMetrics(String stageName, Status status, String errorLogPath, HiveConf conf, String dbName, Metadata.ReplicationType replicationType) throws SemanticException {
        ReplicationMetricCollector metricCollector = new ReplicationMetricCollector(dbName, replicationType, null, 0L, conf){};
        metricCollector.reportStageStart(stageName, new HashMap<String, Long>());
        metricCollector.reportStageEnd(stageName, status, errorLogPath);
    }

    public static boolean isErrorRecoverable(Throwable e) {
        int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
        return errorCode > ErrorMsg.GENERIC_ERROR.getErrorCode();
    }

    public static boolean filterTransactionOperations(HiveConf conf) {
        return conf.getBoolVar(HiveConf.ConfVars.REPL_FILTER_TRANSACTIONS);
    }

    public static class TimeSerializer
    extends JsonSerializer<Long> {
        public void serialize(Long epoch, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(Instant.ofEpochSecond(epoch).toString());
        }
    }

    public static enum MetricName {
        TABLES,
        FUNCTIONS,
        EVENTS,
        POLICIES,
        ENTITIES;

    }

    public static enum ReplLoadOpType {
        LOAD_NEW,
        LOAD_SKIP,
        LOAD_REPLACE;

    }
}

