/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

@Description(name="sum", value="_FUNC_(expr) - Returns the sum value of expr (vectorized, type: <ValueType>)")
public class VectorUDAFSumTimestamp
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;

    public VectorUDAFSumTimestamp() {
    }

    public VectorUDAFSumTimestamp(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        this.init();
    }

    private void init() {
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputVector.getDouble(0), batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputVector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputVector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputVector.getDouble(0), batchSize, inputVector.isNull);
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputVector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputVector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputVector, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(inputVector.getDouble(selection[i]));
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(inputVector.getDouble(i));
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double value, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputVector, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            myagg.sumValue(inputVector.getDouble(i));
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(inputVector.getDouble(i));
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.sum = 0.0;
                }
                myagg.sum += inputVector.getDouble(0) * (double)batchSize;
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputVector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputVector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0.0;
            }
            myagg.sum += inputVector.getDouble(i);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputVector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.sum = 0.0;
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            myagg.sum += inputVector.getDouble(selected[i]);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            if (myagg.isNull) {
                myagg.sum = 0.0;
                myagg.isNull = false;
            }
            myagg.sum += inputVector.getDouble(i);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputVector, int batchSize) {
        if (myagg.isNull) {
            myagg.sum = 0.0;
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            myagg.sum += inputVector.getDouble(i);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((long)model.object(), (long)model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("sum") && inputColVectorType == ColumnVector.Type.TIMESTAMP && outputColVectorType == ColumnVector.Type.DOUBLE && (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        outputColVector.vector[batchIndex] = myagg.sum;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient boolean isNull = true;

        private Aggregation() {
        }

        public void sumValue(double value) {
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else {
                this.sum += value;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
        }
    }
}

