/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.CompileTimeCounters;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.tez.common.counters.TezCounters;

public class CompileTimeCounterPreHook
implements ExecuteWithHookContext {
    @Override
    public void run(HookContext hookContext) throws Exception {
        List<TezTask> rootTasks;
        int numTezJobs;
        assert (hookContext.getHookType() == HookContext.HookType.PRE_EXEC_HOOK);
        QueryPlan plan = hookContext.getQueryPlan();
        if (plan == null) {
            return;
        }
        int numMrJobs = Utilities.getMRTasks(plan.getRootTasks()).size();
        if (numMrJobs + (numTezJobs = (rootTasks = Utilities.getTezTasks(plan.getRootTasks())).size()) <= 0) {
            return;
        }
        for (TezTask tezTask : rootTasks) {
            TezCounters tezCounters = new TezCounters();
            String groupName = CompileTimeCounters.class.getName();
            long totalFileSize = 0L;
            long totalRawDataSize = 0L;
            for (TezTask currTask : Utilities.getTezTasks(plan.getRootTasks())) {
                TezWork work = (TezWork)currTask.getWork();
                for (BaseWork w : work.getAllWork()) {
                    for (Operator<? extends OperatorDesc> op : w.getAllRootOperators()) {
                        Set<TableScanOperator> tsOpSet = OperatorUtils.findOperators(op, TableScanOperator.class);
                        for (TableScanOperator sourceTsOp : tsOpSet) {
                            String vertexName = w.getName();
                            String counterName = Utilities.getVertexCounterName(CompileTimeCounters.TOTAL_FILE_SIZE.name(), vertexName);
                            totalFileSize += sourceTsOp.getStatistics().getTotalFileSize();
                            totalRawDataSize += sourceTsOp.getStatistics().getDataSize();
                            tezCounters.findCounter(groupName, counterName).increment(sourceTsOp.getStatistics().getTotalFileSize());
                            counterName = Utilities.getVertexCounterName(CompileTimeCounters.RAW_DATA_SIZE.name(), vertexName);
                            tezCounters.findCounter(groupName, counterName).increment(sourceTsOp.getStatistics().getDataSize());
                        }
                    }
                }
            }
            tezCounters.findCounter(groupName, CompileTimeCounters.TOTAL_FILE_SIZE.name()).increment(totalFileSize);
            tezCounters.findCounter(groupName, CompileTimeCounters.RAW_DATA_SIZE.name()).increment(totalRawDataSize);
            tezTask.setTezCounters(tezCounters);
        }
    }
}

