/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelJson;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelJsonImpl
extends RelJsonWriter {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRelJsonImpl.class);

    public HiveRelJsonImpl() {
        try {
            Field fieldRelJson = RelJsonWriter.class.getDeclaredField("relJson");
            fieldRelJson.setAccessible(true);
            fieldRelJson.set((Object)this, (Object)new HiveRelJson(this.jsonBuilder));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        super.explain_(rel, values);
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Map map = (Map)this.relList.get(this.relList.size() - 1);
        map.put("rowCount", mq.getRowCount(rel));
        if (rel.getInputs().size() == 0) {
            map.put("avgRowSize", mq.getAverageRowSize(rel));
            map.put("rowType", this.relJson.toJson((Object)rel.getRowType()));
            RelOptHiveTable table = (RelOptHiveTable)rel.getTable();
            List list = this.jsonBuilder.list();
            list.addAll(table.getHiveTableMD().getPartColNames());
            if (!list.isEmpty()) {
                map.put("partitionColumns", list);
            }
            List<ColStatistics> colStats = table.getColStat(ImmutableBitSet.range((int)0, (int)table.getNoOfNonVirtualCols()).asList(), true);
            list = this.jsonBuilder.list();
            for (ColStatistics cs : colStats) {
                Map csMap = this.jsonBuilder.map();
                csMap.put("name", cs.getColumnName());
                csMap.put("ndv", cs.getCountDistint());
                if (cs.getRange() != null) {
                    csMap.put("minValue", cs.getRange().minValue);
                    csMap.put("maxValue", cs.getRange().maxValue);
                }
                list.add(csMap);
            }
            if (!list.isEmpty()) {
                map.put("colStats", list);
            }
        }
    }
}

