/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdAllPredicates;
import org.apache.calcite.rel.metadata.RelMdExpressionLineage;
import org.apache.calcite.rel.metadata.RelMdNodeTypes;
import org.apache.calcite.rel.metadata.RelMdTableReferences;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewBoxing;

public class HiveMaterializationRelMetadataProvider {
    private static final RelMetadataProvider SOURCE_NODE_TYPES = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.NODE_TYPES.method, (MetadataHandler)new HiveRelMdNodeTypes());
    private static final RelMetadataProvider SOURCE_EXPRESSION_LINEAGE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.EXPRESSION_LINEAGE.method, (MetadataHandler)new HiveRelMdExpressionLineage());
    private static final RelMetadataProvider SOURCE_ALL_PREDICATES = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ALL_PREDICATES.method, (MetadataHandler)new HiveRelMdAllPredicates());
    private static final RelMetadataProvider SOURCE_TABLE_REFERENCES = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.TABLE_REFERENCES.method, (MetadataHandler)new HiveRelMdTableReferences());
    public static final JaninoRelMetadataProvider DEFAULT = JaninoRelMetadataProvider.of((RelMetadataProvider)ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)SOURCE_NODE_TYPES, (Object)SOURCE_EXPRESSION_LINEAGE, (Object)SOURCE_ALL_PREDICATES, (Object)SOURCE_TABLE_REFERENCES, (Object)JaninoRelMetadataProvider.DEFAULT)));

    private static class HiveRelMdNodeTypes
    extends RelMdNodeTypes {
        private HiveRelMdNodeTypes() {
        }

        public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelSubset rel, RelMetadataQuery mq) {
            for (RelNode node : rel.getRelList()) {
                if (!(node instanceof HiveMaterializedViewBoxing.Box)) continue;
                return mq.getNodeTypes(node);
            }
            return mq.getNodeTypes((RelNode)Util.first((Object)rel.getBest(), (Object)rel.getOriginal()));
        }
    }

    private static class HiveRelMdExpressionLineage
    extends RelMdExpressionLineage {
        private HiveRelMdExpressionLineage() {
        }

        public Set<RexNode> getExpressionLineage(RelSubset rel, RelMetadataQuery mq, RexNode outputExpression) {
            for (RelNode node : rel.getRelList()) {
                if (!(node instanceof HiveMaterializedViewBoxing.Box)) continue;
                return mq.getExpressionLineage(node, outputExpression);
            }
            return mq.getExpressionLineage((RelNode)Util.first((Object)rel.getBest(), (Object)rel.getOriginal()), outputExpression);
        }
    }

    private static class HiveRelMdAllPredicates
    extends RelMdAllPredicates {
        private HiveRelMdAllPredicates() {
        }

        public RelOptPredicateList getAllPredicates(RelSubset rel, RelMetadataQuery mq) {
            for (RelNode node : rel.getRelList()) {
                if (!(node instanceof HiveMaterializedViewBoxing.Box)) continue;
                return mq.getAllPredicates(node);
            }
            return mq.getAllPredicates((RelNode)Util.first((Object)rel.getBest(), (Object)rel.getOriginal()));
        }
    }

    private static class HiveRelMdTableReferences
    extends RelMdTableReferences {
        private HiveRelMdTableReferences() {
        }

        public Set<RexTableInputRef.RelTableRef> getTableReferences(RelSubset rel, RelMetadataQuery mq) {
            for (RelNode node : rel.getRelList()) {
                if (!(node instanceof HiveMaterializedViewBoxing.Box)) continue;
                return mq.getTableReferences(node);
            }
            return mq.getTableReferences((RelNode)Util.first((Object)rel.getBest(), (Object)rel.getOriginal()));
        }
    }
}

