/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.CopyOnWriteMergeRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.RewriterFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.SplitMergeRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class MergeRewriterFactory
implements RewriterFactory<MergeStatement> {
    private final Hive db;
    private final HiveConf conf;

    public MergeRewriterFactory(HiveConf conf) throws SemanticException {
        try {
            this.db = Hive.get(conf);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        this.conf = conf;
    }

    @Override
    public Rewriter<MergeStatement> createRewriter(Table table, String targetTableFullName, String subQueryAlias) throws SemanticException {
        boolean splitUpdate = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.SPLIT_UPDATE);
        boolean copyOnWriteMode = false;
        HiveStorageHandler storageHandler = table.getStorageHandler();
        if (storageHandler != null) {
            copyOnWriteMode = storageHandler.shouldOverwrite(table, Context.Operation.MERGE);
        }
        SqlGeneratorFactory sqlGeneratorFactory = new SqlGeneratorFactory(table, targetTableFullName, this.conf, !copyOnWriteMode ? subQueryAlias : null, copyOnWriteMode ? "t__" : "");
        if (copyOnWriteMode) {
            return new CopyOnWriteMergeRewriter(this.db, this.conf, sqlGeneratorFactory);
        }
        if (splitUpdate) {
            return new SplitMergeRewriter(this.db, this.conf, sqlGeneratorFactory);
        }
        if (AcidUtils.isNonNativeAcidTable(table)) {
            throw new SemanticException(ErrorMsg.NON_NATIVE_ACID_UPDATE.getErrorCodedMsg());
        }
        return new MergeRewriter(this.db, this.conf, sqlGeneratorFactory);
    }
}

