/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.lang.reflect.Method;
import javax.jdo.AttributeConverter;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class JDOTypeConverterUtils {
    public static Class getAttributeTypeForAttributeConverter(Class<? extends AttributeConverter> converterCls, Class attrTypeFallback) {
        Class<?> attrType = attrTypeFallback;
        Method[] methods = converterCls.getMethods();
        if (methods != null) {
            for (int j = 0; j < methods.length; ++j) {
                Class<?> returnCls;
                if (!methods[j].getName().equals("convertToAttribute") || (returnCls = methods[j].getReturnType()) == Object.class) continue;
                attrType = returnCls;
                break;
            }
        }
        return attrType;
    }

    public static Class getDatastoreTypeForAttributeConverter(Class<? extends AttributeConverter> converterCls, Class attrType, Class dbTypeFallback) {
        Class<?> dbType = dbTypeFallback;
        try {
            Class<?> returnCls = converterCls.getMethod("convertToDatastore", attrType).getReturnType();
            if (returnCls != Object.class) {
                dbType = returnCls;
            }
        }
        catch (Exception e) {
            NucleusLogger.GENERAL.error((Object)"Exception in lookup", (Throwable)e);
        }
        return dbType;
    }

    public static AttributeConverter createAttributeConverter(NucleusContext nucCtx, Class<? extends AttributeConverter> converterCls) {
        PersistenceNucleusContext ctx;
        if (nucCtx != null && nucCtx instanceof PersistenceNucleusContext && (ctx = (PersistenceNucleusContext)nucCtx).getCDIHandler() != null) {
            try {
                return (AttributeConverter)ctx.getCDIHandler().createObjectWithInjectedDependencies(converterCls);
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn((Object)("Error creating AttributeConverter of type " + converterCls.getName() + " using CDI BeanHandler"), (Throwable)e);
            }
        }
        return (AttributeConverter)ClassUtils.newInstance(converterCls, null, null);
    }
}

