/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import com.google.common.base.Strings;
import java.util.List;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupSearchFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(Configuration conf) {
        String userSearchFilter = conf.get(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERSEARCHFILTER.getVarname());
        String userSearchBaseDN = conf.get(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_BASEDN.getVarname());
        String groupSearchFilter = conf.get(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPSEARCHFILTER.getVarname());
        String groupSearchBaseDN = conf.get(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPBASEDN.getVarname());
        if (Strings.isNullOrEmpty((String)userSearchFilter) && Strings.isNullOrEmpty((String)groupSearchFilter) && Strings.isNullOrEmpty((String)groupSearchBaseDN)) {
            return null;
        }
        return new UserGroupSearchFilter(userSearchFilter, userSearchBaseDN, groupSearchFilter, groupSearchBaseDN);
    }

    private static final class UserGroupSearchFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(UserGroupSearchFilter.class);
        private final String userSearchFilter;
        private final String userBaseDN;
        private final String groupSearchFilter;
        private final String groupBaseDN;

        UserGroupSearchFilter(String userSearchFilter, String userBaseDN, String groupSearchFilter, String groupBaseDN) {
            this.userSearchFilter = userSearchFilter;
            this.userBaseDN = userBaseDN;
            this.groupSearchFilter = groupSearchFilter;
            this.groupBaseDN = groupBaseDN;
        }

        @Override
        public void apply(DirSearch client, String user) throws AuthenticationException {
            String userDn = null;
            try {
                List<String> resultList;
                if (!Strings.isNullOrEmpty((String)this.userSearchFilter) && !Strings.isNullOrEmpty((String)this.userBaseDN) && (userDn = client.findUserDn(user, this.userSearchFilter, this.userBaseDN)) == null) {
                    throw new AuthenticationException("Authentication failed: User search found no matching user");
                }
                if (!Strings.isNullOrEmpty((String)this.groupSearchFilter) && !Strings.isNullOrEmpty((String)this.groupBaseDN) ? (resultList = client.executeUserAndGroupFilterQuery(user, userDn, this.groupSearchFilter, this.groupBaseDN)) != null && resultList.size() > 0 : userDn != null) {
                    return;
                }
                throw new AuthenticationException("Authentication failed: User search does not satisfy filter condition");
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
        }
    }
}

