/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNextNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNextNodeGen;
import com.oracle.truffle.js.runtime.interop.JSIteratorWrapper;
import java.lang.invoke.VarHandle;

@GeneratedBy(value=JSIteratorWrapper.class)
final class JSIteratorWrapperGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JSIteratorWrapperGen() {
    }

    static {
        LibraryExport.register(JSIteratorWrapper.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSIteratorWrapper.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet(INTEROP_LIBRARY_, (String[])new String[]{"isIterator", "hasIteratorNextElement", "getIteratorNextElement"});

        private InteropLibraryExports() {
            super(InteropLibrary.class, JSIteratorWrapper.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSIteratorWrapper);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Uncached());
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSIteratorWrapper);
            return (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=JSIteratorWrapper.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JSIteratorWrapper)receiver_).iterator;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSIteratorWrapper) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSIteratorWrapper;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isIterator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSIteratorWrapper)receiver).isIterator();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasIteratorNextElement(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                return arg0Value.hasIteratorNextElement((InteropLibrary)this.getParent(), JSInteropGetIteratorNextNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object getIteratorNextElement(Object arg0Value_) throws StopIterationException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                return arg0Value.getIteratorNextElement((InteropLibrary)this.getParent(), JSInteropGetIteratorNextNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=JSIteratorWrapper.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverIteratorInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private JSInteropGetIteratorNextNode getIteratorNext;

            protected Cached(Object receiver) {
                JSIteratorWrapper castReceiver = (JSIteratorWrapper)receiver;
                this.receiverIteratorInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver.iterator)));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JSIteratorWrapper)receiver_).iterator;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverIteratorInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSIteratorWrapper) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof JSIteratorWrapper)) {
                    return false;
                }
                return this.receiverIteratorInteropLibrary_.accepts((Object)((JSIteratorWrapper)receiver).iterator);
            }

            public boolean isIterator(Object receiver) {
                assert (receiver instanceof JSIteratorWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSIteratorWrapper)receiver).isIterator();
            }

            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                JSInteropGetIteratorNextNode getIteratorNext_;
                assert (arg0Value_ instanceof JSIteratorWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (getIteratorNext_ = this.getIteratorNext) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    return arg0Value.hasIteratorNextElement(self__, getIteratorNext_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNextElementNode_AndSpecialize(JSIteratorWrapper arg0Value) {
                JSInteropGetIteratorNextNode getIteratorNext_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                self__ = (InteropLibrary)this.getParent();
                JSInteropGetIteratorNextNode getIteratorNext__shared = this.getIteratorNext;
                if (getIteratorNext__shared != null) {
                    getIteratorNext_ = getIteratorNext__shared;
                } else {
                    getIteratorNext_ = (JSInteropGetIteratorNextNode)this.insert(JSInteropGetIteratorNextNodeGen.create());
                    if (getIteratorNext_ == null) {
                        throw new IllegalStateException("Specialization 'hasIteratorNextElement(JSIteratorWrapper, InteropLibrary, JSInteropGetIteratorNextNode)' contains a shared cache with name 'iteratorNextNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getIteratorNext == null) {
                    VarHandle.storeStoreFence();
                    this.getIteratorNext = getIteratorNext_;
                }
                this.state_0_ = state_0 |= 1;
                return arg0Value.hasIteratorNextElement(self__, getIteratorNext_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                JSInteropGetIteratorNextNode getIteratorNext_;
                assert (arg0Value_ instanceof JSIteratorWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (getIteratorNext_ = this.getIteratorNext) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    return arg0Value.getIteratorNextElement(self__, getIteratorNext_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNextElementNode_AndSpecialize(JSIteratorWrapper arg0Value) throws StopIterationException {
                JSInteropGetIteratorNextNode getIteratorNext_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                self__ = (InteropLibrary)this.getParent();
                JSInteropGetIteratorNextNode getIteratorNext__shared = this.getIteratorNext;
                if (getIteratorNext__shared != null) {
                    getIteratorNext_ = getIteratorNext__shared;
                } else {
                    getIteratorNext_ = (JSInteropGetIteratorNextNode)this.insert(JSInteropGetIteratorNextNodeGen.create());
                    if (getIteratorNext_ == null) {
                        throw new IllegalStateException("Specialization 'getIteratorNextElement(JSIteratorWrapper, InteropLibrary, JSInteropGetIteratorNextNode)' contains a shared cache with name 'iteratorNextNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getIteratorNext == null) {
                    VarHandle.storeStoreFence();
                    this.getIteratorNext = getIteratorNext_;
                }
                this.state_0_ = state_0 |= 2;
                return arg0Value.getIteratorNextElement(self__, getIteratorNext_);
            }
        }
    }
}

