/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.BaseBuffer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.internal.BaseStateImpl;

public abstract class BaseBufferImpl
extends BaseStateImpl
implements BaseBuffer {
    private long capacity;
    private long start = 0L;
    private long pos = 0L;
    private long end;

    BaseBufferImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
        this.capacity = this.end = capacityBytes;
    }

    @Override
    public final BaseBufferImpl incrementPosition(long increment) {
        this.incrementAndAssertPositionForRead(this.pos, increment);
        return this;
    }

    @Override
    public final BaseBufferImpl incrementAndCheckPosition(long increment) {
        this.incrementAndCheckPositionForRead(this.pos, increment);
        return this;
    }

    @Override
    public final long getEnd() {
        return this.end;
    }

    @Override
    public final long getPosition() {
        return this.pos;
    }

    @Override
    public final long getStart() {
        return this.start;
    }

    @Override
    public final long getRemaining() {
        return this.end - this.pos;
    }

    @Override
    public final boolean hasRemaining() {
        return this.end - this.pos > 0L;
    }

    @Override
    public final BaseBufferImpl resetPosition() {
        this.pos = this.start;
        return this;
    }

    @Override
    public final BaseBufferImpl setPosition(long position) {
        BaseBufferImpl.assertInvariants(this.start, position, this.end, this.capacity);
        this.pos = position;
        return this;
    }

    @Override
    public final BaseBufferImpl setAndCheckPosition(long position) {
        BaseBufferImpl.checkInvariants(this.start, position, this.end, this.capacity);
        this.pos = position;
        return this;
    }

    @Override
    public final BaseBufferImpl setStartPositionEnd(long start, long position, long end) {
        BaseBufferImpl.assertInvariants(start, position, end, this.capacity);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    @Override
    public final BaseBufferImpl setAndCheckStartPositionEnd(long start, long position, long end) {
        BaseBufferImpl.checkInvariants(start, position, end, this.capacity);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    final void incrementAndAssertPositionForRead(long position, long increment) {
        this.assertValid();
        long newPos = position + increment;
        BaseBufferImpl.assertInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void incrementAndAssertPositionForWrite(long position, long increment) {
        this.assertValid();
        assert (!this.isReadOnly()) : "BufferImpl is read-only.";
        long newPos = position + increment;
        BaseBufferImpl.assertInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void incrementAndCheckPositionForRead(long position, long increment) {
        this.checkValid();
        long newPos = position + increment;
        BaseBufferImpl.checkInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void incrementAndCheckPositionForWrite(long position, long increment) {
        this.checkValidForWrite();
        long newPos = position + increment;
        BaseBufferImpl.checkInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
    }

    final void checkValidForWrite() {
        this.checkValid();
        if (this.isReadOnly()) {
            throw new ReadOnlyException("BufferImpl is read-only.");
        }
    }

    static final void assertInvariants(long start, long pos, long end, long cap) {
        assert ((start | pos | end | cap | pos - start | end - pos | cap - end) >= 0L) : "Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end);
    }

    static final void checkInvariants(long start, long pos, long end, long cap) {
        if ((start | pos | end | cap | pos - start | end - pos | cap - end) < 0L) {
            throw new IllegalArgumentException("Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end));
        }
    }
}

