/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.schema.table.SurrogateColumnType;

public class StatementClassMapping {
    String className;
    String memberName;
    String dnTypeColumn;
    int[] memberNumbers;
    Map<Integer, StatementMappingIndex> mappings = new HashMap<Integer, StatementMappingIndex>();
    Map<Integer, StatementClassMapping> children;

    public StatementClassMapping() {
        this(null, null);
    }

    public StatementClassMapping(String className, String memberName) {
        this.className = className;
        this.memberName = memberName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setNucleusTypeColumnName(String colName) {
        this.dnTypeColumn = colName;
    }

    public String getNucleusTypeColumnName() {
        return this.dnTypeColumn;
    }

    public StatementMappingIndex getMappingForMemberPosition(int position) {
        return this.mappings.get(position);
    }

    public StatementClassMapping getMappingDefinitionForMemberPosition(int position) {
        return this.children != null ? this.children.get(position) : null;
    }

    public boolean hasChildMappingDefinitions() {
        return this.children != null && this.children.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMemberNumbers() {
        if (this.memberNumbers != null) {
            return this.memberNumbers;
        }
        StatementClassMapping statementClassMapping = this;
        synchronized (statementClassMapping) {
            int length = this.mappings.size();
            if (this.mappings.containsKey(SurrogateColumnType.DATASTORE_ID.getFieldNumber())) {
                --length;
            }
            if (this.mappings.containsKey(SurrogateColumnType.VERSION.getFieldNumber())) {
                --length;
            }
            if (this.mappings.containsKey(SurrogateColumnType.DISCRIMINATOR.getFieldNumber())) {
                --length;
            }
            if (this.mappings.containsKey(SurrogateColumnType.MULTITENANCY.getFieldNumber())) {
                --length;
            }
            if (this.mappings.containsKey(SurrogateColumnType.SOFTDELETE.getFieldNumber())) {
                --length;
            }
            int[] positions = new int[length];
            Iterator<Integer> iter = this.mappings.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Integer val = iter.next();
                if (val < 0) continue;
                positions[i++] = val;
            }
            this.memberNumbers = positions;
            return positions;
        }
    }

    public void addMappingForMember(int position, StatementMappingIndex mapping) {
        this.memberNumbers = null;
        this.mappings.put(position, mapping);
    }

    public void addMappingDefinitionForMember(int position, StatementClassMapping defn) {
        this.memberNumbers = null;
        if (this.children == null) {
            this.children = new HashMap<Integer, StatementClassMapping>();
        }
        this.children.put(position, defn);
    }

    public StatementClassMapping cloneStatementMappingWithoutChildren() {
        StatementClassMapping mapping = new StatementClassMapping(this.className, this.memberName);
        mapping.dnTypeColumn = this.dnTypeColumn;
        for (Map.Entry<Integer, StatementMappingIndex> entry : this.mappings.entrySet()) {
            Integer key = entry.getKey();
            StatementMappingIndex value = entry.getValue();
            mapping.addMappingForMember(key, value);
        }
        return mapping;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("StatementClassMapping:");
        str.append("class=" + this.className + ",member=" + this.memberName);
        str.append(",mappings=[");
        Iterator<Map.Entry<Integer, StatementMappingIndex>> mapIter = this.mappings.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry<Integer, StatementMappingIndex> entry = mapIter.next();
            str.append("{field=").append(entry.getKey());
            str.append(",mapping=").append(entry.getValue());
            str.append("}");
            if (!mapIter.hasNext() && this.children == null) continue;
            str.append(",");
        }
        str.append("]");
        if (this.children != null) {
            str.append(",children=[");
            Iterator<Map.Entry<Integer, StatementClassMapping>> childIter = this.children.entrySet().iterator();
            while (childIter.hasNext()) {
                Map.Entry<Integer, StatementClassMapping> entry = childIter.next();
                str.append("{field=").append(entry.getKey());
                str.append(",mapping=").append(entry.getValue());
                str.append("}");
                if (!childIter.hasNext()) continue;
                str.append(",");
            }
            str.append("]");
        }
        if (this.dnTypeColumn != null) {
            str.append(",nucleusTypeColumn=" + this.dnTypeColumn);
        }
        return str.toString();
    }
}

