/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.encryption.NativeFileCryptoParameters;
import org.apache.iceberg.encryption.NativelyEncryptedFile;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopStreams;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;

public class HadoopOutputFile
implements OutputFile,
NativelyEncryptedFile {
    private final FileSystem fs;
    private final Path path;
    private final Configuration conf;
    private NativeFileCryptoParameters nativeEncryptionParameters;

    public static OutputFile fromLocation(CharSequence location, Configuration conf) {
        Path path = new Path(location.toString());
        return HadoopOutputFile.fromPath(path, conf);
    }

    public static OutputFile fromLocation(CharSequence location, FileSystem fs) {
        Path path = new Path(location.toString());
        return HadoopOutputFile.fromPath(path, fs);
    }

    public static OutputFile fromPath(Path path, Configuration conf) {
        FileSystem fs = Util.getFs(path, conf);
        return HadoopOutputFile.fromPath(path, fs, conf);
    }

    public static OutputFile fromPath(Path path, FileSystem fs) {
        return HadoopOutputFile.fromPath(path, fs, fs.getConf());
    }

    public static OutputFile fromPath(Path path, FileSystem fs, Configuration conf) {
        return new HadoopOutputFile(fs, path, conf);
    }

    private HadoopOutputFile(FileSystem fs, Path path, Configuration conf) {
        this.fs = fs;
        this.path = path;
        this.conf = conf;
    }

    @Override
    public PositionOutputStream create() {
        try {
            return HadoopStreams.wrap(this.fs.create(this.path, false));
        }
        catch (FileAlreadyExistsException e) {
            throw new AlreadyExistsException(e, "Path already exists: %s", this.path);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create file: %s", this.path);
        }
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        try {
            return HadoopStreams.wrap(this.fs.create(this.path, true));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create file: %s", this.path);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public String location() {
        return this.path.toString();
    }

    @Override
    public InputFile toInputFile() {
        return HadoopInputFile.fromPath(this.path, this.fs, this.conf);
    }

    public String toString() {
        return this.location();
    }

    @Override
    public NativeFileCryptoParameters nativeCryptoParameters() {
        return this.nativeEncryptionParameters;
    }

    @Override
    public void setNativeCryptoParameters(NativeFileCryptoParameters nativeCryptoParameters) {
        this.nativeEncryptionParameters = nativeCryptoParameters;
    }
}

