/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.create.like.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.AlterTableExecuteSpec;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.plan.CustomBucketFunction;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.MergeTaskProperties;
import org.apache.hadoop.hive.ql.plan.PartitionAwareOptimizationCtx;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FindFiles;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.PartitionStats;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.data.PartitionStatsHandler;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.mr.hive.HiveTableUtil;
import org.apache.iceberg.mr.hive.IcebergMergeTaskProperties;
import org.apache.iceberg.mr.hive.IcebergMetadataTables;
import org.apache.iceberg.mr.hive.IcebergSnapshotRefExec;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.IcebergTransformSortFunctionUtil;
import org.apache.iceberg.mr.hive.actions.HiveIcebergDeleteOrphanFiles;
import org.apache.iceberg.mr.hive.plan.IcebergBucketFunction;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.puffin.PuffinReader;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.SerializationUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergStorageHandler.class);
    private static final String ICEBERG_URI_PREFIX = "iceberg://";
    private static final Splitter TABLE_NAME_SPLITTER = Splitter.on("..");
    private static final String TABLE_NAME_SEPARATOR = "..";
    public static final String COPY_ON_WRITE = "copy-on-write";
    public static final String MERGE_ON_READ = "merge-on-read";
    public static final String STATS = "/stats/snap-";
    public static final String TABLE_DEFAULT_LOCATION = "TABLE_DEFAULT_LOCATION";
    private static final List<VirtualColumn> ACID_VIRTUAL_COLS = ImmutableList.of(VirtualColumn.PARTITION_SPEC_ID, VirtualColumn.PARTITION_HASH, VirtualColumn.FILE_PATH, VirtualColumn.ROW_POSITION, VirtualColumn.PARTITION_PROJECTION);
    private static final List<FieldSchema> ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA = HiveIcebergStorageHandler.schema(ACID_VIRTUAL_COLS);
    private static final List<FieldSchema> POSITION_DELETE_ORDERING = HiveIcebergStorageHandler.orderBy(VirtualColumn.PARTITION_SPEC_ID, VirtualColumn.PARTITION_HASH, VirtualColumn.FILE_PATH, VirtualColumn.ROW_POSITION);
    private static final List<FieldSchema> EMPTY_ORDERING = ImmutableList.of();
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveIcebergInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveIcebergOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HiveIcebergSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new HiveIcebergMetaHook(this.conf);
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
        this.fallbackToNonVectorizedModeBasedOnProperties(tableDesc.getProperties());
        boolean allowDataFilesWithinTableLocationOnly = this.conf.getBoolean(HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.varname, HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.defaultBoolVal);
        map.put(HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.varname, String.valueOf(allowDataFilesWithinTableLocationOnly));
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
        this.fallbackToNonVectorizedModeBasedOnProperties(tableDesc.getProperties());
        map.put("mapred.output.committer.class", HiveIcebergNoJobCommitter.class.getName());
        String opType = this.getOperationType();
        map.put("iceberg.mr.operation.type." + tableDesc.getTableName(), opType);
        tableDesc.getProperties().put("iceberg.mr.operation.type." + tableDesc.getTableName(), opType);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        this.setCommonJobConf(jobConf);
        if (tableDesc != null && tableDesc.getProperties() != null && tableDesc.getProperties().get("iceberg.mr.operation.type." + tableDesc.getTableName()) != null) {
            String tables;
            boolean isMergeTaskEnabled;
            String tableName = tableDesc.getTableName();
            String opKey = "iceberg.mr.operation.type." + tableName;
            jobConf.set(opKey, tableDesc.getProperties().getProperty(opKey));
            Preconditions.checkArgument(!tableName.contains(TABLE_NAME_SEPARATOR), "Can not handle table " + tableName + ". Its name contains '..'");
            if (HiveCustomStorageHandlerUtils.getWriteOperation(tableDesc.getProperties()::getProperty, (String)tableName) != null) {
                HiveCustomStorageHandlerUtils.setWriteOperation((Configuration)jobConf, (String)tableName, (Context.Operation)Context.Operation.valueOf((String)tableDesc.getProperties().getProperty("file.sink.write.operation." + tableName)));
            }
            if (isMergeTaskEnabled = Boolean.parseBoolean(tableDesc.getProperty("file.sink.merge.task.enabled." + tableName))) {
                HiveCustomStorageHandlerUtils.setMergeTaskEnabled((Configuration)jobConf, (String)tableName, (boolean)true);
            }
            tables = (tables = jobConf.get("iceberg.mr.output.tables")) == null ? tableName : tables + TABLE_NAME_SEPARATOR + tableName;
            jobConf.set("iceberg.mr.output.tables", tables);
            String catalogName = tableDesc.getProperties().getProperty("iceberg.catalog");
            if (catalogName != null) {
                jobConf.set("iceberg.mr.table.catalog." + tableName, catalogName);
            }
        }
        try {
            if (!jobConf.getBoolean(HiveConf.ConfVars.HIVE_IN_TEST_IDE.varname, false)) {
                Utilities.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HiveIcebergStorageHandler.class});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean directInsert() {
        return true;
    }

    public boolean supportsPartitioning() {
        return true;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc exprNodeDesc) {
        Set skipList;
        HiveStoragePredicateHandler.DecomposedPredicate predicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        predicate.residualPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        ExprNodeDesc pushedPredicate = exprNodeDesc.clone();
        List subExprNodes = pushedPredicate.getChildren();
        if (subExprNodes.removeIf(arg_0 -> HiveIcebergStorageHandler.lambda$decomposePredicate$0(skipList = Stream.of(VirtualColumn.FILE_PATH, VirtualColumn.PARTITION_SPEC_ID, VirtualColumn.PARTITION_HASH).map(VirtualColumn::getName).collect(Collectors.toSet()), arg_0))) {
            if (subExprNodes.size() == 1) {
                pushedPredicate = subExprNodes.get(0) instanceof ExprNodeGenericFuncDesc ? (ExprNodeDesc)subExprNodes.get(0) : null;
            } else if (subExprNodes.isEmpty()) {
                pushedPredicate = null;
            }
        }
        predicate.pushedPredicate = (ExprNodeGenericFuncDesc)pushedPredicate;
        if (pushedPredicate != null) {
            SessionStateUtil.setConflictDetectionFilter((Configuration)this.conf, (String)jobConf.get("name"), (ExprNodeDesc)pushedPredicate);
        }
        return predicate;
    }

    public boolean canProvideBasicStatistics() {
        return true;
    }

    public boolean canProvidePartitionStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        if (!this.getStatsSource().equals("ICEBERG")) {
            return false;
        }
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        if (snapshot != null) {
            return IcebergTableUtil.getPartitionStatsFile(table, snapshot.snapshotId()) != null;
        }
        return false;
    }

    public StorageFormatDescriptor getStorageFormatDescriptor(org.apache.hadoop.hive.metastore.api.Table table) throws SemanticException {
        if (table.getParameters() != null) {
            String format = table.getParameters().getOrDefault("write.format.default", "PARQUET");
            return StorageFormat.getDescriptor((String)format, (String)"write.format.default");
        }
        return null;
    }

    public boolean supportsAppendData(org.apache.hadoop.hive.metastore.api.Table table, boolean withPartClause) throws SemanticException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, table);
        if (icebergTbl.spec().isUnpartitioned()) {
            return true;
        }
        if (this.hasUndergonePartitionEvolution(icebergTbl)) {
            if (withPartClause) {
                throw new SemanticException("Can not Load into an iceberg table, which has undergone partition evolution using the PARTITION clause");
            }
            return false;
        }
        return withPartClause;
    }

    public void appendFiles(org.apache.hadoop.hive.metastore.api.Table table, URI fromURI, boolean isOverwrite, Map<String, String> partitionSpec) throws SemanticException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, table);
        String format = (String)table.getParameters().get("write.format.default");
        HiveTableUtil.appendFiles(fromURI, format, icebergTbl, isOverwrite, partitionSpec, this.conf);
    }

    public Map<String, String> getBasicStatistics(Partish partish) {
        return this.getBasicStatistics(partish, false);
    }

    private Map<String, String> getBasicStatistics(Partish partish, boolean quickStats) {
        HashMap<String, String> stats = Maps.newHashMap();
        org.apache.hadoop.hive.ql.metadata.Table hmsTable = partish.getTable();
        Table table = this.getTable(hmsTable);
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        if (snapshot == null) {
            stats.put("numFiles", "0");
            stats.put("numRows", "0");
            stats.put("totalSize", "0");
        } else if (!"ICEBERG".equals(this.getStatsSource()) && !quickStats) {
            stats = partish.getPartParameters();
        } else {
            Map<String, String> summary = HiveIcebergStorageHandler.getPartishSummary(partish, table, snapshot);
            if (summary != null) {
                if (summary.containsKey("total-data-files")) {
                    stats.put("numFiles", summary.get("total-data-files"));
                }
                if (summary.containsKey("total-records") && !quickStats) {
                    long totalRecords = Long.parseLong(summary.get("total-records"));
                    if (summary.containsKey("total-equality-deletes") && summary.containsKey("total-position-deletes")) {
                        long totalEqDeletes = Long.parseLong(summary.get("total-equality-deletes"));
                        long totalPosDeletes = Long.parseLong(summary.get("total-position-deletes"));
                        long actualRecords = totalRecords - (totalEqDeletes > 0L ? 0L : totalPosDeletes);
                        totalRecords = actualRecords > 0L ? actualRecords : totalRecords;
                    }
                    stats.put("numRows", String.valueOf(totalRecords));
                }
                if (summary.containsKey("total-files-size")) {
                    stats.put("totalSize", summary.get("total-files-size"));
                }
            }
        }
        return stats;
    }

    public Map<String, String> computeBasicStatistics(Partish partish) {
        PartitionStatisticsFile statsFile;
        if (!this.getStatsSource().equals("ICEBERG")) {
            Map<String, String> stats = partish.getPartParameters();
            if (!StatsSetupConst.areBasicStatsUptoDate((Map)stats)) {
                stats = this.getBasicStatistics(partish, true);
            }
            return stats;
        }
        org.apache.hadoop.hive.ql.metadata.Table hmsTable = partish.getTable();
        Table table = this.getTable(hmsTable);
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        if (snapshot != null && table.spec().isPartitioned() && (statsFile = IcebergTableUtil.getPartitionStatsFile(table, snapshot.snapshotId())) == null) {
            try {
                statsFile = PartitionStatsHandler.computeAndWriteStatsFile(table);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            table.updatePartitionStatistics().setPartitionStatistics(statsFile).commit();
        }
        return this.getBasicStatistics(partish);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getPartishSummary(Partish partish, Table table, Snapshot snapshot) {
        if (partish.getPartition() == null) return snapshot.summary();
        PartitionStatisticsFile statsFile = IcebergTableUtil.getPartitionStatsFile(table, snapshot.snapshotId());
        if (statsFile == null) {
            LOG.warn("Partition stats file not found for snapshot: {}", (Object)snapshot.snapshotId());
            return null;
        }
        Types.StructType partitionType = Partitioning.partitionType(table);
        Schema schema = PartitionStatsHandler.schema(partitionType);
        CloseableIterable<PartitionStats> partitionStatsRecords = PartitionStatsHandler.readPartitionStatsFile(schema, table.io().newInputFile(statsFile.path()));
        try (CloseableIterable<PartitionStats> toClose = partitionStatsRecords;){
            PartitionStats partitionStats = Iterables.tryFind(partitionStatsRecords, stats -> {
                PartitionSpec spec = table.specs().get(stats.specId());
                PartitionData data = IcebergTableUtil.toPartitionData(stats.partition(), partitionType, spec.partitionType());
                return spec.partitionToPath(data).equals(partish.getPartition().getName());
            }).orNull();
            if (partitionStats != null) {
                ImmutableMap<String, String> stats2;
                ImmutableMap<String, String> immutableMap = stats2 = ImmutableMap.of("total-data-files", String.valueOf(partitionStats.dataFileCount()), "total-records", String.valueOf(partitionStats.dataRecordCount()), "total-equality-deletes", String.valueOf(partitionStats.equalityDeleteRecordCount()), "total-position-deletes", String.valueOf(partitionStats.positionDeleteRecordCount()), "total-files-size", String.valueOf(partitionStats.totalDataFileSizeInBytes()));
                return immutableMap;
            }
            LOG.warn("Partition {} not found in stats file: {}", (Object)partish.getPartition().getName(), (Object)statsFile.path());
            Map<String, String> map = null;
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Table getTable(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        boolean skipCache = SessionStateUtil.getQueryState((Configuration)this.conf).map(queryState -> queryState.getNumModifiedRows() > 0L).orElse(true);
        return IcebergTableUtil.getTable(this.conf, hmsTable.getTTable(), skipCache);
    }

    public boolean canSetColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        return "ICEBERG".equals(this.getStatsSource());
    }

    public boolean setColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable, List<ColumnStatistics> colStats) {
        Table tbl = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return this.writeColStats(colStats, tbl);
    }

    private boolean writeColStats(List<ColumnStatistics> colStats, Table tbl) {
        try {
            GenericStatisticsFile statisticsFile;
            if (!this.shouldRewriteColStats(tbl)) {
                this.checkAndMergeColStats(colStats, tbl);
            }
            String statsPath = tbl.location() + STATS + UUID.randomUUID();
            try (PuffinWriter puffinWriter = Puffin.write(tbl.io().newOutputFile(statsPath)).createdBy("hive").build();){
                long snapshotId = tbl.currentSnapshot().snapshotId();
                long snapshotSequenceNumber = tbl.currentSnapshot().sequenceNumber();
                colStats.forEach(statsObj -> {
                    byte[] serializeColStats = SerializationUtils.serialize((Serializable)statsObj);
                    puffinWriter.add(new Blob(ColumnStatisticsObj.class.getSimpleName(), ImmutableList.of(Integer.valueOf(1)), snapshotId, snapshotSequenceNumber, ByteBuffer.wrap(serializeColStats), PuffinCompressionCodec.NONE, ImmutableMap.of("partition", String.valueOf(statsObj.getStatsDesc().getPartName()))));
                });
                puffinWriter.finish();
                statisticsFile = new GenericStatisticsFile(snapshotId, statsPath, puffinWriter.fileSize(), puffinWriter.footerSize(), puffinWriter.writtenBlobsMetadata().stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList()));
            }
            catch (IOException e) {
                LOG.warn("Unable to write stats to puffin file {}", (Object)e.getMessage());
                return false;
            }
            tbl.updateStatistics().setStatistics(statisticsFile.snapshotId(), statisticsFile).commit();
            return true;
        }
        catch (Exception e) {
            LOG.warn("Unable to invalidate or merge stats: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean canProvideColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        if (snapshot != null) {
            return this.canSetColStatistics(hmsTable) && this.canProvideColStats(table, snapshot.snapshotId());
        }
        return false;
    }

    private boolean canProvideColStats(Table table, long snapshotId) {
        return IcebergTableUtil.getColStatsPath(table, snapshotId).isPresent();
    }

    public List<ColumnStatisticsObj> getColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        ColumnStatistics emptyStats = new ColumnStatistics();
        if (snapshot != null) {
            return IcebergTableUtil.getColStatsPath(table, snapshot.snapshotId()).map(statsPath -> this.readColStats(table, (Path)statsPath, null).get(0)).orElse(emptyStats).getStatsObj();
        }
        return emptyStats.getStatsObj();
    }

    public AggrStats getAggrColStatsFor(org.apache.hadoop.hive.ql.metadata.Table hmsTable, List<String> colNames, List<String> partNames) throws MetaException {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        if (snapshot == null) {
            return new AggrStats(Collections.emptyList(), 0L);
        }
        boolean useDensityFunctionForNDVEstimation = MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_NDV_DENSITY_FUNCTION);
        double ndvTuner = MetastoreConf.getDoubleVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_NDV_TUNER);
        List<ColumnStatistics> partStats = IcebergTableUtil.getColStatsPath(table, snapshot.snapshotId()).map(statsPath -> this.readColStats(table, (Path)statsPath, (Set<String>)Sets.newHashSet(partNames))).orElse(Collections.emptyList());
        partStats.forEach(colStats -> colStats.getStatsObj().removeIf(statsObj -> !colNames.contains(statsObj.getColName())));
        List colStatsList = MetaStoreServerUtils.aggrPartitionStats(partStats, (String)MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), (String)hmsTable.getDbName(), (String)hmsTable.getTableName(), partNames, colNames, (partStats.size() == partNames.size() ? 1 : 0) != 0, (boolean)useDensityFunctionForNDVEstimation, (double)ndvTuner);
        return new AggrStats(colStatsList, (long)partStats.size());
    }

    private List<ColumnStatistics> readColStats(Table table, Path statsPath, Set<String> partNames) {
        ArrayList<ColumnStatistics> colStats = Lists.newArrayList();
        try (PuffinReader reader = Puffin.read(table.io().newInputFile(statsPath.toString())).build();){
            List<BlobMetadata> blobMetadata = reader.fileMetadata().blobs();
            if (partNames != null) {
                blobMetadata = blobMetadata.stream().filter(metadata -> partNames.contains(metadata.properties().get("partition"))).collect(Collectors.toList());
            }
            Iterator it = Iterables.transform(reader.readAll(blobMetadata), Pair::second).iterator();
            LOG.info("Using col stats from : {}", (Object)statsPath);
            while (it.hasNext()) {
                byte[] byteBuffer = ByteBuffers.toByteArray((ByteBuffer)it.next());
                colStats.add((ColumnStatistics)SerializationUtils.deserialize((byte[])byteBuffer));
            }
        }
        catch (Exception e) {
            LOG.warn(" Unable to read col stats: ", (Throwable)e);
        }
        return colStats;
    }

    public boolean canComputeQueryUsingStats(Partish partish) {
        Map<String, String> summary;
        org.apache.hadoop.hive.ql.metadata.Table hmsTable = partish.getTable();
        if (hmsTable.getMetaTable() != null) {
            return false;
        }
        if (!this.getStatsSource().equals("ICEBERG") && StatsSetupConst.areBasicStatsUptoDate((Map)partish.getPartParameters())) {
            return true;
        }
        Table table = this.getTable(hmsTable);
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        if (snapshot != null && (summary = HiveIcebergStorageHandler.getPartishSummary(partish, table, snapshot)) != null && summary.containsKey("total-equality-deletes") && summary.containsKey("total-position-deletes")) {
            long totalPosDeletes;
            long totalEqDeletes = Long.parseLong(summary.get("total-equality-deletes"));
            return totalEqDeletes + (totalPosDeletes = Long.parseLong(summary.get("total-position-deletes"))) == 0L;
        }
        return false;
    }

    private String getStatsSource() {
        return HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ICEBERG_STATS_SOURCE, (String)"ICEBERG").toUpperCase();
    }

    private boolean shouldRewriteColStats(Table tbl) {
        return SessionStateUtil.getQueryState((Configuration)this.conf).map(QueryState::getHiveOperation).filter(opType -> HiveOperation.ANALYZE_TABLE == opType).isPresent() || IcebergTableUtil.getColStatsPath(tbl).isPresent();
    }

    private void checkAndMergeColStats(List<ColumnStatistics> statsNew, Table tbl) throws InvalidObjectException {
        Long previousSnapshotId = tbl.currentSnapshot().parentId();
        if (previousSnapshotId != null && this.canProvideColStats(tbl, previousSnapshotId)) {
            List statsOld = IcebergTableUtil.getColStatsPath(tbl, previousSnapshotId).map(statsPath -> this.readColStats(tbl, (Path)statsPath, null)).orElse(Collections.emptyList());
            boolean isTblLevel = statsNew.get(0).getStatsDesc().isIsTblLevel();
            HashMap<String, ColumnStatistics> oldStatsMap = Maps.newHashMap();
            if (!isTblLevel) {
                for (ColumnStatistics statsObjOld : statsOld) {
                    oldStatsMap.put(statsObjOld.getStatsDesc().getPartName(), statsObjOld);
                }
            }
            for (ColumnStatistics statsObjNew : statsNew) {
                String partitionKey = statsObjNew.getStatsDesc().getPartName();
                ColumnStatistics statsObjOld = isTblLevel ? (ColumnStatistics)statsOld.get(0) : (ColumnStatistics)oldStatsMap.get(partitionKey);
                if (statsObjOld == null || statsObjOld.getStatsObjSize() == 0 || statsObjNew.getStatsObj().isEmpty()) continue;
                MetaStoreServerUtils.mergeColStats((ColumnStatistics)statsObjNew, (ColumnStatistics)statsObjOld);
                if (isTblLevel) continue;
                oldStatsMap.remove(partitionKey);
            }
            if (!isTblLevel) {
                statsNew.addAll(oldStatsMap.values());
            }
        }
    }

    public LockType getLockType(WriteEntity writeEntity) {
        boolean sharedWrite;
        org.apache.hadoop.hive.ql.metadata.Table hmsTable = writeEntity.getTable();
        boolean bl = sharedWrite = !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.TXN_WRITE_X_LOCK);
        if (TableType.MATERIALIZED_VIEW == writeEntity.getTable().getTableType()) {
            return LockType.SHARED_READ;
        }
        if (HiveTableOperations.hiveLockEnabled(hmsTable.getParameters(), this.conf)) {
            throw new RuntimeException("Hive locking on table `" + hmsTable.getFullTableName() + "`cannot be enabled when `engine.hive.lock-enabled`=`true`. Disable `engine.hive.lock-enabled` to use Hive locking");
        }
        switch (writeEntity.getWriteType()) {
            case INSERT_OVERWRITE: {
                return LockType.EXCL_WRITE;
            }
            case UPDATE: 
            case DELETE: {
                return sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE;
            }
        }
        return LockType.SHARED_WRITE;
    }

    public boolean supportsPartitionTransform() {
        return true;
    }

    public List<TransformSpec> getPartitionTransformSpec(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return table.spec().fields().stream().filter(f -> !f.transform().isVoid()).map(f -> {
            TransformSpec spec = IcebergTableUtil.getTransformSpec(table, f.transform().toString(), f.sourceId());
            spec.setFieldName(f.name());
            return spec;
        }).collect(Collectors.toList());
    }

    public Map<Integer, List<TransformSpec>> getPartitionTransformSpecs(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return table.specs().entrySet().stream().flatMap(e -> ((PartitionSpec)e.getValue()).fields().stream().filter(f -> !f.transform().isVoid()).map(f -> {
            TransformSpec spec = IcebergTableUtil.getTransformSpec(table, f.transform().toString(), f.sourceId());
            spec.setFieldName(f.name());
            return Pair.of((Integer)e.getKey(), spec);
        })).collect(Collectors.groupingBy(Pair::first, Collectors.mapping(Pair::second, Collectors.toList())));
    }

    private List<TransformSpec> getSortTransformSpec(Table table) {
        return table.sortOrder().fields().stream().map(s -> IcebergTableUtil.getTransformSpec(table, s.transform().toString(), s.sourceId())).collect(Collectors.toList());
    }

    public DynamicPartitionCtx createDPContext(HiveConf hiveConf, org.apache.hadoop.hive.ql.metadata.Table hmsTable, Context.Operation writeOperation) throws SemanticException {
        SortOrder sortOrder;
        if (writeOperation == Context.Operation.DELETE && !this.shouldOverwrite(hmsTable, writeOperation)) {
            return null;
        }
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        DynamicPartitionCtx dpCtx = new DynamicPartitionCtx(Maps.newLinkedHashMap(), hiveConf.getVar(HiveConf.ConfVars.DEFAULT_PARTITION_NAME), hiveConf.getIntVar(HiveConf.ConfVars.DYNAMIC_PARTITION_MAX_PARTS_PER_NODE));
        if (table.spec().isPartitioned() && hiveConf.getIntVar(HiveConf.ConfVars.HIVE_OPT_SORT_DYNAMIC_PARTITION_THRESHOLD) >= 0) {
            this.addCustomSortExpr(table, hmsTable, writeOperation, dpCtx, this.getPartitionTransformSpec(hmsTable));
        }
        if ((sortOrder = table.sortOrder()).isSorted()) {
            LinkedList<Integer> customSortPositions = Lists.newLinkedList();
            LinkedList<Integer> customSortOrder = Lists.newLinkedList();
            dpCtx.setCustomSortOrder(customSortOrder);
            LinkedList<Integer> customSortNullOrder = Lists.newLinkedList();
            dpCtx.setCustomSortNullOrder(customSortNullOrder);
            block0: for (SortField sortField : sortOrder.fields()) {
                int pos = 0;
                for (Types.NestedField field : table.schema().columns()) {
                    if (sortField.sourceId() == field.fieldId()) {
                        customSortPositions.add(pos);
                        customSortOrder.add(sortField.direction() == SortDirection.ASC ? 1 : 0);
                        NullOrdering nullOrdering = NullOrdering.NULLS_LAST;
                        if (sortField.nullOrder() == NullOrder.NULLS_FIRST) {
                            nullOrdering = NullOrdering.NULLS_FIRST;
                        }
                        customSortNullOrder.add(nullOrdering.getCode());
                        continue block0;
                    }
                    ++pos;
                }
            }
            this.addCustomSortExpr(table, hmsTable, writeOperation, dpCtx, this.getSortTransformSpec(table));
        }
        return dpCtx;
    }

    private void addCustomSortExpr(Table table, org.apache.hadoop.hive.ql.metadata.Table hmsTable, Context.Operation writeOperation, DynamicPartitionCtx dpCtx, List<TransformSpec> transformSpecs) {
        HashMap<String, Integer> fieldOrderMap = Maps.newHashMap();
        List<Types.NestedField> fields = table.schema().columns();
        for (int i = 0; i < fields.size(); ++i) {
            fieldOrderMap.put(fields.get(i).name(), i);
        }
        int offset = (this.shouldOverwrite(hmsTable, writeOperation) ? ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA : this.acidSelectColumns(hmsTable, writeOperation)).size();
        dpCtx.addCustomSortExpressions(transformSpecs.stream().map(spec -> IcebergTransformSortFunctionUtil.getCustomSortExprs(spec, (Integer)fieldOrderMap.get(spec.getColumnName()) + offset)).collect(Collectors.toList()));
    }

    public boolean supportsPartitionAwareOptimization(org.apache.hadoop.hive.ql.metadata.Table table) {
        if (this.hasUndergonePartitionEvolution(table)) {
            return false;
        }
        List<TransformSpec> specs = this.getPartitionTransformSpec(table);
        return specs.stream().anyMatch(IcebergTableUtil::isBucket);
    }

    public PartitionAwareOptimizationCtx createPartitionAwareOptimizationContext(org.apache.hadoop.hive.ql.metadata.Table table) {
        ArrayList<String> bucketColumnNames = Lists.newArrayList();
        ArrayList<Integer> numBuckets = Lists.newArrayList();
        this.getPartitionTransformSpec(table).stream().filter(IcebergTableUtil::isBucket).forEach(spec -> {
            bucketColumnNames.add(spec.getColumnName());
            numBuckets.add((Integer)spec.getTransformParam().get());
        });
        if (bucketColumnNames.isEmpty()) {
            return null;
        }
        IcebergBucketFunction bucketFunction = new IcebergBucketFunction(bucketColumnNames, numBuckets);
        return new PartitionAwareOptimizationCtx((CustomBucketFunction)bucketFunction);
    }

    public String getFileFormatPropertyKey() {
        return "write.format.default";
    }

    public boolean commitInMoveTask() {
        return true;
    }

    public void storageHandlerCommit(Properties commitProperties, Context.Operation operation, ExecutorService executorService) throws HiveException {
        List<JobContext> jobContextList;
        String tableName = commitProperties.getProperty("name");
        String location = commitProperties.getProperty("location");
        String snapshotRef = commitProperties.getProperty("snapshot_ref");
        HiveConf configuration = SessionState.getSessionConf();
        if (location != null) {
            HiveTableUtil.cleanupTableObjectFile(location, (Configuration)configuration);
        }
        if ((jobContextList = HiveIcebergOutputCommitter.generateJobContext((Configuration)configuration, tableName, snapshotRef)).isEmpty()) {
            return;
        }
        HiveIcebergOutputCommitter committer = this.getOutputCommitter();
        committer.setWorkerPool(executorService);
        try {
            committer.commitJobs(jobContextList, operation);
        }
        catch (Throwable e) {
            String ids = jobContextList.stream().map(jobContext -> jobContext.getJobID().toString()).collect(Collectors.joining(", "));
            LOG.error("Error while trying to commit job: {}, starting rollback changes for table: {}", new Object[]{ids, tableName, e});
            try {
                committer.abortJobs(jobContextList);
            }
            catch (IOException ioe) {
                LOG.error("Error while trying to abort failed job. There might be uncleaned data files.", (Throwable)ioe);
            }
            throw new HiveException("Error committing job: " + ids + " for table: " + tableName, e);
        }
    }

    public HiveIcebergOutputCommitter getOutputCommitter() {
        return new HiveIcebergOutputCommitter();
    }

    public boolean isAllowedAlterOperation(AlterTableType opType) {
        return HiveIcebergMetaHook.SUPPORTED_ALTER_OPS.contains(opType);
    }

    public boolean supportsTruncateOnNonNativeTables() {
        return true;
    }

    public boolean isTimeTravelAllowed() {
        return true;
    }

    public boolean isTableMetaRefSupported() {
        return true;
    }

    public void executeOperation(org.apache.hadoop.hive.ql.metadata.Table hmsTable, AlterTableExecuteSpec executeSpec) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table icebergTable = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        switch (executeSpec.getOperationType()) {
            case ROLLBACK: {
                LOG.info("Executing rollback operation on iceberg table. If you would like to revert rollback you could try altering the metadata location to the current metadata location by executing the following query:ALTER TABLE {}.{} SET TBLPROPERTIES('metadata_location'='{}'). This operation is supported for Hive Catalog tables.", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), ((BaseTable)icebergTable).operations().current().metadataFileLocation()});
                AlterTableExecuteSpec.RollbackSpec rollbackSpec = (AlterTableExecuteSpec.RollbackSpec)executeSpec.getOperationParams();
                IcebergTableUtil.rollback(icebergTable, rollbackSpec.getRollbackType(), rollbackSpec.getParam());
                break;
            }
            case EXPIRE_SNAPSHOT: {
                LOG.info("Executing expire snapshots operation on iceberg table {}.{}", (Object)hmsTable.getDbName(), (Object)hmsTable.getTableName());
                AlterTableExecuteSpec.ExpireSnapshotsSpec expireSnapshotsSpec = (AlterTableExecuteSpec.ExpireSnapshotsSpec)executeSpec.getOperationParams();
                int numThreads = this.conf.getInt(HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.varname, HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.defaultIntVal);
                this.expireSnapshot(icebergTable, expireSnapshotsSpec, numThreads);
                break;
            }
            case SET_CURRENT_SNAPSHOT: {
                AlterTableExecuteSpec.SetCurrentSnapshotSpec setSnapshotVersionSpec = (AlterTableExecuteSpec.SetCurrentSnapshotSpec)executeSpec.getOperationParams();
                LOG.debug("Executing set current snapshot operation on iceberg table {}.{} to version {}", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), setSnapshotVersionSpec.getSnapshotIdOrRefName()});
                IcebergTableUtil.setCurrentSnapshot(icebergTable, setSnapshotVersionSpec.getSnapshotIdOrRefName());
                break;
            }
            case FAST_FORWARD: {
                AlterTableExecuteSpec.FastForwardSpec fastForwardSpec = (AlterTableExecuteSpec.FastForwardSpec)executeSpec.getOperationParams();
                IcebergTableUtil.fastForwardBranch(icebergTable, fastForwardSpec.getSourceBranch(), fastForwardSpec.getTargetBranch());
                break;
            }
            case CHERRY_PICK: {
                AlterTableExecuteSpec.CherryPickSpec cherryPickSpec = (AlterTableExecuteSpec.CherryPickSpec)executeSpec.getOperationParams();
                IcebergTableUtil.cherryPick(icebergTable, cherryPickSpec.getSnapshotId());
                break;
            }
            case DELETE_METADATA: {
                AlterTableExecuteSpec.DeleteMetadataSpec deleteMetadataSpec = (AlterTableExecuteSpec.DeleteMetadataSpec)executeSpec.getOperationParams();
                IcebergTableUtil.performMetadataDelete(icebergTable, deleteMetadataSpec.getBranchName(), deleteMetadataSpec.getSarg());
                break;
            }
            case DELETE_ORPHAN_FILES: {
                int numDeleteThreads = this.conf.getInt(HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.varname, HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.defaultIntVal);
                AlterTableExecuteSpec.DeleteOrphanFilesDesc deleteOrphanFilesSpec = (AlterTableExecuteSpec.DeleteOrphanFilesDesc)executeSpec.getOperationParams();
                this.deleteOrphanFiles(icebergTable, deleteOrphanFilesSpec.getTimestampMillis(), numDeleteThreads);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Operation type %s is not supported", executeSpec.getOperationType().name()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOrphanFiles(Table icebergTable, long timestampMillis, int numThreads) {
        ExecutorService deleteExecutorService = null;
        try {
            if (numThreads > 0) {
                LOG.info("Executing delete orphan files on iceberg table {} with {} threads", (Object)icebergTable.name(), (Object)numThreads);
                deleteExecutorService = IcebergTableUtil.newDeleteThreadPool(icebergTable.name(), numThreads);
            }
            HiveIcebergDeleteOrphanFiles deleteOrphanFiles = new HiveIcebergDeleteOrphanFiles(this.conf, icebergTable);
            deleteOrphanFiles.olderThan(timestampMillis);
            if (deleteExecutorService != null) {
                deleteOrphanFiles.executeDeleteWith(deleteExecutorService);
            }
            DeleteOrphanFiles.Result result = deleteOrphanFiles.execute();
            LOG.debug("Cleaned files {} for {}", result.orphanFileLocations(), (Object)icebergTable);
        }
        finally {
            if (deleteExecutorService != null) {
                deleteExecutorService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSnapshot(Table icebergTable, AlterTableExecuteSpec.ExpireSnapshotsSpec expireSnapshotsSpec, int numThreads) {
        ExecutorService deleteExecutorService = null;
        try {
            if (numThreads > 0) {
                LOG.info("Executing expire snapshots on iceberg table {} with {} threads", (Object)icebergTable.name(), (Object)numThreads);
                deleteExecutorService = IcebergTableUtil.newDeleteThreadPool(icebergTable.name(), numThreads);
            }
            if (expireSnapshotsSpec == null) {
                this.expireSnapshotWithDefaultParams(icebergTable, deleteExecutorService);
            } else if (expireSnapshotsSpec.isExpireByTimestampRange()) {
                this.expireSnapshotByTimestampRange(icebergTable, expireSnapshotsSpec.getFromTimestampMillis(), expireSnapshotsSpec.getTimestampMillis(), deleteExecutorService);
            } else if (expireSnapshotsSpec.isExpireByIds()) {
                this.expireSnapshotByIds(icebergTable, expireSnapshotsSpec.getIdsToExpire(), deleteExecutorService);
            } else if (expireSnapshotsSpec.isExpireByRetainLast()) {
                this.expireSnapshotRetainLast(icebergTable, expireSnapshotsSpec.getNumRetainLast(), deleteExecutorService);
            } else {
                this.expireSnapshotOlderThanTimestamp(icebergTable, expireSnapshotsSpec.getTimestampMillis(), deleteExecutorService);
            }
        }
        finally {
            if (deleteExecutorService != null) {
                deleteExecutorService.shutdown();
            }
        }
    }

    private void expireSnapshotWithDefaultParams(Table icebergTable, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotRetainLast(Table icebergTable, int numRetainLast, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        expireSnapshots.retainLast(numRetainLast);
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotByTimestampRange(Table icebergTable, Long fromTimestamp, Long toTimestamp, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        for (Snapshot snapshot : icebergTable.snapshots()) {
            if (snapshot.timestampMillis() < fromTimestamp || snapshot.timestampMillis() > toTimestamp) continue;
            expireSnapshots.expireSnapshotId(snapshot.snapshotId());
            LOG.debug("Expiring snapshot on {} with id: {} and timestamp: {}", new Object[]{icebergTable.name(), snapshot.snapshotId(), snapshot.timestampMillis()});
        }
        LOG.info("Expiring snapshot on {} within time range {} -> {}", new Object[]{icebergTable.name(), fromTimestamp, toTimestamp});
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotOlderThanTimestamp(Table icebergTable, Long timestamp, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots().expireOlderThan(timestamp);
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotByIds(Table icebergTable, String[] idsToExpire, ExecutorService deleteExecutorService) {
        if (idsToExpire.length != 0) {
            ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
            for (String id : idsToExpire) {
                expireSnapshots.expireSnapshotId(Long.parseLong(id));
            }
            LOG.info("Expiring snapshot on {} for snapshot Ids: {}", (Object)icebergTable.name(), (Object)Arrays.toString(idsToExpire));
            if (deleteExecutorService != null) {
                expireSnapshots = expireSnapshots.executeDeleteWith(deleteExecutorService);
            }
            expireSnapshots.commit();
        }
    }

    public void alterTableSnapshotRefOperation(org.apache.hadoop.hive.ql.metadata.Table hmsTable, AlterTableSnapshotRefSpec alterTableSnapshotRefSpec) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table icebergTable = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        switch (alterTableSnapshotRefSpec.getOperationType()) {
            case CREATE_BRANCH: {
                AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createBranchSpec = (AlterTableSnapshotRefSpec.CreateSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergSnapshotRefExec.createBranch(icebergTable, createBranchSpec);
                break;
            }
            case CREATE_TAG: {
                if (icebergTable.currentSnapshot() == null) {
                    throw new UnsupportedOperationException(String.format("Cannot alter %s on iceberg table %s.%s which has no snapshot", alterTableSnapshotRefSpec.getOperationType().getName(), hmsTable.getDbName(), hmsTable.getTableName()));
                }
                AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createTagSpec = (AlterTableSnapshotRefSpec.CreateSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergSnapshotRefExec.createTag(icebergTable, createTagSpec);
                break;
            }
            case DROP_BRANCH: {
                AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropBranchSpec = (AlterTableSnapshotRefSpec.DropSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergSnapshotRefExec.dropBranch(icebergTable, dropBranchSpec);
                break;
            }
            case RENAME_BRANCH: {
                AlterTableSnapshotRefSpec.RenameSnapshotrefSpec renameSnapshotrefSpec = (AlterTableSnapshotRefSpec.RenameSnapshotrefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergSnapshotRefExec.renameBranch(icebergTable, renameSnapshotrefSpec);
                break;
            }
            case REPLACE_SNAPSHOTREF: {
                AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec = (AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec)alterTableSnapshotRefSpec.getOperationParams();
                if (replaceSnapshotrefSpec.isReplaceBranch()) {
                    IcebergSnapshotRefExec.replaceBranch(icebergTable, replaceSnapshotrefSpec);
                    break;
                }
                IcebergSnapshotRefExec.replaceTag(icebergTable, replaceSnapshotrefSpec);
                break;
            }
            case DROP_TAG: {
                AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropTagSpec = (AlterTableSnapshotRefSpec.DropSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergSnapshotRefExec.dropTag(icebergTable, dropTagSpec);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Operation type %s is not supported", alterTableSnapshotRefSpec.getOperationType().getName()));
            }
        }
    }

    public boolean isValidMetadataTable(String metaTableName) {
        return metaTableName != null && IcebergMetadataTables.isValidMetaTable(metaTableName);
    }

    public org.apache.hadoop.hive.ql.metadata.Table checkAndSetTableMetaRef(org.apache.hadoop.hive.ql.metadata.Table hmsTable, String tableMetaRef) throws SemanticException {
        String refName = HiveUtils.getTableSnapshotRef((String)tableMetaRef);
        if (refName != null) {
            Table tbl = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
            if (tbl.snapshot(refName) != null) {
                hmsTable.setSnapshotRef(tableMetaRef);
                return hmsTable;
            }
            throw new SemanticException(String.format("Cannot use snapshotRef (does not exist): %s", refName));
        }
        if (IcebergMetadataTables.isValidMetaTable(tableMetaRef)) {
            hmsTable.setMetaTable(tableMetaRef);
            return hmsTable;
        }
        throw new SemanticException(ErrorMsg.INVALID_METADATA_TABLE_NAME, new String[]{tableMetaRef});
    }

    public URI getURIForAuth(org.apache.hadoop.hive.metastore.api.Table hmsTable) throws URISyntaxException {
        String dbName = hmsTable.getDbName();
        String tableName = hmsTable.getTableName();
        StringBuilder authURI = new StringBuilder(ICEBERG_URI_PREFIX).append(HiveIcebergStorageHandler.encodeString(dbName)).append("/").append(HiveIcebergStorageHandler.encodeString(tableName)).append("?snapshot=");
        Optional metadataLocation = SessionStateUtil.getProperty((Configuration)this.conf, (String)"metadata_location");
        if (metadataLocation.isPresent()) {
            authURI.append(this.getPathForAuth((String)metadataLocation.get()));
        } else {
            Optional locationProperty = SessionStateUtil.getProperty((Configuration)this.conf, (String)"location");
            if (locationProperty.isPresent()) {
                authURI.append(this.getPathForAuth((String)locationProperty.get())).append(HiveIcebergStorageHandler.encodeString("/metadata/dummy.metadata.json"));
            } else {
                Table table = IcebergTableUtil.getTable(this.conf, hmsTable);
                authURI.append(this.getPathForAuth(((BaseTable)table).operations().current().metadataFileLocation(), hmsTable.getSd().getLocation()));
            }
        }
        LOG.debug("Iceberg storage handler authorization URI {}", (Object)authURI);
        return new URI(authURI.toString());
    }

    @VisibleForTesting
    static String encodeString(String rawString) {
        if (rawString == null) {
            return null;
        }
        return HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.encode(rawString);
    }

    String getPathForAuth(String locationProperty) {
        return this.getPathForAuth(locationProperty, SessionStateUtil.getProperty((Configuration)this.conf, (String)"defaultLocation").orElse(null));
    }

    String getPathForAuth(String locationProperty, String defaultTableLocation) {
        boolean maskDefaultLocation = this.conf.getBoolean(HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.varname, HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.defaultBoolVal);
        String location = URI.create(locationProperty).getPath();
        if (!maskDefaultLocation || defaultTableLocation == null || !this.arePathsInSameFs(locationProperty, defaultTableLocation)) {
            return HiveIcebergStorageHandler.encodeString(location);
        }
        try {
            Path locationPath = new Path(location);
            Path defaultLocationPath = locationPath.toUri().getScheme() != null ? FileUtils.makeQualified((Path)new Path(defaultTableLocation), (Configuration)this.conf) : Path.getPathWithoutSchemeAndAuthority((Path)new Path(defaultTableLocation));
            return HiveIcebergStorageHandler.encodeString(location.replaceFirst(defaultLocationPath.toString(), TABLE_DEFAULT_LOCATION));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean arePathsInSameFs(String locationProperty, String defaultTableLocation) {
        try {
            return FileUtils.equalsFileSystem((FileSystem)new Path(locationProperty).getFileSystem(this.conf), (FileSystem)new Path(defaultTableLocation).getFileSystem(this.conf));
        }
        catch (IOException e) {
            LOG.debug("Unable to get FileSystem for path {} and {}", (Object)locationProperty, (Object)defaultTableLocation);
            return false;
        }
    }

    public void validateSinkDesc(FileSinkDesc sinkDesc) throws SemanticException {
        super.validateSinkDesc(sinkDesc);
        if (sinkDesc.getInsertOverwrite()) {
            Table table = IcebergTableUtil.getTable(this.conf, sinkDesc.getTableInfo().getProperties());
            if (table.currentSnapshot() != null && Long.parseLong(table.currentSnapshot().summary().get("total-records")) == 0L) {
                return;
            }
            if (Context.RewritePolicy.fromString((String)this.conf.get(HiveConf.ConfVars.REWRITE_POLICY.varname)) != Context.RewritePolicy.DEFAULT) {
                return;
            }
            if (IcebergTableUtil.isBucketed(table)) {
                throw new SemanticException("Cannot perform insert overwrite query on bucket partitioned Iceberg table.");
            }
            if (this.hasUndergonePartitionEvolution(table)) {
                throw new SemanticException("Cannot perform insert overwrite query on Iceberg table where partition evolution happened. In order to successfully carry out any insert overwrite operation on this table, the data has to be rewritten conforming to the latest spec. ");
            }
        }
    }

    public HiveStorageHandler.AcidSupportType supportsAcidOperations() {
        return HiveStorageHandler.AcidSupportType.WITHOUT_TRANSACTIONS;
    }

    public List<VirtualColumn> acidVirtualColumns() {
        return ACID_VIRTUAL_COLS;
    }

    public List<FieldSchema> acidSelectColumns(org.apache.hadoop.hive.ql.metadata.Table table, Context.Operation operation) {
        switch (operation) {
            case DELETE: {
                return ListUtils.union(ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA, (List)table.getCols());
            }
            case UPDATE: {
                return this.shouldOverwrite(table, operation) ? ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA : ListUtils.union(ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA, (List)table.getCols());
            }
            case MERGE: {
                return ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA;
            }
        }
        return ImmutableList.of();
    }

    public FieldSchema getRowId() {
        VirtualColumn rowId = VirtualColumn.ROW_POSITION;
        return new FieldSchema(rowId.getName(), rowId.getTypeInfo().getTypeName(), "");
    }

    public List<FieldSchema> acidSortColumns(org.apache.hadoop.hive.ql.metadata.Table table, Context.Operation operation) {
        switch (operation) {
            case DELETE: {
                return IcebergTableUtil.isFanoutEnabled(table.getParameters()) ? EMPTY_ORDERING : POSITION_DELETE_ORDERING;
            }
            case MERGE: {
                return POSITION_DELETE_ORDERING;
            }
        }
        return EMPTY_ORDERING;
    }

    public boolean supportsSortColumns() {
        return true;
    }

    public List<FieldSchema> sortColumns(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        if (table.sortOrder().isUnsorted()) {
            return Collections.emptyList();
        }
        Schema schema = table.schema();
        List<FieldSchema> hiveSchema = HiveSchemaUtil.convert(schema);
        Map<String, String> colNameToColType = hiveSchema.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getType));
        return table.sortOrder().fields().stream().map(s -> new FieldSchema(schema.findColumnName(s.sourceId()), (String)colNameToColType.get(schema.findColumnName(s.sourceId())), String.format("Transform: %s, Sort direction: %s, Null sort order: %s", s.transform().toString(), s.direction().name(), s.nullOrder().name()))).collect(Collectors.toList());
    }

    private void setCommonJobConf(JobConf jobConf) {
        jobConf.set("tez.mrreader.config.update.properties", "hive.io.file.readcolumn.names,hive.io.file.readcolumn.ids");
    }

    public StorageFormat.StorageHandlerTypes getType() {
        return StorageFormat.StorageHandlerTypes.ICEBERG;
    }

    public boolean addDynamicSplitPruningEdge(org.apache.hadoop.hive.ql.metadata.Table table, ExprNodeDesc syntheticFilterPredicate) {
        try {
            ExprNodeDesc clone;
            String filterColumn;
            Collection<String> partitionColumns = ((HiveIcebergSerDe)table.getDeserializer()).partitionColumns();
            if (!partitionColumns.isEmpty() && partitionColumns.contains(filterColumn = this.collectColumnAndReplaceDummyValues(clone = syntheticFilterPredicate.clone(), null))) {
                SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)((ExprNodeGenericFuncDesc)clone));
                HiveIcebergFilterFactory.generateFilterExpression(sarg);
                LOG.debug("Found Iceberg partition column to prune with predicate {}", (Object)syntheticFilterPredicate);
                return true;
            }
        }
        catch (UnsupportedOperationException uoe) {
            LOG.debug("Unsupported predicate {}", (Object)syntheticFilterPredicate, (Object)uoe);
        }
        LOG.debug("Not found Iceberg partition columns to prune with predicate {}", (Object)syntheticFilterPredicate);
        return false;
    }

    public static Table table(Configuration config, String name) {
        Table table = (Table)SerializationUtil.deserializeFromBase64(config.get("iceberg.mr.serialized.table." + name));
        if (table == null && config.getBoolean("created_with_ctas", false) && StringUtils.isNotBlank((CharSequence)config.get("iceberg.mr.table.location"))) {
            table = HiveTableUtil.readTableObjectFromFile(config);
        }
        HiveIcebergStorageHandler.checkAndSetIoConfig(config, table);
        return table;
    }

    public static void checkAndSetIoConfig(Configuration config, Table table) {
        if (table != null && config.getBoolean("iceberg.mr.config.serialization.disabled", true) && table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).setConf(config);
        }
    }

    public static void checkAndSkipIoConfigSerialization(Configuration config, Table table) {
        if (table != null && config.getBoolean("iceberg.mr.config.serialization.disabled", true) && table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).serializeConfWith(conf -> new NonSerializingConfig(config)::get);
        }
    }

    public static Set<String> outputTables(Configuration config) {
        return Sets.newHashSet(TABLE_NAME_SPLITTER.split(config.get("iceberg.mr.output.tables")));
    }

    public static String catalogName(Configuration config, String name) {
        return config.get("iceberg.mr.table.catalog." + name);
    }

    public static Schema schema(Configuration config) {
        return SchemaParser.fromJson(config.get("iceberg.mr.table.schema"));
    }

    @VisibleForTesting
    static void overlayTableProperties(Configuration configuration, TableDesc tableDesc, Map<String, String> map) {
        PartitionSpec spec;
        Schema schema;
        String location;
        Properties props = tableDesc.getProperties();
        Maps.fromProperties(props).entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(entry -> map.put((String)entry.getKey(), (String)entry.getValue()));
        try {
            Table table = IcebergTableUtil.getTable(configuration, props);
            location = table.location();
            schema = table.schema();
            spec = table.spec();
            Table serializableTable = SerializableTable.copyOf(table);
            HiveIcebergStorageHandler.checkAndSkipIoConfigSerialization(configuration, serializableTable);
            map.put("iceberg.mr.serialized.table." + tableDesc.getTableName(), SerializationUtil.serializeToBase64(serializableTable));
        }
        catch (NoSuchTableException ex) {
            if (!HiveTableUtil.isCtas(props)) {
                throw ex;
            }
            if (!Catalogs.hiveCatalog(configuration, props)) {
                throw new UnsupportedOperationException("CTAS target table must be a HiveCatalog table. For other catalog types, the target Iceberg table would be created successfully but the table will not be registered in HMS. This means that even though the CTAS query succeeds, the new table wouldn't be immediately queryable from Hive, since HMS does not know about it.");
            }
            location = map.get("location");
            map.put("iceberg.mr.serialized.table." + tableDesc.getTableName(), SerializationUtil.serializeToBase64(null));
            try {
                AbstractSerDe serDe = tableDesc.getDeserializer(configuration);
                HiveIcebergSerDe icebergSerDe = (HiveIcebergSerDe)serDe;
                schema = icebergSerDe.getTableSchema();
                spec = IcebergTableUtil.spec(configuration, icebergSerDe.getTableSchema());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        map.put("iceberg.mr.table.identifier", props.getProperty("name"));
        if (StringUtils.isNotBlank((CharSequence)location)) {
            map.put("iceberg.mr.table.location", location);
        }
        String schemaJson = SchemaParser.toJson(schema);
        map.put("iceberg.mr.table.schema", schemaJson);
        props.put("iceberg.mr.table.schema", schemaJson);
        if (spec == null) {
            spec = PartitionSpec.unpartitioned();
        }
        props.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(spec));
        map.remove("columns.comments");
    }

    public void validateCurrentSnapshot(TableDesc tableDesc) {
        if (this.conf.getBoolean("iceberg.engine.hive.lock-enabled", true) || !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_EXT_LOCKING_ENABLED)) {
            return;
        }
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        if (table.currentSnapshot() != null || table instanceof BaseTable) {
            TableMetadata currentMetadata = ((BaseTable)table).operations().current();
            if (currentMetadata.propertyAsBoolean("engine.hive.lock-enabled", false)) {
                return;
            }
            TableMetadata newMetadata = ((BaseTable)table).operations().refresh();
            ValidationException.check(Objects.equals(newMetadata.metadataFileLocation(), currentMetadata.metadataFileLocation()), "Table snapshot is outdated: %s", tableDesc.getTableName());
        }
    }

    private String collectColumnAndReplaceDummyValues(ExprNodeDesc node, String foundColumn) {
        String column = foundColumn;
        List children = node.getChildren();
        if (children != null && !children.isEmpty()) {
            ListIterator<ExprNodeConstantDesc> iterator = children.listIterator();
            while (iterator.hasNext()) {
                ExprNodeDesc child = (ExprNodeDesc)iterator.next();
                if (child instanceof ExprNodeDynamicListDesc) {
                    iterator.set(new ExprNodeConstantDesc(child.getTypeInfo(), switch (((PrimitiveTypeInfo)child.getTypeInfo()).getPrimitiveCategory()) {
                        case PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.SHORT -> 1;
                        case PrimitiveObjectInspector.PrimitiveCategory.LONG -> 1L;
                        case PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ -> new Timestamp();
                        case PrimitiveObjectInspector.PrimitiveCategory.CHAR, PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, PrimitiveObjectInspector.PrimitiveCategory.STRING -> "1";
                        case PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, PrimitiveObjectInspector.PrimitiveCategory.FLOAT, PrimitiveObjectInspector.PrimitiveCategory.DECIMAL -> 1.1;
                        case PrimitiveObjectInspector.PrimitiveCategory.DATE -> new Date();
                        case PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN -> true;
                        default -> throw new UnsupportedOperationException("Not supported primitive type in partition pruning: " + child.getTypeInfo());
                    }));
                    continue;
                }
                String newColumn = child instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)child).getColumn() : this.collectColumnAndReplaceDummyValues(child, column);
                if (column != null && newColumn != null && !newColumn.equals(column)) {
                    throw new UnsupportedOperationException("Partition pruning does not support filtering for more columns");
                }
                if (column != null) continue;
                column = newColumn;
            }
        }
        return column;
    }

    private void fallbackToNonVectorizedModeBasedOnProperties(Properties tableProps) {
        Schema tableSchema = SchemaParser.fromJson(tableProps.getProperty("iceberg.mr.table.schema"));
        if (FileFormat.AVRO.name().equalsIgnoreCase(tableProps.getProperty("write.format.default")) || this.isValidMetadataTable(tableProps.getProperty("metaTable")) || HiveIcebergStorageHandler.hasOrcTimeInSchema(tableProps, tableSchema) || !HiveIcebergStorageHandler.hasParquetNestedTypeWithinListOrMap(tableProps, tableSchema)) {
            SessionStateUtil.getQueryState((Configuration)this.conf).ifPresent(queryState -> queryState.getConf().setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false));
        }
    }

    private static boolean hasOrcTimeInSchema(Properties tableProps, Schema tableSchema) {
        if (!FileFormat.ORC.name().equalsIgnoreCase(tableProps.getProperty("write.format.default"))) {
            return false;
        }
        return tableSchema.columns().stream().anyMatch(f -> Types.TimeType.get().typeId() == f.type().typeId());
    }

    private static boolean hasParquetNestedTypeWithinListOrMap(Properties tableProps, Schema tableSchema) {
        if (!FileFormat.PARQUET.name().equalsIgnoreCase(tableProps.getProperty("write.format.default"))) {
            return true;
        }
        for (Types.NestedField field : tableSchema.columns()) {
            if (!field.type().isListType() && !field.type().isMapType()) continue;
            for (Types.NestedField nestedField : field.type().asNestedType().fields()) {
                if (nestedField.type().isPrimitiveType()) continue;
                return false;
            }
        }
        return true;
    }

    private String getOperationType() {
        return SessionStateUtil.getProperty((Configuration)this.conf, (String)Context.Operation.class.getSimpleName()).orElse(Context.Operation.OTHER.name());
    }

    public boolean areSnapshotsSupported() {
        return true;
    }

    public SnapshotContext getCurrentSnapshotContext(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        Snapshot current = table.currentSnapshot();
        if (current == null) {
            return null;
        }
        return this.toSnapshotContext(current);
    }

    private SnapshotContext toSnapshotContext(Snapshot snapshot) {
        Map<String, String> summaryMap = snapshot.summary();
        long addedRecords = this.getLongSummary(summaryMap, "added-records");
        long deletedRecords = this.getLongSummary(summaryMap, "deleted-records");
        return new SnapshotContext(snapshot.snapshotId(), this.toWriteOperationType(snapshot.operation()), addedRecords, deletedRecords);
    }

    private SnapshotContext.WriteOperationType toWriteOperationType(String operation) {
        try {
            return SnapshotContext.WriteOperationType.valueOf((String)operation.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return SnapshotContext.WriteOperationType.UNKNOWN;
        }
    }

    private long getLongSummary(Map<String, String> summaryMap, String key) {
        String textValue = summaryMap.get(key);
        if (StringUtils.isBlank((CharSequence)textValue)) {
            return 0L;
        }
        return Long.parseLong(textValue);
    }

    public Iterable<SnapshotContext> getSnapshotContexts(org.apache.hadoop.hive.ql.metadata.Table hmsTable, SnapshotContext since) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        return this.getSnapshots(table.snapshots(), since);
    }

    @VisibleForTesting
    Iterable<SnapshotContext> getSnapshots(Iterable<Snapshot> snapshots, SnapshotContext since) {
        ArrayList<SnapshotContext> result = Lists.newArrayList();
        boolean foundSince = Objects.isNull(since);
        for (Snapshot snapshot : snapshots) {
            if (!foundSince) {
                if (snapshot.snapshotId() != since.getSnapshotId()) continue;
                foundSince = true;
                continue;
            }
            result.add(this.toSnapshotContext(snapshot));
        }
        return foundSince ? result : Collections.emptyList();
    }

    public void prepareAlterTableEnvironmentContext(AbstractAlterTableDesc alterTableDesc, EnvironmentContext environmentContext) {
        if (alterTableDesc instanceof AlterTableSetPropertiesDesc && alterTableDesc.getProps().containsKey("metadata_location")) {
            environmentContext.putToProperties("MANUAL_ICEBERG_METADATA_LOCATION_CHANGE", "true");
        }
    }

    public void setTableParametersForCTLT(org.apache.hadoop.hive.ql.metadata.Table tbl, CreateTableLikeDesc desc, Map<String, String> origParams) {
        if (IcebergTableUtil.isV2Table(origParams)) {
            tbl.getParameters().put("format-version", "2");
            tbl.getParameters().put("write.delete.mode", MERGE_ON_READ);
            tbl.getParameters().put("write.update.mode", MERGE_ON_READ);
            tbl.getParameters().put("write.merge.mode", MERGE_ON_READ);
        }
        if (!desc.isExternal()) {
            tbl.getParameters().put("TRANSLATED_TO_EXTERNAL", "TRUE");
            desc.setIsExternal(true);
        }
        if (MetaStoreUtils.isIcebergTable(origParams)) {
            tbl.getParameters().put("iceberg.mr.table.schema", origParams.get("iceberg.mr.table.schema"));
            tbl.getParameters().put("iceberg.mr.table.partition.spec", origParams.get("iceberg.mr.table.partition.spec"));
        } else {
            List spec = PartitionTransform.getPartitionTransformSpec((List)tbl.getPartitionKeys());
            SessionStateUtil.addResourceOrThrow((Configuration)this.conf, (String)"partition_transform_spec", (Object)spec);
            tbl.getSd().getCols().addAll(tbl.getPartitionKeys());
            tbl.getTTable().setPartitionKeysIsSet(false);
        }
    }

    public void setTableLocationForCTAS(CreateTableDesc desc, String location) {
        desc.setLocation(location);
    }

    public Map<String, String> getNativeProperties(org.apache.hadoop.hive.ql.metadata.Table table) {
        Table origTable = IcebergTableUtil.getTable(this.conf, table.getTTable());
        HashMap<String, String> props = Maps.newHashMap();
        props.put("iceberg.mr.table.schema", SchemaParser.toJson(origTable.schema()));
        props.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(origTable.spec()));
        return props;
    }

    public boolean shouldOverwrite(org.apache.hadoop.hive.ql.metadata.Table mTable, Context.Operation operation) {
        return IcebergTableUtil.isCopyOnWriteMode(operation, mTable.getParameters()::getOrDefault);
    }

    public void addResourcesForCreateTable(Map<String, String> tblProps, HiveConf hiveConf) {
        String metadataLocation = tblProps.get("metadata_location");
        if (StringUtils.isNotEmpty((CharSequence)metadataLocation)) {
            SessionStateUtil.addResourceOrThrow((Configuration)hiveConf, (String)"metadata_location", (Object)metadataLocation);
        }
    }

    @Deprecated
    public Boolean hasAppendsOnly(org.apache.hadoop.hive.ql.metadata.Table hmsTable, SnapshotContext since) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        return this.hasAppendsOnly(table.snapshots(), since);
    }

    @VisibleForTesting
    Boolean hasAppendsOnly(Iterable<Snapshot> snapshots, SnapshotContext since) {
        boolean foundSince = since == null;
        for (Snapshot snapshot : snapshots) {
            if (!foundSince) {
                if (snapshot.snapshotId() != since.getSnapshotId()) continue;
                foundSince = true;
                continue;
            }
            if ("append".equals(snapshot.operation())) continue;
            return false;
        }
        if (foundSince) {
            return true;
        }
        return null;
    }

    public void validatePartSpec(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec, Context.RewritePolicy policy) throws SemanticException {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        List<PartitionField> partitionFields = IcebergTableUtil.getPartitionFields(table, policy != Context.RewritePolicy.PARTITION);
        this.validatePartSpecImpl(hmsTable, partitionSpec, partitionFields);
    }

    private void validatePartSpecImpl(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec, List<PartitionField> partitionFields) throws SemanticException {
        Types.NestedField field;
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        if (hmsTable.getSnapshotRef() != null && this.hasUndergonePartitionEvolution(table)) {
            return;
        }
        if (table.spec().isUnpartitioned() && MapUtils.isNotEmpty(partitionSpec)) {
            throw new SemanticException("Writing data into a partition fails when the Iceberg table is unpartitioned.");
        }
        HashMap<String, Types.NestedField> mapOfPartColNamesWithTypes = Maps.newHashMap();
        for (PartitionField partitionField : partitionFields) {
            field = table.schema().findField(partitionField.sourceId());
            mapOfPartColNamesWithTypes.put(field.name(), field);
        }
        for (Map.Entry entry : partitionSpec.entrySet()) {
            field = (Types.NestedField)mapOfPartColNamesWithTypes.get(entry.getKey());
            Objects.requireNonNull(field, String.format("%s is not a partition column", entry.getKey()));
            if (entry.getValue() == null) continue;
            Object partKeyVal = Conversions.fromPartitionString(field.type(), (String)entry.getValue());
            Objects.requireNonNull(partKeyVal, String.format("Partition spec value for column : %s is invalid", field.name()));
        }
    }

    public boolean canUseTruncate(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec) throws SemanticException {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        if (MapUtils.isEmpty(partitionSpec) || !this.hasUndergonePartitionEvolution(table)) {
            return true;
        }
        if (hmsTable.getSnapshotRef() != null) {
            return false;
        }
        Expression finalExp = IcebergTableUtil.generateExpressionFromPartitionSpec(table, partitionSpec, true);
        FindFiles.Builder builder = new FindFiles.Builder(table).withRecordsMatching(finalExp);
        HashSet<DataFile> dataFiles = Sets.newHashSet(builder.collect());
        boolean result = true;
        for (DataFile dataFile : dataFiles) {
            PartitionData partitionData = (PartitionData)dataFile.partition();
            Expression residual = ResidualEvaluator.of(table.spec(), finalExp, false).residualFor(partitionData);
            if (residual.isEquivalentTo(Expressions.alwaysTrue())) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean hasUndergonePartitionEvolution(Table table) {
        return table.currentSnapshot() != null && table.currentSnapshot().allManifests(table.io()).parallelStream().map(ManifestFile::partitionSpecId).anyMatch(id -> id.intValue() != table.spec().specId());
    }

    public List<Partition> getPartitions(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec, boolean latestSpecOnly) throws SemanticException {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return IcebergTableUtil.getPartitionNames(table, partitionSpec, latestSpecOnly).stream().map(partName -> {
            LinkedHashMap partSpecMap = Maps.newLinkedHashMap();
            Warehouse.makeSpecFromName(partSpecMap, (Path)new Path(partName), null);
            return new DummyPartition(hmsTable, partName, partSpecMap);
        }).collect(Collectors.toList());
    }

    public boolean isPartitioned(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        boolean readsNonCurrentSnapshot;
        if (!hmsTable.getTTable().isSetId()) {
            return false;
        }
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Snapshot snapshot = IcebergTableUtil.getTableSnapshot(table, hmsTable);
        boolean bl = readsNonCurrentSnapshot = snapshot != null && !snapshot.equals(table.currentSnapshot());
        if (readsNonCurrentSnapshot && this.hasUndergonePartitionEvolution(table)) {
            return false;
        }
        return table.spec().isPartitioned();
    }

    public Partition getPartition(org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> partitionSpec, Context.RewritePolicy policy) throws SemanticException {
        this.validatePartSpec(table, partitionSpec, policy);
        return this.getPartitionImpl(table, partitionSpec);
    }

    private Partition getPartitionImpl(org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> partitionSpec) throws SemanticException {
        try {
            String partName = Warehouse.makePartName(partitionSpec, (boolean)false);
            return new DummyPartition(table, partName, partitionSpec);
        }
        catch (MetaException e) {
            throw new SemanticException("Unable to construct name for dummy partition due to: ", (Throwable)e);
        }
    }

    public List<String> getPartitionNames(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec) throws SemanticException {
        Table icebergTable = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return IcebergTableUtil.getPartitionNames(icebergTable, partitionSpec, false);
    }

    public ColumnInfo getColumnInfo(org.apache.hadoop.hive.ql.metadata.Table hmsTable, String colName) throws SemanticException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Deserializer deserializer = hmsTable.getDeserializer();
        Types.NestedField field = icebergTbl.schema().findField(colName);
        if (field != null) {
            try {
                ObjectInspector fieldObjInspector = null;
                StructObjectInspector structObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                for (StructField structField : structObjectInspector.getAllStructFieldRefs()) {
                    if (!field.name().equalsIgnoreCase(structField.getFieldName())) continue;
                    fieldObjInspector = structField.getFieldObjectInspector();
                    break;
                }
                if (fieldObjInspector != null) {
                    return new ColumnInfo(field.name(), fieldObjInspector, hmsTable.getTableName(), false);
                }
                throw new SemanticException(String.format("Unable to fetch column type of column %s since we are not able to infer its object inspector.", colName));
            }
            catch (SerDeException e) {
                throw new SemanticException(String.format("Unable to fetch column type of column %s due to: %s", new Object[]{colName, e}));
            }
        }
        throw new SemanticException(String.format("Unable to find a column with the name: %s", colName));
    }

    public boolean canPerformMetadataDelete(org.apache.hadoop.hive.ql.metadata.Table hmsTable, String branchName, SearchArgument sarg) {
        boolean bl;
        block12: {
            Expression exp;
            try {
                exp = HiveIcebergFilterFactory.generateFilterExpression(sarg);
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to create Iceberg filter, skipping metadata delete: ", (Throwable)e);
                return false;
            }
            Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
            if (ExpressionUtil.selectsPartitions(exp, table, false)) {
                return true;
            }
            TableScan scan = (TableScan)((TableScan)((TableScan)((TableScan)table.newScan().filter(exp)).caseSensitive(false)).includeColumnStats()).ignoreResiduals();
            if (branchName != null) {
                scan.useRef(HiveUtils.getTableSnapshotRef((String)branchName));
            }
            CloseableIterable tasks = scan.planFiles();
            try {
                HashMap evaluators = Maps.newHashMap();
                StrictMetricsEvaluator metricsEvaluator = new StrictMetricsEvaluator(SnapshotUtil.schemaFor(table, branchName), exp);
                bl = Iterables.all(tasks, task -> {
                    DataFile file = (DataFile)task.file();
                    PartitionSpec spec = task.spec();
                    Evaluator evaluator = evaluators.computeIfAbsent(spec.specId(), specId -> new Evaluator(spec.partitionType(), Projections.strict(spec).project(exp)));
                    return evaluator.eval(file.partition()) || metricsEvaluator.eval(file);
                });
                if (tasks == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (tasks != null) {
                        try {
                            tasks.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    LOG.warn("Failed to close task iterable", (Throwable)ioe);
                    return false;
                }
            }
            tasks.close();
        }
        return bl;
    }

    public List<FieldSchema> getPartitionKeys(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        if (!hmsTable.getTTable().isSetId()) {
            return Collections.emptyList();
        }
        Table icebergTable = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return IcebergTableUtil.getPartitionKeys(icebergTable, icebergTable.spec().specId());
    }

    public List<Partition> getPartitionsByExpr(org.apache.hadoop.hive.ql.metadata.Table hmsTable, ExprNodeDesc filter, Boolean latestSpecOnly) throws SemanticException {
        Expression exp = HiveIcebergInputFormat.getFilterExpr(this.conf, (ExprNodeGenericFuncDesc)filter);
        if (exp == null) {
            return ImmutableList.of();
        }
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        int tableSpecId = table.spec().specId();
        HashSet partitions = Sets.newHashSet();
        TableScan scan = (TableScan)((TableScan)((TableScan)((TableScan)table.newScan().filter(exp)).caseSensitive(false)).includeColumnStats()).ignoreResiduals();
        try (CloseableIterable tasks = scan.planFiles();){
            FluentIterable.from(tasks).filter(task -> task.spec().isPartitioned()).forEach(task -> {
                DataFile file = (DataFile)task.file();
                PartitionSpec spec = task.spec();
                if (latestSpecOnly == null || latestSpecOnly.booleanValue() && file.specId() == tableSpecId || !latestSpecOnly.booleanValue() && file.specId() != tableSpecId) {
                    PartitionData partitionData = IcebergTableUtil.toPartitionData(task.partition(), spec.partitionType());
                    String partName = spec.partitionToPath(partitionData);
                    LinkedHashMap partSpecMap = Maps.newLinkedHashMap();
                    Warehouse.makeSpecFromName(partSpecMap, (Path)new Path(partName), null);
                    DummyPartition partition = new DummyPartition(hmsTable, partName, partSpecMap);
                    partitions.add(partition);
                }
            });
        }
        catch (IOException e) {
            throw new SemanticException(String.format("Error while fetching the partitions due to: %s", e));
        }
        return ImmutableList.copyOf(partitions);
    }

    public boolean hasDataMatchingFilterExpr(org.apache.hadoop.hive.ql.metadata.Table hmsTable, ExprNodeDesc filter) {
        SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)((ExprNodeGenericFuncDesc)filter));
        Expression exp = HiveIcebergFilterFactory.generateFilterExpression(sarg);
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        TableScan scan = (TableScan)((TableScan)((TableScan)((TableScan)table.newScan().filter(exp)).caseSensitive(false)).includeColumnStats()).ignoreResiduals();
        boolean result = false;
        try (CloseableIterable tasks = scan.planFiles();){
            result = tasks.iterator().hasNext();
        }
        catch (IOException ioe) {
            LOG.warn("Failed to close task iterable", (Throwable)ioe);
        }
        return result;
    }

    public boolean supportsMergeFiles() {
        return true;
    }

    public List<FileStatus> getMergeTaskInputFiles(Properties properties) throws IOException {
        List<JobContext> jobContextList = IcebergMergeTaskProperties.getJobContexts(properties);
        if (jobContextList.isEmpty()) {
            return Collections.emptyList();
        }
        return new HiveIcebergOutputCommitter().getOutputFiles(jobContextList);
    }

    public MergeTaskProperties getMergeTaskProperties(Properties properties) {
        return new IcebergMergeTaskProperties(properties);
    }

    public void setMergeTaskDeleteProperties(TableDesc tableDesc) {
        tableDesc.setProperty("iceberg.mr.operation.type." + tableDesc.getTableName(), Context.Operation.DELETE.name());
        tableDesc.setProperty("file.sink.write.operation." + tableDesc.getTableName(), Context.Operation.DELETE.name());
    }

    public boolean hasUndergonePartitionEvolution(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return this.hasUndergonePartitionEvolution(table);
    }

    private static List<FieldSchema> schema(List<VirtualColumn> exprs) {
        return exprs.stream().map(v -> new FieldSchema(v.getName(), v.getTypeInfo().getTypeName(), "")).collect(Collectors.toList());
    }

    private static List<FieldSchema> orderBy(VirtualColumn ... exprs) {
        return HiveIcebergStorageHandler.schema(Arrays.asList(exprs));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ boolean lambda$decomposePredicate$0(Set skipList, ExprNodeDesc nodeDesc) {
        if (nodeDesc.getCols() == null) return false;
        if (!nodeDesc.getCols().stream().anyMatch(skipList::contains)) return false;
        return true;
    }

    static class HiveIcebergNoJobCommitter
    extends HiveIcebergOutputCommitter {
        HiveIcebergNoJobCommitter() {
        }

        @Override
        public void commitJob(JobContext originalContext) {
        }
    }

    private static class NonSerializingConfig
    implements Serializable {
        private final transient Configuration conf;

        NonSerializingConfig(Configuration conf) {
            this.conf = conf;
        }

        public Configuration get() {
            if (this.conf == null) {
                throw new IllegalStateException("Configuration was not serialized on purpose but was not set manually either");
            }
            return this.conf;
        }
    }
}

