/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeDrawingElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.xml.sax.SAXException;

public class OdfGraphicsDocument
extends OdfDocument {
    private static final String EMPTY_GRAPHICS_DOCUMENT_PATH = "/OdfGraphicsDocument.odg";
    static final OdfPackageDocument.Resource EMPTY_GRAPHICS_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfGraphicsDocument.odg");

    public static OdfGraphicsDocument newGraphicsDocument() throws Exception {
        return (OdfGraphicsDocument)OdfDocument.loadTemplate(EMPTY_GRAPHICS_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.GRAPHICS);
    }

    public static OdfGraphicsDocument newGraphicsTemplateDocument() throws Exception {
        OdfGraphicsDocument doc = (OdfGraphicsDocument)OdfDocument.loadTemplate(EMPTY_GRAPHICS_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.GRAPHICS_TEMPLATE);
        doc.changeMode(OdfMediaType.GRAPHICS_TEMPLATE);
        return doc;
    }

    protected OdfGraphicsDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static OdfGraphicsDocument loadDocument(InputStream inputStream) throws Exception {
        return (OdfGraphicsDocument)OdfDocument.loadDocument(inputStream);
    }

    public static OdfGraphicsDocument loadDocument(String documentPath) throws Exception {
        return (OdfGraphicsDocument)OdfDocument.loadDocument(documentPath);
    }

    public static OdfGraphicsDocument loadDocument(File file) throws Exception {
        return (OdfGraphicsDocument)OdfDocument.loadDocument(file);
    }

    public OfficeDrawingElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeDrawingElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        GRAPHICS(OdfDocument.OdfMediaType.GRAPHICS),
        GRAPHICS_TEMPLATE(OdfDocument.OdfMediaType.GRAPHICS_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

